<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : solar.cgi
 * 
 *  Description: Solar panel settings page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 ********************************************************************/
include("/app/config.inc");
$angular_controller="SolarEditCtrl"; 
$title='Solar and Inverter Settings';
include("/app/header.inc");
print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
?>
      <div class="row-fluid">
        <div class='span2' >    
<? displayLeftWidgets();?>              
        </div>
        <div class="span10">
        <ul class="breadcrumb">
  <li><a href="/">Home</a> <span class="divider">/</span></li>
  <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
  <li class="active">Solar and Inverter Settings</li>
</ul>
<h2> <i class="icon-hdd icon-2x"></i> Solar and Inverter Settings</h2>
    <div class="well"> 
    <a ng-cloak class="btn pull-right" href="#" ng-click="helpvisible=!helpvisible"><div ng-show='helpvisible'><i class="icon-chevron-up"></i> Less</div><div ng-hide='helpvisible'><i class="icon-chevron-down"></i> More</div></a>
    Solar and inverter capacity settings can be modified here. See help for more details.
    
    <div ng-cloak ng-show='helpvisible'><h4>Solar</h4>
    Enter the watt hour capacity of your panels here
    <h4>Inverter</h4>
    Enter the inverter capacity in watts
    </div>
    </div>
    <div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{successmsg}}</div><div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{errormsg}}</div>
    <div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<form name="form" class="css-form" novalidate>
<? 
  $arr=ini_get_array("/config/solar.ini","solar");
  $solar_watts=$arr["solar_watts"];
  $inverter_watts=$arr["inverter_watts"];
?>
<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print("You will need to reboot the device for changes to take effect."); ?>';"></div>
<div ng-init="solar_watts=<? print($solar_watts); ?>;"></div>
<div ng-init="inverter_watts=<? print($inverter_watts); ?>;"></div>
 <div class="row-fluid" >
        <div class='span4' >Solar Panel Capacity (Wattts)</div>
        <div class='span4'>
            <input type='number' ng-model="solar_watts"   name='solar_watts' min="100" integer required>            
        </div>
        <div class='span4'><div ng-show='form.solar_watts.$invalid' class="alert">Solar Panel Watts is invalid</div>
        </div>
</div>
 
<div class="row-fluid" >
        <div class='span4' >Inverter Rating (Watts)</div>
        <div class='span4'>
            <input type='number' ng-model="inverter_watts"   name='inverter_watts' min="100" integer required>            
        </div>
        <div class='span4'><div ng-show='form.inverter_watts.$invalid' class="alert">Inverter Watts is invalid</div>
        </div>
</div>


<button class="btn btn-primary btn-large" ng-click="saveSettings()" ng-disabled="form.$invalid">Update Settings</button> 
</form>

        </div><!--/span-->
      </div><!--/row-->

     <script>
     var app = angular.module('myApp', []);
function SolarEditCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";
   $scope.viewLog=function () {
        window.open($scope.accessfile,'_blank');
   }
   
   $scope.saveSettings=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       $http.post('/app/configsave.cgi?config=solar.ini&section=solar',"solar_watts="+$scope.solar_watts+"&inverter_watts="+$scope.inverter_watts)
        .then(function (response) {
          var data = response.data;      
          $scope.successmsg=(data.status==1)?"Saved Settings":"";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

}</script>
<? include("/app/footer.inc"); ?>