<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : usb.cgi
 * 
 *  Description: USB settings page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *				    v1.1
 * Ruchir Sharma        17/10/17    v1.1
 * Akash Heimlich       19/06/18    v2.0    WattmonOS3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="NetworkCtrl"; 
$title='USB Settings';
include("/app/header.inc");
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','usb')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-group"></i> <? print(lang('PAGE_TITLE','usb')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','usb')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/usb.cgi';"><i class="icon-refresh"></i> <? print(lang('REFRESH','usb')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked' ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','usb')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  <? print(lang('HELP1','usb')) ?><br>
  <? print(lang('HELP2','usb')) ?><br>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<!--VARIABLES-->
<?
    
    $stat=getusbstat(); 
    $enabled=ini_get("/config/usb.ini","usb","usb_enabled",0);
?>
<div ng-init="enabled=<? print($enabled); ?>;"></div>

<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('USB_SETTINGS','usb')) ?></h5>
        <p class="card-text">    
            <div class="form-group">
                <label for="enabled"><small class='text-muted'><? print(lang('USB','usb')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="enabled" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('NO','usb')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="enabled" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('YES','usb')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('USB_HELP','usb')) ?></small>
            </div> 
        </p>
    </div>
</div>
<br>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('USB_DEVICES','usb')) ?></h5>
        <p class="card-text">    
<?
    if ($stat['enabled']) {
        if ($stat['state']=="RUNNING") {
            print("<div class='row'><div class='col-sm'>Status</div><div class='col-sm'>Device attached.</div></div>");
            print("<div class='row'><div class='col-sm'>Device ID</div><div class='col-sm'>".$stat['VID'].":".$stat['PID']."</div></div>");
            print("<div class='row'><div class='col-sm'>Device</div><div class='col-sm'>".$stat['device']."</div></div>");
            print("<div class='row'><div class='col-sm'>Supports CDC</div><div class='col-sm'>".$stat['CDC']."</div></div>");
        } else {
            if ($stat['state']=="HOLDING") {
                print("<div class='row'><div class='span4'>Status</div><div class='span8'>Unknown Device attached.</div></div>");
                print("<div class='row'><div class='span4'>Device ID</div><div class='span8'>".$stat['VID'].":".$stat['PID']."</div></div>");
            } else {
                if ($stat['state']==0) {
                    print("<div class='row'><div class='span4'>Status</div><div class='span8'>Ready, no device attached</div></div>");
                } else 
                    print("<div class='row'><div class='span4'>Status</div><div class='span8'>".$stat['state']."</div></div>");
            }
        }
      } else print("USB is not enabled in this firmware.  If your device hardware revision is below 1.3, USB will not function properly.  If you do not require USB support, disable it to free up memory.");
      ?>
        </p>
    </div>
</div>
</form>
<? include("/app/footer.inc"); ?>

<script type='text/javascript'>
var app = angular.module('myApp', []);

/**
* Network controller object used by Angular.JS
* @param $scope Application scope
* @param $http  HTTP object used for ajax requests
*/
function NetworkCtrl($scope,$http) {
    var self = this;
    $scope.infomsg="";
       $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";

     $scope.isChecked=function(invert) {
    if (!invert) {
        if (Number($scope.enabled)) return 'checked';
        return 'unchecked';
   } else {
       if (!Number($scope.enabled)) return 'checked';
        return 'unchecked';
   }
   }

    /**
    * Posts settings to networksave.cgi and processes the response
    */
    $scope.saveSettings=function () {
        $scope.successmsg="";
        $scope.errormsg="";
        $scope.infomsg="";
        $http.post('/app/configsave.cgi?config=usb.ini&section=usb',"usb_enabled="+$scope.enabled)
        .then(function (response) {
          var data = response.data;      
          $scope.successmsg=(data.status==1)?"Saved Settings.  A reboot is required to activate the new settings.":"";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });

    }
}
</script>

