<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : user.cgi
 * 
 *  Description: User settings page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Ruchir Sharma        17/10/17    v1.1
 * Akash Heimlich       17/05/18    v2.0
 ********************************************************************/
include("/app/config.inc");
$angular_controller="UserEditCtrl"; 
$title=lang('USER_SETTINGS','user');
include("/app/header.inc");
print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('USER_SETTINGS','user')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-group"></i> <? print(lang('USER_SETTINGS','user')) ?></h2>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="saveSettings()" ng-hide='settings_locked' ng-disabled="form.$invalid "><i class="icon-check"></i> <? print(lang('APPLY','user')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <h4><? print(lang('ADMIN_USER','user')) ?></h4><? print(lang('ADMIN_USER_DESC1','user')) ?><br>
<? print(lang('ADMIN_USER_DESC2','user')); print(lang('ADMIN_USER_DESC3','user')); ?> <strong>admin</strong> <? print(lang('AND','user')) ?> <strong>admin</strong>.<br>
    <h4><? print(lang('GUEST_USERNAME','user')); ?></h4><? print(lang('GUEST_USER_DESC','user')); ?><br>
    <h4><? print(lang('DEVICE_NAME','user')); ?></h4><? print(lang('DEVICE_NAME_DESC1','user')); print(lang('DEVICE_NAME_DESC2','user')); ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<!-- VARIABLES -->
<? 
  // Variabe Initialization
  if (nvram_get('use_nvram')==1) {
      $device=nvram_get("user_device","Wattmon");
      $lang=nvram_get("user_lang","en");
      $username=nvram_get("username","admin");
      $password=nvram_get("password","admin");
      $guestusername=nvram_get("guestusername","guest");
      $guestpassword=nvram_get("guestpassword","guest");
      
      $autosubnet=nvram_get("autosubnet",0);  
      $kiosk=0;
  } else {
      $device=ini_get("/config/user.ini","user","device","Wattmon");
      $lang=ini_get("/config/user.ini","user","lang","en");
      $username=ini_get("/config/user.ini","user","username","admin");
      $password=ini_get("/config/user.ini","user","password","admin");
      $guestusername=ini_get("/config/user.ini","user","guestusername","guest");
      $guestpassword=ini_get("/config/user.ini","user","guestpassword","guest");
      
      $autosubnet=ini_get("/config/user.ini","user","autosubnet",0);  
      $kiosk=ini_get("/config/user.ini","user","kiosk",0);
      $ezconfig_lite=ini_get("/config/user.ini","user","ezconfig_lite",0);  
  }
?>
<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print(lang('NEED_REBOOT')); ?>';"></div>
<div ng-init="user_name='<? print($username); ?>';"></div><div ng-init="password='<? print($password); ?>';"></div>
<div ng-init="guest_user_name='<? print($guestusername); ?>';"></div><div ng-init="guest_password='<? print($guestpassword); ?>';"></div>
<div ng-init="autosubnet=<? print($autosubnet); ?>;"></div><div ng-init="device='<? print($device); ?>';"></div>
<div ng-init="lang='<? print($lang); ?>';">
<div ng-init="ezconfig_lite='<? print($ezconfig_lite); ?>';">
<div ng-init="kiosk='<? print($kiosk); ?>';">

<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('ADMIN_SETTINGS','user')) ?></h5>
        <p class="card-text">    

          <div class="form-group">
            <label for="user_name"><? print(lang('ADMIN_USERNAME','user')) ?></label>
            <input type="text" class="form-control" id="user_name" ng-model="user_name" aria-describedby="userHelp" placeholder="Enter username">
            <small id="userHelp" class="form-text text-muted"><? print(lang('ADMIN_USERNAME_HELP','user')) ?></small>
          </div>
          <div class="form-group">
            <label for="password"><? print(lang('ADMIN_PASSWORD','user')) ?></label>
            <input type="password" class="form-control" ng_model="password" id="password" placeholder="Password">
          </div>
        </p>
    </div>
</div>
<br/>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('GUEST_SETTINGS','user')) ?></h5>
        <p class="card-text">   
           <div class="form-group">
            <label for="guest_user_name"><? print(lang('GUEST_USERNAME','user')) ?></label>
            <input type="text" class="form-control" id="guest_user_name" ng-model="guest_user_name" aria-describedby="userHelp" placeholder="Enter username">
            <small id="userHelp" class="form-text text-muted"><? print(lang('GUEST_USERNAME_HELP','user')) ?></small>
          </div>
          <div class="form-group">
            <label for="guest_password"><? print(lang('GUEST_PASSWORD','user')) ?></label>
            <input type="password" class="form-control" ng_model="guest_password" id="guest_password" placeholder="Password">
          </div>
        </p>
    </div>
</div>
<br/>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('DEVICE_SETTINGS','user')) ?></h5>
        <p class="card-text">   
  
           <div class="form-group">
            <label for="device"><? print(lang('DEVICE_NAME','user')) ?></label>
            <input type="text" class="form-control" id="device" ng-model="device" aria-describedby="deviceHelp" placeholder="<? print(lang('LABEL_DEVICE','user')) ?>">
            <small id="deviceHelp" class="form-text text-muted"><? print(lang('DEVICE_NAME_HELP','user')) ?></small>
          </div>
           <div class="form-group">
            <label for="kiosk"><? print(lang('KIOSK','user')) ?></label>
            <select ng-model="kiosk" name='kiosk' class="custom-select custom-select-sm">
                <option value='0'>Disabled</option>
                <option value='1'>Enabled</option>
            </select>
            <small id="langH" class="form-text text-muted"><? print(lang('KIOSK_HELP','user')) ?></small>
          </div>
        <div class="form-group">
            <label for="ezconfig_lite">EZConfig Lite</label>
            <select ng-model="ezconfig_lite" name='ezconfig_lite' class="custom-select custom-select-sm">
                <option value='0'>Disabled</option>
                <option value='1'>Enabled</option>
            </select>
            <small id="langH" class="form-text text-muted">Allow guest users to reconfigure inverters using EZConfig lite</small>
          </div>          
          <div class="form-group">
            <label for="lang"><? print(lang('DEVICE_LANGUAGE','user')) ?></label>
            <select ng-model="lang" name='lang' class="custom-select custom-select-sm">
                <option value='en'>English</option>
                <option value='es'>Espa&ntilde;ol</option>
        		<option value='de'>Deutsch</option>
        		<option value='hi'>हिंदी</option>
        		<option value='ta'>தமிழ</option>
            </select>
            <small id="langH" class="form-text text-muted"><? print(lang('DEVICE_LANGUAGE_HELP','user')) ?></small>
          </div>
  
  </p>
    </div>
</div>

</form>
     <script>
     var app = angular.module('myApp', []);
     function UserEditCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";
   $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
   $scope.saveSettings=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       if (!$scope.device) {
            $scope.errormsg="<? print(lang('ERROR_DEVICE_NAME','user')) ?>";
            return;
       }
       if (!$scope.username.length) {
            $scope.errormsg="<? print(lang('ERROR_ADMIN_USER','user')) ?>";
            return;
       }
       if (!$scope.guest_user_name.length) {
            $scope.errormsg="<? print(lang('ERROR_GUEST_USER','user')) ?>";
            return;
       }
       if (!$scope.password || ($scope.password.length < 3)) {
            $scope.errormsg="<? print(lang('ERROR_ADMIN_PASSWORD','user')) ?>";
            return;
       }
       if (!$scope.guest_password || ($scope.guest_password.length < 3)) {
            $scope.errormsg="<? print(lang('ERROR_GUEST_PASSWORD','user')) ?>";
            return;
       }
       
       /*if ($scope.device.indexOf(" ")) {
            $scope.errormsg="Spaces are not allowed in the device name";
            return; 
       
       }*/
       //alert();
       //
       <? if (nvram_get("use_nvram")==1) { ?>
       $http.post('/app/configsavenvram.cgi',"user_lang="+$scope.lang+"&user_device="+$scope.device+"&username="+$scope.user_name+"&password="+$scope.password+"&guestusername="+$scope.guest_user_name+"&guestpassword="+$scope.guest_password+"&autosubnet="+($scope.autosubnet?1:0))
       <? } else { ?>
       $http.post('/app/configsave.cgi?config=user.ini&section=user',"ezconfig_lite="+$scope.ezconfig_lite+"&lang="+$scope.lang+"&device="+$scope.device+"&username="+$scope.user_name+"&password="+$scope.password+"&guestusername="+$scope.guest_user_name+"&guestpassword="+$scope.guest_password+"&autosubnet="+($scope.autosubnet?1:0)+"&kiosk="+$scope.kiosk)
       <? } ?>
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"<? print(lang('MSG_SAVED','user')) ?>":"<? print(lang('ERROR_SAVING','user')) ?>";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="<? print(lang('ERROR_SAVING','user')) ?>";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

}</script>
<? include("/app/footer.inc"); ?>



