function GraphCtrl($scope) {
container=document.getElementById("containergraph");
//alert("graph");
       {
    var numsecs=300;
    var
    max=10,
    d1 = [],
        d2 = [],
        d3 = [],
        d4 = [],
        d5 = [],
        // Data
        ticks = [
            [-40, "Lower"], 20, 0, 20, [40, "Upper"]
        ],
        // Ticks for the Y-Axis
        graph;

// blank data to start
    for (var i = 0; i <= numsecs; i += 1) {
        d1.push([i, 0]);
        d2.push([i, 0]);
        d3.push([i, 0]);
        d4.push([i, 0]);
        
    //    if (i.toFixed(1) % 1 == 0) {
      //      d5.push([i, 2 * i]);
        //}
    }

   

    function ticksFn(n) {
        num=Math.abs((Number(n)-numsecs));
        if (num>=60) {
            return (Math.round(num/6)/10)+"m ago";
        }
        return num + 's ago';
    }

    function myFormat(a) {
        return a.y+" Watts";
    }
    function update() {
        d1.splice(0,1);    
        d2.splice(0,1);
        d3.splice(0,1);
        d4.splice(0,1);
     //  alert("hi");
        d1.push([numsecs,Number($scope.livedata.solar_charge_current)*Number($scope.livedata.voltage)]);
        d2.push([numsecs,Number($scope.livedata.grid_charge_current)*Number($scope.livedata.voltage)]);
        d3.push([numsecs,Number(-$scope.livedata.grid_discharge_current)*Number($scope.livedata.voltage)]);
        d4.push([numsecs,(Number($scope.livedata.solar_charge_current)+Number($scope.livedata.grid_charge_current)+Number(-$scope.livedata.grid_discharge_current))*Number($scope.livedata.voltage)]);
        
        max=10;
        for (i=0;i<d1.length;i++) {
            d1[i][0]=i;
            d2[i][0]=i;
            d3[i][0]=i;
            d4[i][0]=i;
            if (Number(d1[i][1])>max) max=d1[i][1];
            if (Number(d2[i][1])>max) max=d2[i][1];
            if (Math.abs(Number(d3[i][1]))>max) max=Math.abs(d3[i][1]);
            if (Math.abs(Number(d4[i][1]))>max) max=Math.abs(d4[i][1]);
            
        }
        ticks = [
            [Math.round(-max),Math.round(-max)+"W"], Math.round(-max/2), 0, Math.round(max/2), [Math.round(max),Math.round(max)+"W"]
        ];
    graph = Flotr.draw(container, [{
        data: d1,
        label: 'Solar',
        lines: {
            fill: true
        }
    }, {
        data: d2,
        label: 'Grid Charge'
    }, {
        data: d3,
        label: 'Load',
        lines: {
            fill: true
        }
    }, {
        data: d4,
        label: 'Energy Balance'
    }], {
        colors: ['#C0D800','#00A8F0','#CB4B4B', '#9440ED'],
       
        xaxis: {
            noTicks: 5,
             margin:false,
            // Display 7 ticks.
            tickFormatter: ticksFn,
            // Displays tick values between brackets.
            min: 1,
            // Part of the series is not displayed.
            max: numsecs // Part of the series is not displayed.
        },
        yaxis: {
//            ticks: ticks,
            // Set Y-Axis ticks
//            min:-max,
            labelsAngle:90,
            autoscale:true,
            autoscaleMargin:0.1
//            max: max // Maximum value along Y-Axis
        },
        grid: {
            verticalLines: true,
            backgroundColor: {
                colors: [
                    [0, '#fff'],
                    [1, '#fff']
                ],
                start: 'top',
                end: 'bottom'
            }
        },
        legend: {
            position: 'nw'
        },
        mouse: {
            track:true,
            trackFormatter:myFormat,
            relative:true
        },
        title: '',
        subtitle: ''
    });
    //setTimeout(update,1000);
    }
    setTimeout(update,1000);
}


   
    // this is our updater function
    $scope.$watch('livedata', function(liveData) {        
        /**
        * IMPORTANT: Must convert the data (which is a string) to numbers
        */
        if(angular.isDefined(liveData)) {
            solar_charge_current=Math.round(Number(liveData.solar_charge_current)*10)/10;
            grid_charge_current=Math.round(Number(liveData.grid_charge_current)*10)/10;
            grid_discharge_current=Math.round(Number(liveData.grid_discharge_current)*10)/10;
            
            if (solar_charge_current>max) max=Math.ceil(solar_charge_current);
            if (grid_charge_current>max) max=Math.ceil(grid_charge_current);
            if (grid_discharge_current>max) max=Math.ceil(grid_discharge_current);
            if (solar_charge_current+grid_charge_current > max) max=solar_charge_current+grid_charge_current;
            
            update();
        }
    });
    
    
}