<?
/*
* YHY522 Mifare Reader on Serial Port
*/
function send_command($cmd,$arr) {
    global $f;
    fread($f,filesize($f));
    $send=array();
    $send[]=0xAA;
    $send[]=0xBB;
    $send[]=(2+sizeof($arr));
    $send[]=$cmd;
    //$send[]=(2+sizeof($arr));
    $xor_sum=$send[2] ^ $send[3];
    for ($i=0;$i<sizeof($arr);$i++) {
        $xor_sum = $xor_sum ^ $arr[$i];
        $send[]=$arr[$i];
    }
    $send[]=$xor_sum & 0xFF;
    //print_r($send);
    for ($i=0;$i<sizeof($send);$i++) {
        fwrite($f,$send[$i]);
    }
}
function read_command() {
    global $f;
    $res=array();
    $len=filesize($f);
    
    for ($i=0;$i<$len;$i++) {
        $st=fread($f,1);
        
        $b=charat($st,0);
        if ($b<0) $b = 256+$b;
        $res[]=$b;
    };
    return $res;
}

function mifare_init() {
    $arr=array(0x44);
    send_command(0,$arr);
    sleep(200);
    $res=read_command();
    if ($res[4]==0x44) {
        
    	$arr=array(0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x05);
	
    	send_command(0x04,$arr);
        sleep(200);
        $res=read_command();
        //print_r($res);
        if ($res[3]==0x4)

            return 1;
        else return 0;
    };
    return 0;
}

function mifare_read_block($block,$key_num,$key) {
    $arr=array($key_num,$block);
    for ($i=0;$i<6;$i++) {
        $arr[]=$key[$i];
    }
    send_command(0x21,$arr);
    sleep(100);
    $res=read_command();
    if ($res[3]==0x21) {
        $block=array();
        for ($i=0;$i<16;$i++) {
            $block[]=$res[4+$i];
        }
        return $block;
    }
    return $res[3]; // error code
}

function mifare_write_block($block,$key_num,$key,$data) {
    $arr=array($key_num,$block);
    for ($i=0;$i<6;$i++) {
        $arr[]=$key[$i];
    }
    for ($i=0;$i<16;$i++) 
        $arr[]=$data[$i];
    
    send_command(0x22,$arr);
    sleep(200);
    $res=read_command();
    print_r($res);
    if ($res[3]==0x22) {
        return 1;
    }
    return $res[3]; // error code
}

function mifare_card_id() {
    $arr=array();
    send_command(0x20,$arr);
    sleep(200);
    $res=read_command();
    if ($res[2]==6) {
        $card=array();
        for ($i=0;$i<4;$i++) {
            $card[]=$res[4+$i];
        }
        return $card;
    }
    return 0;
    //print_r($res);
}

function mifare_init_value($block,$key_num,$key, $val) {
    $arr=array($key_num,$block);
    for ($i=0;$i<6;$i++) {
        $arr[]=$key[$i];
    }
    //print_r($arr);die();
    $arr[]=$val & 0xFF;
    $arr[]=$val >> 8 & 0xFF;
    $arr[]=$val >> 16 & 0xFF;
    $arr[]=$val >> 24 & 0xFF;

    print_r($arr);
    send_command(0x23,$arr);
    sleep(200);
    $res=read_command();
    if ($res[3]==0x23) {
        return 1;
    }
    return $res[3]; // error code
}

function mifare_dec_value($block,$key_num,$key, $val) {
    $arr=array($key_num,$block);
    for ($i=0;$i<6;$i++) {
        $arr[]=$key[$i];
    }
    $arr[]=$val & 0xFF;
    $arr[]=$val >> 8 & 0xFF;
    $arr[]=$val >> 16 & 0xFF;
    $arr[]=$val >> 24 & 0xFF;
    
    
    
    send_command(0x26,$arr);
    sleep(200);
    $res=read_command();
    //print("DEC BLOCK");
//    print_r($res);
    if ($res[3]==0x26) {
        return 1;
    }
    return $res[3]; // error code
}
function mifare_inc_value($block,$key_num,$key, $val) {
    $arr=array($key_num,$block);
    for ($i=0;$i<6;$i++) {
        $arr[]=$key[$i];
    }
    //print_r($arr);die();
    $arr[]=$val & 0xFF;
    $arr[]=$val >> 8 & 0xFF;
    $arr[]=$val >> 16 & 0xFF;
    $arr[]=$val >> 24 & 0xFF;
    //print_r($arr);
    send_command(0x25,$arr);
    sleep(200);
    $res=read_command();
    //   print("INC BLOCK");
    //print_r($res);
    if ($res[3]==0x25) {
        return 1;
    }
    return $res[3]; // error code
}

function mifare_read_value($block,$key_num,$key) {
    $arr=array($key_num,$block);
    for ($i=0;$i<6;$i++) {
        $arr[]=$key[$i];
    }
    send_command(0x24,$arr);
    sleep(200);
    $res=read_command();
   // print_r($res);
    if ($res[3]==0x24) {
        $val=0;
        for ($i=0;$i<4;$i++) {
            $val=$val << 8;
            $val=$val | $res[7-$i];
        }
        return array($val);
    }
    return $res[3]; // error code
}

function mifare_change_sector_keys($sector,$key_num,$key,$new_key_a,$new_key_b) {
    $arr=array($key_num,$sector);
    for ($i=0;$i<6;$i++) {
        $arr[]=$key[$i];
    }
    for ($i=0;$i<6;$i++) {
        $arr[]=$new_key_a[$i];
    }
    $arr[]=0xFF;
    $arr[]=0x07;
    $arr[]=0x80;
    $arr[]=0x69;
    for ($i=0;$i<6;$i++) {
        $arr[]=$new_key_b[$i];
    }
    send_command(0x06,$arr);
    sleep(200);
    $res=read_command();
   // print_r($res);
    if ($res[3]==0x06) {
        return 1;
    }
    return $res[3]; // error code
}

function mifare_sector_lock($sector,$key,$val) {
    $arr=array($sector);
    for ($i=0;$i<6;$i++) {
        $arr[]=$key[$i];
    }
    $arr[]=$val;
    send_command(0x07,$arr);
    sleep(200);
    $res=read_command();
    //print_r($res);
    if ($res[3]==0x07) {
        return 1;
    }
    return $res[3]; // error code
}

function mifare_read_sector($sector,$key_num,$key) {
    $arr=indexed_array(1,48);
    for ($i=0;$i<3;$i++) {
        $res=mifare_read_block($sector*4+$i,$key_num,$key);
        for ($j=0;$j<16;$j++) {
            $arr[$i*16+$j]=$res[$j];
        }
        
    }
    return $arr; // error code
}


$f=fseropen(19200,0);

?>
