<?
/**
 * @file debug.inc
 * @author Akash Heimlich
 * @version 1.0
 * @date 14/04/2021
 * @description Common debug functions
 */
 
/**
  * debug_start
  *
  * Start a debug session (record timestamp)
  *
  */ 
$debug_timestamp=0; 
$DEBUG_ON=1;

function debug_start() {
    global $debug_timestamp;
    $debug_timestamp=microtime();
    global $DEBUG_ON;
    if (!$DEBUG_ON) return;
    
    print("<pre>");
}

function debug_print($message,$cat,$color) {
    global $debug_timestamp;
    global $DEBUG_ON;
    if (!$DEBUG_ON) return;
    
    if (!$color) $color='black';
    print("<span style='color:".$color.";'>");
    print ((microtime()-$debug_timestamp)." ms : ");
    if ($cat) print("[".$cat."] ");
    print($message);
    print("</span>\r\n");
}

?>



