<?
/**
 * @package FlatFileDB
 * @author Akash Heimlich
 * @description dump data to a flat file db
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function FlatFileDB_install($val) {
        FlatFileDB_enable();
        return 1;
    }
     
    function FlatFileDB_uninstall() {
        setPackageStatus("FlatFileDB",0);
        return 1;
    }
    
    function FlatFileDB_enable() {
        setPackageStatus("FlatFileDB",2);
        return 1;
    }
    
    function FlatFileDB_disable() {
        setPackageStatus("FlatFileDB",3);
        return 1;
    }
    
    /* this is called at system boot */
    function FlatFileDB_init() {
        
         /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/FlatFileDB.cgi?action=configure';
        $arr['title']='FlatFile DB';
        $arr['icon']='icon-hdd';
        $arr['desc']='DB settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
    
        // runs this file once a minute
        if (file_exists('/package/FlatFileDBMinLog.inc')) 
            $_GLOBALS['hooks']['minlog'][]='/package/FlatFileDBMinLog.inc';
            
        return 1;
    }
    
    function FlatFileDB_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="FlatFileDB"; 
        $title='Configure Package FlatFileDB';
        $config_file="FlatFileDB.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">Test Widget</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> FlatFileDB Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Configure FlatFileDB here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
This widget is a test widget.  Put your text here. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Widget Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="widget_test='<? print(ini_get("/config/".$config_file,$config_section,"test","")); ?>';">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='widget_test'>Test Value</label>
		            <div class="controls">
			            <input type='text' ng-model="widget_test"  name='widget_test' title="Enter a value to be saved to a config file for re-use later" data-rel="tooltip"> 
			        </div>
		        </div>
		</fieldset>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function FlatFileDB($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="test="+$scope.widget_test;
       post_config="FlatFileDB.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>


