<?
/**
 * @package FlatFileDB Min Log
 * @author Akash Heimlich
 * @description Runs once a minute
 */
// debugout(1);

    $y=strftime("%Y",time());
    $y2=strftime("%Y",time());
    $day=strftime("%d",time());
    $m=strftime("%m",time());
    
    
    $base_dir=ini_get("/config/flatfiledb.ini","config","folder","/logs/flatfiledb");
    
    $db_name='/flatfiledb.dat';
    $db_info=ini_get_array($base_dir."/db.ini",'config');
    
    mkdir($base_dir);
    
    $f_log=fopen($base_dir.$db_name,"a");
    print("Open ".$base_dir.$db_name);
    if ($f_log) {
        $st=$_GLOBALS['log0_line'];//'0,0,0,0,0,0,0,0,0,0,0,0';
        
        $f_arr=explode($st,',');
        
        log($_GLOBALS['log0_line']);
        if (sizeof($f_arr)) {
            // if the number of rows is not set, we can set it, otherwise it won't log properly because it assumes the row count has to match
            if (!$db_info['num_rows']) {
                ini_set($base_dir."/db.ini",'config','num_rows',sizeof($f_arr)-1);
                ini_set($base_dir."/db.ini",'config','interval',1);
                ini_set($base_dir."/db.ini",'config','start_ts',get_rounded_ts(time()));
                $prefix=strftime('%Y%m%d',time());
                log("Creating a new database file as the number of rows has changed");
                fclose($f_log);
                
                rename($base_dir.$db_name,$base_dir.$prefix.$db_name);
                
                $f_log=fopen($base_dir.$db_name,"w");
                
            } else {
                $start_ts = $db_info['start_ts'];
                
                $offset=get_file_offset(time());
                
                log("Seeking to offset ".$offset." and fs=".filesize($f_log));
                
                $fs=filesize($f_log);            
                while ($offset>$fs) {
                    for ($i=0;$i<$db_info['num_rows'];$i++) {
                        $v=pack('f',0.0);
                        fwrite($f_log,$v);
                        $fs+=4;
                    }
                    //print("write row.\r\n");
                };
                fseek($f_log,$offset);
                log("Writing ".(sizeof($f_arr)-1)." rows");
                for ($i=1;$i<sizeof($f_arr);$i++) {
                    $v=pack('f',floatval($f_arr[$i]));
                    fwrite($f_log,&$v);
                }
                fclose($f_log);    
            }  
        }
            
    } 
	
    function get_rounded_ts($ts) {
        return intval($ts/60)*60;
    }
    
    function get_file_offset($ts) {
        global $db_info;
        global $f_log;
        $rounded_ts=get_rounded_ts($ts);
        $offset=($rounded_ts-$db_info['start_ts'])/60*4*$db_info['num_rows']*$db_info['interval'];
        return $offset;        
    }
// end
?>

