<pre><?
include("/lib/uphp/debug.inc");

debug_start();

debug_print("Checking... cnt=".$_GLOBALS['exportcustomint'],'ip export custom','blue');

max_execution_time(30);
define("CUSTOM_EXPORT_LINES", 5);
$prefix='';
if ($_SERVER['HW_PLATFORM']==11) {
    $prefix='0:';
}
if ($_SERVER['HW_PLATFORM']>=20) {  // ULTRA
        $prefix=intval($_GLOBALS['log_drive']).':';
}

mkdir($prefix."/ini");


$ini                 = ini_get_array("/config/dataexport.ini", "export");
$ini['custom_lines'] = intval($ini['custom_lines']);
$debug_custom_export = intval($ini['debug_custom_export']);



if (!$ini['custom_lines'])
    $ini['custom_lines'] = CUSTOM_EXPORT_LINES;
//print($_GLOBALS['exportcustomint']);
$_GLOBALS['exportcustomint']++;
if ($_GLOBALS['exportcustomint'] >= intval($ini['intervalcustom'])) {
    if (intval($ini['noheader']) != 1) {
        if (file_exists("/config/csv_headers.txt")) {
            debug_print('Found static csv_headers','headers');
            $fh=fopen("/config/csv_headers.txt","r");
            $data='';
            while (!feof($fh)) {
                
                $data.=fread($fh,1024);
            }
            $data.="\r\n";
            fclose($fh);
        } else {
            $num_groups = ini_get("/config/datalog.ini", "data", "num_groups", 0);
            $data       = '"ts",';
            for ($i = 0; $i < $num_groups; $i++) {
                $s = ini_get("/config/datalog.ini", "data", 'group' + $i + 'status', 0);
                
                if ($s == 1) {
                    
                    $logfile2 = "/logs/log_" + $i + ".ini";
                    $arr      = ini_get_array($logfile2);
                    
                    $grpnvar = ini_get("/config/datalog.ini", "data", 'group' + $i + "numvar", 0);
                    for ($j = 0; $j < $grpnvar; $j++) {
                        $vt   = ini_get("/config/datalog.ini", "data", 'group' + $i + 'var' + $j + 'vartype', 0);
                        $vfn  = ini_get("/config/datalog.ini", "data", 'group' + $i + 'var' + $j + 'varfn', 0);
                        $vval = ini_get("/config/datalog.ini", "data", 'group' + $i + 'var' + $j + 'varval', 0);
                        if ($vt == 1) { // system
                            $varst = ini_get("/config/sysvars.ini", "sysvars", "sysvar" . $vval . "name", "");
                            $varr  = explode($varst, ';');
                            if ($varr[0] == 'V') {
                                $varst = $varr[1];
                            } else {
                                if ($varr[0] == 'G') {
                                    $varst = $varr[2] . $varr[1];
                                }
                            }
                        } else {
                            if ($vt == 2) { // device
                                $varst = ini_get("/config/roles.ini", "roles", "role" . $vval, "");
                            }
                            if ($vt == 3) { // global
                                //$varst=$vval;
                                $varst = ini_get("/config/datalog.ini", "data", 'group' + $i + 'var' + $j + 'varval', '');
                            }
                        }
                        //$data.="\"".$varst."\":\"".$arr['data']['p'.$j]."\"";
                        $data .= '"' . $varst . '"';
                        if ($j < ($grpnvar - 1))
                            $data .= ",";
                    }
                    
                }
            }
            $data = $data . '\r\n';
        }
    } else
        $data = '';
    $last_export_time    = ini_get($prefix."/ini/datalog_status.ini", "custom", "last_export", 0);
    $last_export_file    = ini_get($prefix."/ini/datalog_status.ini", "custom", "file", "");
    $last_export_filepos = ini_get($prefix."/ini/datalog_status.ini", "custom", "filepos", 0);
    
    $logdir = $prefix."/logs/" + strftime("%Y", time()) . "/" . strftime("%m", time()) . "/";
    debug_print("1. last_export_file=" . $last_export_file,'file','blue');
    // month change bug
    // if this is new, just start from now
    if (!$last_export_file) {
        $last_export_time    = time();
        $m                   = strftime("%M", time());
        $h                   = strftime("%H", time());
        $last_export_file    = strftime("%Y%m%d", time()) . "_0.csv";
        $last_export_filepos = filesize($logdir . $last_export_file);
        ini_set($prefix."/ini/datalog_status.ini", "custom", "filepos", $last_export_filepos);
        ini_set($prefix."/ini/datalog_status.ini", "custom", "last_export", time());
        ini_set($prefix."/ini/datalog_status.ini", "custom", "file", $last_export_file);
        log("last_export_file not set, updating file pointer.");
        
    } else {
        $y = substr($last_export_file, 0, 4);
        $m = substr($last_export_file, 4, 2);
        
        $logdir = $prefix."/logs/" + $y . "/" . $m . "/";
    }
    debug_print("2. last_export_file=" . $last_export_file,'file');
    $last_size = filesize($logdir . $last_export_file);
    debug_print($last_size . " " . $last_export_filepos);
    debug_print("Comparison : last_size <= last_export_filepos + 10 = ".($last_size <= $last_export_filepos + 10),'file','blue');
    if ($last_size <= $last_export_filepos + 10) {
        $y = substr($last_export_file, 0, 4);
        $m = substr($last_export_file, 4, 2);
        $d = substr($last_export_file, 6, 2);
        debug_print("fn=" . $y . " " . $m . " " . $d,'file','green');
        $t = mktime(0, 0, 0, intval($m) - 1, intval($d), intval($y)) + 86400;
        
        $m = strftime("%m", $t);
        $d = strftime("%d", $t);
        $y = strftime("%Y", $t);
        if ($export_only) {
            $logdir          = $prefix."/logs/";
            $new_export_file = "log_" . $group_number . ".csv";
        } else {
            $logdir          = $prefix."/logs/" + $y . "/" . $m . "/";
            $new_export_file = strftime("%Y%m%d", $t) . "_0.csv";
        }
        debug_print("ts=".$t . " " . $logdir,"file","green");
        
        debug_print("Check for new file " . $new_export_file);
        if (!file_exists($logdir . $new_export_file)) {
            if (!$export_only) {
                if (($t < (time() - 86400 * 30)) || ($t > time())) {
                    $logdir          = $prefix."/logs/" + strftime("%Y", time()) . "/" . strftime("%m", time()) . "/";
                    $new_export_file = strftime("%Y%m%d", time()) . "_0.csv";
                    // if we have switched days
                    if ($new_export_file != $last_export_file) {
                        if ((time() - $last_export_time) > (intval($ini['intervalcustom']) * 6)) {
                            $last_export_file    = $new_export_file;
                            $last_export_filepos = 0;
                            
                        }
                    }
                } else {
                    ini_set($prefix."/ini/datalog_status.ini", "custom", "filepos", 0);
                    ini_set($prefix."/ini/datalog_status.ini", "custom", "last_export", time());
                    ini_set($prefix."/ini/datalog_status.ini", "custom", "file", $new_export_file);
                    debug_print("switching to file " . $new_export_file);
                    die();
                }
            }
        } else {
            if (!$export_only) {
                $last_export_file    = $new_export_file;
                $last_export_filepos = 0;
            }
        }
    } else {
        //ini_set("/config/datalog_status.ini", "custom", "filepos", $last_size);
    }
    debug_print("3. last_export_file=" . $last_export_file,"file","green");
    $f_log = fopen($logdir . $last_export_file, "r");
    
    
    
    if ($f_log) {
        // navigate to the last saved pos
        fseek($f_log, $last_export_filepos, 0);
        $lines       = array();
        $export_size = 0;
        /*for ($l=0;$l<$ini['custom_lines'];$l++) {
        $st=fgets($f_log);
        if (strlen($st)==254) {
        $st2=fgets($f_log);
        $st.=$st2;$st2='';
        }
        if (!$st) {
        break;
        }
        $export_size+=strlen($st)+2;  // add cr+lf
        $lines[$l]=$st;$st="";
        }*/
        $fpos=ftell($f_log);
        log("[export] exporting from ".$fpos." in ".$last_export_file);
        
        for ($l = 0; $l < $ini['custom_lines']; $l++) {
            $st = fgets($f_log);
            if (!strlen($st) && !feof($st)) {
                $st = fgets($f_log);
            }
            //print("Len: ".strlen($st)."\r\n");
            if (strlen($st) == 254) {
                $st2 = $st;
                while (strlen($st2) == 254) {
                    $st2 = fgets($f_log);
                    $st .= $st2; //$st2='';
                }
                //$st2=fgets($f_log);
                //$st.=$st2;$st2='';
            }
            if (!$st) {
                break;
            }
            //$a=explode($st,',');
            $dt = intval(substr($st, 0, strpos($st, ',')));
            $dt = intval(strftime("%Y", $dt));
            debug_print("Line: " . $st ,"csv","green" );
            //print($dt."\r\n");
            //print_r($a);
            if ($dt >= 2015) {
                debug_print($dt." OK","csv","green");
                $st.="\r\n";
                $export_size+=strlen($st);  // add cr+lf
                $csv_size+=strlen($st);
                if (strlen($st)) {
                    $lines[$l]=$st;
                } else $l--;
                $st="";
            } else {
                $l--;
                $csv_size += strlen($st);
                $export_size+=strlen($st)+2;
                debug_print("Year=" . $a . " skipping CSV line " . $st . " filepos=" . ftell($f_log) . " filesize=" . filesize($f_log),'csv','green');
                log("[csv] Year=" . $a . " skipping CSV line " . $st . " filepos=" . ftell($f_log) . " filesize=" . filesize($f_log));
            }
        }
        debug_print("EXPORT_SIZE=".$export_size,'csv');
        $export_size=ftell($f_log)-$last_export_filepos;  
        debug_print("EXPORT_SIZE2=".$export_size,'csv');
        if (feof($f_log) && !$l) {
            debug_print("jumping to next day",'file','green');
            log("Jumping to next day as no data available");
            
            $y1 = substr($last_export_file, 0, 4);
            $m1 = substr($last_export_file, 4, 2);
            $d1 = substr($last_export_file, 6, 2);
            debug_print("fn=" . $y1 . " " . $m1 . " " . $d1,'csv');
            $t = mktime(0, 0, 0, intval($m1) - 1, intval($d1), intval($y1)) + 86400;
            $m2 = strftime("%m", time());
            $d2 = strftime("%d", time());
            $y2 = strftime("%Y", time());
            
            $m = strftime("%m", $t);
            $d = strftime("%d", $t);
            $y = strftime("%Y", $t);
            debug_print ($y1." ".$m1." ".$d1." -- ".$y2." ".$m2." ".$d2,'csv');
            if (($m2==$m1) && ($d2==$d1) && ($y2==$y1)) {
                debug_print("at end of file in current day, abort",'csv','red');
                die();
            }
            if ($export_only) {
                $logdir          = $prefix."/logs/";
                $new_export_file = "log_" . $group_number . ".csv";
            } else {
                $logdir          = $prefix."/logs/" + $y . "/" . $m . "/";
                $new_export_file = strftime("%Y%m%d", $t) . "_0.csv";
            }
            
            // if we have switched days
            if ($new_export_file != $last_export_file) {
                debug_print("New file=" . $new_export_file . " and old file=" . $last_export_file,'csv','green');
                if ((time() - $last_export_time) > (intval($ini['intervalcustom']) * 60)) {
                    debug_print("Updating file to new one",'csv','green');
                    $last_export_file    = $new_export_file;
                    $last_export_filepos = 0;
                    ini_set($prefix."/ini/datalog_status.ini", "custom", "filepos", $last_export_filepos);
                    ini_set($prefix."/ini/datalog_status.ini", "custom", "last_export", time());
                    ini_set($prefix."/ini/datalog_status.ini", "custom", "file", $last_export_file);
                } else {
                    debug_print((time() - $last_export_time) . ">" . (intval($ini['intervalcustom']) * 60),'export','green');
                }
            }
            die();
            
        }
        debug_print("<pre>Found " . $l . " lines",'csv');
        debug_print("Export_file =" . $last_export_file ,'csv');
        debug_print("File_size =" . filesize($logdir . $last_export_file) ,'csv');
        debug_print("Export_size =" . $export_size,'csv');
        //print_r($lines);
        fclose($f_log);
        //$last_export_filepos=ftell($f)
        // only export data if something has changed
        if (sizeof($lines)) {
            //$dns_ip=ini_get("/config/dns.ini","dns","my.wattmon.com","my.wattmon.com");
            
            $url = $ini['custom_url'];
            if (strtolower(substr($url, 0, 7)) == 'http://')
                $url = substr($url, 7);
            if (strtolower(substr($url, 0, 8)) == 'https://') {
                $url = substr($url, 8,strlen($url));
                $secure=1;
            }
            debug_print("url=".$url);    
            $p    = strpos($url, '/');
            debug_print($p);
            $host = substr($url, 0, $p);
            $path = substr($url, $p);
            if (strpos($host, ':')) {
                $port = substr($host, strpos($host, ':') + 1, 5);
                $host = substr($host, 0, strpos($host, ':'));
            } else {
                if ($secure) $port=443;
                else $port = 80;
            }
            debug_print($host . " port " . $port);
            
            // added this to allow connections to non-standard ports securely (i.e. NodeRed)
            if ($secure && $port!=443) {
                $f = fsockopen('ssl://'.$host, intval($port), 10);
            } else
                $f = fsockopen($host, intval($port), 10);
            
            //$f=fsockopen("192.168.0.7",80,10);
            if ($f) {
                
                $out = "POST " . $path . " HTTP/1.0\r\n"; //="+$ini['devicename']+"&key="+$ini['devicekey']+"&v="+$_GLOBALS['battery_voltage']+"&pc="+$_GLOBALS['battery_percent']+"
                //$out = "POST /wattmononline/data/setdatacsv HTTP/1.0\r\n";
                $out = $out . "Host: " . $host . " \r\n";
                //$out = $out."Host: 192.168.0.7\r\n";
                    $out = $out."Content-Type: application/x-www-form-urlencoded\r\n";
            	    $out = $out."Connection: Keep-Alive\r\n"; // Keep-Alive
                $mac = getmac();
                
                
                
                if (($ini['md5'] == 1) && function_exists('md5')) {
                    for ($l = 0; $l < sizeof($lines); $l++) {
                        $data .= $lines[$l];
                        $lines[$l] = 0;
                    }
                    $md5 = md5($data);
                    
                    $data = "key=" + $mac . "&md5sum=" . strtolower($md5) . "&data=" . $data;
                    $len  = strlen($data); //$export_size;
                } else {
                    
                    $data = "key=" + $mac . "&data=" . $data;
                    $len  = strlen($data);// + $export_size;
                }
                
                $len+=strlen($_GLOBALS['log0buf']);
                
                $out = $out . "Content-Length: " . $len . "\r\n\r\n";
                debug_print($out,'send header','blue');
                $size_sent=0;
	            if ($debug_custom_export) {
                	$fdebug=fopen($prefix.'/logs/debug.txt','a');
					fwrite($fdebug,"=====".strftime("%Y %m %d - %H %M %S",time())."\r\n");
	                fwrite($fdebug,$out);
	                $size_sent+=strlen($out);
				}
                fwrite($f, $out);
				
                //print($data);
                if (($ini['md5'] == 1) && function_exists('md5')) {
                    $cnt = strlen($data);
//                    debug_print("Size to send is ".$cnt,"debug","red");
                    $size_sent+=$cnt;
                    while ($cnt) {
                        $cnt = fwrite($f, $data);
                        debug_print("sent=".$cnt,"progress","red");
						if ($debug_custom_export) 
                        	fwrite($fdebug,$data);
                        debug_print($data,'send body','blue');
                        if ($cnt) {
                            print($cnt . " bytes left in buffer..\r\n");
                            $data = substr($data, strlen($data) - $cnt);
                            
                        }
                    }
                } else {
                    $cnt = strlen($data);
                    debug_print("Size to send is ".$cnt,"debug","red");
                    $size_sent+=$cnt;
                    while ($cnt) {
                        $cnt = fwrite($f, $data);
                        
						if ($debug_custom_export) 
                        	fwrite($fdebug,$data);
                        debug_print($data,'send body','blue');
                        if ($cnt) {
                            debug_print($cnt . " bytes left in buffer..",'status','red');
                            $data = substr($data, strlen($data) - $cnt);
                            
                        }
                    }
                    for ($l = 0; $l < sizeof($lines); $l++) {
                        $ln = $lines[$l];
                        debug_print($ln,'send body','blue');
                        $cnt = strlen($ln);
                        $size_sent+=$cnt;
                        while ($cnt) {
                            $cnt = fwrite($f, $ln);
                            
							if ($debug_custom_export) 
	                            fwrite($fdebug,$ln);
                            if ($cnt) {
                                debug_print($cnt . " bytes left in buffer..",'status','red');
                                $ln = substr($ln, strlen($ln) - $cnt);
                                
                            }
                        }
                    }
                }
//                fclose($fdebug);
                debug_print($_GLOBALS['log0buf'],'log_buf','gray');
//                if (strlen($_GLOBALS['log0buf']))
                    fwrite($f, $_GLOBALS['log0buf']);
                $size_sent+=strlen($_GLOBALS['log0buf']);
                print("SIZE_SENT=".$size_sent);
                // get header
                $done       = 0;
                $start      = microtime();
                $has_data   = 0;
                /*while (!$done) {
                $str=fgets($f);
                
                print("IN: ".$str+"\r\n");
                if ((strlen($str)==0) && (microtime()-$start > 500)) $done=1;
                
                //$done=1;
                }*/
                // if we received anything back, assume the export succeeded
                $done       = 0;
                $error_skip = 0;
                $header_ok=0;
				fwrite($fdebug,"=====RESPONSE:\r\n");
                while (!$done) {
                    $str = fgets($f);
                    debug_print($str,'receive header','green');
					if ($debug_custom_export) 
						fwrite($fdebug,$str."\r\n");
                    //  print("***:".$str);//+"\r\n");
                    if ($str) {
                        if (strpos($str, "200 OK") > 0) {
                            $header_ok=1;
                        }
                        $has_data = 1;
                        if (strpos($str, "500 Internal") > 0) {
                            log("[data export] Internal Server Error 500 reported, skipping segment and moving on.");
                            $error_skip = 1;
                            $done       = 1;
                        }
                    }
                    if ($str == -1) {
                        $done=1;
                            //break;
                        /*log("Connection broken");
                        $stat = get3gstat();
                        if ($stat['enabled']) {
                            if ($stat['connected'] || intval($ini['force_reboot'])) {
                                if (($stat['ip_address'] != '0.0.0.0') || intval($ini['force_reboot'])) {
                                    $_GLOBALS['error3g']++;
                                    if ($_GLOBALS['error3g'] >= 5) {
                                        log("Cellular link seems to have died, restarting USB power");
                                        setusbpower(0);
                                        sleep(100);
                                        setusbpower(1);
                                        $_GLOBALS['restarts'] = $_GLOBALS['restarts'] + 1;
                                        $_GLOBALS['error3g']  = 0;
                                        if ($_GLOBALS['restarts'] > 3) {
                                            log("Restarting due to link issues.");
                                            reset();
                                        }
                                        ;
                                    }
                                    
                                }
                            } else {
                                
                                if ($_GLOBALS['exportportalint'] % 10 == 9) {
                                    log("Cellular link seems to have died, restarting USB power");
                                    setusbpower(0);
                                    sleep(100);
                                    setusbpower(1);
                                    $_GLOBALS['restarts'] = $_GLOBALS['restarts'] + 1;
                                    $_GLOBALS['error3g']  = 0;
                                }
                                
                                
                            }
                        }
                        die();*/
                    }
                    if (strlen($str) == 0 && $has_data)
                        $done = 1;
                }
                //while (!feof($f)) {
                if (!$error_skip) {
                    $str=0;
                    debug_print("Waiting for body...",'receive','black');
                    while (!$str) {
                        $str = fread($f, filesize($f));
                    }
                    debug_print($str,"receive body","green");
                }
				if ($debug_custom_export) {
					fwrite($fdebug,$str."\r\n");
	                fwrite($fdebug,"[CLOSE]:\r\n");
	                fclose($fdebug);
				}
                
                if ((!$str && $header_ok) || (strpos(strtoupper($str), "OK") >= 0) || $error_skip) {
                    debug_print("Success!","finish","gren");
                    if (!$str && $header_ok)
                        log("[warning] Received 200 OK but blank body, assuming everything is OK and moving on to next block.");
                    $last_export_filepos += $export_size;
                    ini_set($prefix."/ini/datalog_status.ini", "custom", "filepos", $last_export_filepos);
                    ini_set($prefix."/ini/datalog_status.ini", "custom", "last_export", time());
                    ini_set($prefix."/ini/datalog_status.ini", "custom", "file", $last_export_file);
                    // only wait if there is nothing to buffer
                    if ($last_export_filepos >= $last_size)
                        $_GLOBALS['exportcustomint'] = 0; // restore for the next time
                }
                fclose($f);
                debug_print("finished executing custom-export.cgi",'finish','gray');
                
                $_GLOBALS['error3g'] = 0;
            } else {
                $stat = get3gstat();
                if ($stat['enabled']) {
                    if ($stat['connected']) {
                        if ($stat['ip_address'] != '0.0.0.0') {
                            $_GLOBALS['error3g']++;
                            if ($_GLOBALS['error3g'] >= 5) {
                                log("Cellular link seems to have died, restarting USB power");
                                setusbpower(0);
                                sleep(100);
                                setusbpower(1);
                                $_GLOBALS['error3g'] = 0;
                            }
                            
                        }
                    }
                }
                $_GLOBALS['exportcustomint'] = $ini['intervalcustom'] + 1; // retry next minute...
                debug_print("Unable to connect to host",'socket','red');
            }
        } else { // nothing to export
            $_GLOBALS['exportcustomint'] = 0; // restore for the next time
            $_GLOBALS['error3g']         = 0;
        }
    } // fopen
    
}

?>


