<?
/**
 * @package PowerMeterWidget
 * @author Akash Heimlich
 * @description This package is a demo of how to install and uninstall packages in Wattmon
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function VariableWidget2_install($val) {
        VariableWidget2_enable();
        return 1;
    }
     
    function VariableWidget2_uninstall() {
        setPackageStatus("VariableWidget2",0);
        return 1;
    }
    
    function VariableWidget2_enable() {
        setPackageStatus("VariableWidget2",2);
        addWidget("/package/VariableWidget2.inc","Variables",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function VariableWidget2_disable() {
        setPackageStatus("VariableWidget2",3);
        addWidget("/package/VariableWidget2.inc","Variables",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function VariableWidget2_init() {
        $vars=ini_get("/config/VariableWidget2.ini","config","vars","");
        $arr=explode($vars,',');
        for ($i=0;$i<sizeof($arr);$i++) {
            if (!isset($_GLOBALS['vars'][$arr[$i]]))
                $_GLOBALS['vars'][]=$arr[$i];
        }
        
        // ensure that whatever roles are 'wanted' are added to the list of roles to transfer
        $roles=ini_get("/config/VariableWidget2.ini","config","roles","");
        $arr=explode($roles,',');
        for ($i=0;$i<sizeof($arr);$i++) {
            $role=array();
            $role["name"]=ini_get("/config/roles.ini","roles","role".$arr[$i],"");
            $role["role"]=$arr[$i];
            $exists=0;
            for ($j=0;$j<sizeof($_GLOBALS['roles']);$j++) {
                if ($_GLOBALS['roles'][$j]['role']==$arr[$i]) 
                    $exists=1;
            } 
            if (!$exists)
                $_GLOBALS['roles'][]=$role;
        }
        
        return 1;
    }
    
    function VariableWidget2_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="VariableWidget2"; 
        $title='Configure Package VariableWidget2';
        $config_file="VariableWidget2.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li><a href="/app/pacman.cgi">Package Manager</a> <span class="divider">/</span></li>
            <li class="active">Variable Widget</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> Variable Widget Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/pacman.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
This widget lets you set custom variables to be displayed on the home page. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Widget Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="widget_roles='<? print(ini_get("/config/".$config_file,$config_section,"roles","")); ?>';">
		<div ng-init="widget_vars='<? print(ini_get("/config/".$config_file,$config_section,"vars","")); ?>';">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='widget_roles'>Roles</label>
		            <div class="controls">
			            <input type='text' ng-model="widget_roles"  name='widget_roles' title="Enter a list of role ids that you wish to be displayed on the front end, comma separated (i.e 3,5,7)" data-rel="tooltip"> * Comma separated
			        </div>
		        </div>
		        <div class="control-group">
		            <label class="control-label" for='widget_roles'>Variables</label>
		            <div class="controls">
			            <input type='text' ng-model="widget_vars"  name='widget_vars' title="Enter the global variables that you wish displayed on the front end (i.e counter,mode,myvar)" data-rel="tooltip"> * Comma separated
			        </div>
		        </div>
		</fieldset>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function VariableWidget2($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="roles="+$scope.widget_roles+"&vars="+$scope.widget_vars;
       post_config="VariableWidget2.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>



