<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : Backup.cgi
 * 
 *  Description: Backup page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Ruchir Sharma        17/10/17    v1.1
 * Akash Heimlich       19/06/18    v2.0 WattmonOS 3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="BackupCtrl"; 
$title='Backup';
include("/app/header.inc");

$prefix='';
if ($_SERVER['HW_PLATFORM']==11) {
    $prefix='0:';
}
if ($_SERVER['HW_PLATFORM']>=20) {  // ULTRA
        $prefix=intval($_GLOBALS['log_drive']).':';
}
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','backup')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-group"></i> <? print(lang('PAGE_TITLE','backup')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','backup')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('START','backup')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  <? print(lang('HELP1','backup')) ?><br>
  <? print(lang('HELP2','backup')) ?><br>
  <? print(lang('HELP3','backup')) ?><br>
  <? print(lang('HELP4','backup')) ?><br>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

<!--VARIABLES-->
<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print("You will need to reboot the device for changes to take effect."); ?>';"></div>
<div ng-init="method=2;"></div>

<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('BACKUP','backup')) ?></h5>
        <p class="card-text">    
            <div class="form-group">
                <label for=">"><small class='text-muted'><? print(lang('BACKUP_OPTION','backup')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="method" id="b1" value="0">
                  <label class="form-check-label" for="b1">
                    &nbsp;<? print(lang('MONTH_DATA','backup')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="method" id="b2" value="1">
                  <label class="form-check-label" for="b2">
                    &nbsp;<? print(lang('ALL_LOGS','backup')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="method" id="b3" value="2">
                  <label class="form-check-label" for="b3">
                    &nbsp;<? print(lang('CONFIG_DATA','backup')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="method" id="b4" value="3">
                  <label class="form-check-label" for="b4">
                    &nbsp;<? print(lang('ALL_FILES','backup')) ?>
                  </label>
                </div>  
                
                <small id="ddHelp" class="form-text text-muted"><? print(lang('BACKUP_HELP','backup')) ?></small>
            </div> 
            <div class="form-group" ng-show='method==0'>
                <label for="bfolder"><? print(lang('SELECT_MONTH','backup')) ?></label>
                <select ng-model="bfolder" name='bfolder' class="custom-select custom-select-sm">
        <?
 function searchdir($dir,$dirarr) {
    chdir($dir);
    $arr=findfirst("*.*",16);
    $count=0;
    while ($arr) {
        if ($arr['attributes'] & 16) {
            if ((substr($arr['filename'],0,1)!=".") && ($arr['filename']!="cache") && ($arr['filename']!="backup")) {
                $dirarr[]=$dir.$arr['filename']."/";     
                $count++;
            }
        
        }
        $arr=findnext();
    }
 }
 $dirs=array($prefix."/logs/");
 $dir=$dirs[0];
 $start=1;
 searchdir($dir,&$dirs);
 $num=sizeof(&$dirs);
 while ($start<$num) {
    for ($i=$start;$i<$num;$i++) {
        searchdir($dirs[$i],&$dirs);
        $start++;
    }
    $num=sizeof(&$dirs);
 }
 for ($i=0;$i<$num;$i++) {
     $arr=explode($dirs[$i],"/");
     if (strlen($arr[3])) 
        print("<option value='".$dirs[$i]."'>".$arr[2]."/".$arr[3]."</option>");
 } 
        ?></select>
         </div>
        </p>
    </div>
</div>
 
</form>

     <script>
     var app = angular.module('myApp', []);
     function BackupCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";
   $scope.method=0;
   $scope.bfolder='';
   $scope.saveSettings=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       if ($scope.method==1) {
            window.open("/app/backuprun.cgi?folder=<? print($prefix); ?>/logs/","_blank","scrollbars=yes");
       }
       if ($scope.method==2) {
            window.open("/app/backuprun.cgi?folder=/config/","_blank","scrollbars=yes");
       }
       if ($scope.method==0) {
            if ($scope.bfolder=="") {
                alert("Please select a month to backup.");
                return;
            }
            window.open("/app/backuprun.cgi?folder="+$scope.bfolder,"_blank","scrollbars=yes");
       }
       if ($scope.method==3) {
            window.open("/app/backuprun.cgi?complete=1","_blank","scrollbars=yes");
       }
       
   }
    
  //poll();

}</script>
<? include("/app/footer.inc"); ?>

