<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : battery.cgi
 * 
 *  Description: Battery settings page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Ruchir Sharma        17/10/17    v1.1
 * Akash Heimlich       17/05/18    v2.0
 ********************************************************************/
include("/app/config.inc");
$angular_controller="BatteryEditCtrl"; 
$title=lang('BATTERY_SETTINGS','user');
$title='Battery and Charge Settings';
include("/app/header.inc");
print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('BATTERY_SETTINGS','battery')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-tasks"></i> <? print(lang('BATTERY_SETTINGS','battery')) ?></h2>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','battery')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="setBatteryAH()"><i class="icon-check"></i> <? print(lang('UPDATE_AH','battery')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','battery')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <h4>Battery AH</h4>
    Enter the battery Amp-hour rating for your battery pack here.  If your battery pack is older, you could reduce this value (i.e from 180 to 150) which will increase the accuracy of the remaining power calculations.
    <h4>System Voltage</h4>
    Choose your system voltage (i.e two batteries makes a 24V system)
    <h4>C Rating</h4>
    Normally, batteries are rated at a 20-hour discharge rate.  Look at the datasheet and choose the correct hour rating.  This will affect the battery percentage calculations.
    <h4>Battery Full Voltage</h4>
    Enter the voltage that will cause the battery counters to reset to full.  This can be useful when batteries are not often completely charged and exact battery remaining percentage loses accuracy.  For example, a 24 V system could
    reset counters to full capacity when voltage reaches 28V with a solar system or 27.6 with a grid charger, it would depend on the type of charger you are using.
    <h4>Return Amps</h4>
    This is used to determine when the battery is full - the charge voltage will reach the Battery Full voltage, and the current will taper off slowly as the battery gets full.  This is a percentage of the total
    amp hour capacity of the battery, and would normally be set to 2% but can be adjusted as required.  Set this to Not used if you do not wish to take charge current into account.
    <h4>Charge Parameters Met Time</h4>
    The number of minutes that the voltage and current parameters must be set for before the battery is reset to full.  Use this to prevent erronous readings.  This could be set to 1 minute or more.
    <h4>Charge Efficiency</h4>
    Enter the estimated charge efficiency for your battery.  Most lead acid chargers are typically 80-90%.  This will affect the state of charge algorithm.
    <h4>Peukert Const</h4>
    Peukert's constant for a battery can change over time but typically values of about 1.1 work well.  This value is used to estimate the remaining capacity based on the rate of discharge as this is non-linear 
    with lead acid setups.  If you don't want any correction, enter 1 here.
    </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<!-- VARIABLES -->
<? 
  $arr=ini_get_array("/config/battery.ini","battery");
  $charge_efficiency=$arr["charge_efficiency"];
  $peukert_const=$arr["peukert_const"];
  $battery_ah=$arr["battery_ah"];  
  $battery_voltage=$arr["battery_voltage"];
  $c_rating=$arr["c_rating"];
  $battery_full_voltage=number_format(floatval($arr["battery_full_voltage"]),2);
  $min_charge_percent=$arr["min_charge_percent"];  
  $max_charge_percent=$arr["max_charge_percent"];  
?>
<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print(lang("NEED_REBOOT")); ?>';"></div>
<div ng-init="charge_efficiency=<? print($charge_efficiency); ?>;"></div>
<div ng-init="peukert_const=<? print($peukert_const); ?>;"></div>
<div ng-init="battery_ah=<? print($battery_ah); ?>;"></div>
<div ng-init="met_time=<? print($arr['met_time']); ?>;"></div>
<div ng-init="return_amps_pc=<? print($arr['return_amps_pc']); ?>;"></div>
<div ng-init="c_rating=<? print($c_rating); ?>;"></div>
<div ng-init="battery_full_voltage=<? print($battery_full_voltage); ?>;"></div>
<div ng-init="battery_voltage=<? print($battery_voltage); ?>;"></div>
<div ng-init="min_charge_percent=<? print($min_charge_percent); ?>;"></div>
<div ng-init="max_charge_percent=<? print($max_charge_percent); ?>;"></div>
<div ng-init="battery_cur_ah=<? print($_GLOBALS['battery_cur_ah']); ?>;"></div>

<!-- FORM -->
<form name="form"  novalidate>
<h4><i class="icon-pencil"></i> <? print(lang('BATTERY_SETTINGS','battery')); ?></h4>
  <div class="form-group">
    <label for="battery_ah"><? print(lang('BATTERY_AH','battery')); ?></label>
    <input type="text" class="form-control" id="battery_ah" ng-model="battery_ah" aria-describedby="ahHelp" placeholder="Enter AH">
    <small id="ahHelp" class="form-text text-muted"><? print(lang('BATTERY_AH_TITLE','battery')); ?></small>
     <div class="invalid-feedback" ng-show='form.battery_ah.$invalid'>
          <? print(lang('BATTERY_AH_INVALID','battery')); ?>
    </div>
  </div>
    <div class="form-group form-inline">
        <label for="battery_voltage"><? print(lang('BATTERY_AH_NOMINAL','battery')); ?></label>
        <input type="text" class="form-control" id="battery_voltage" ng-model="battery_voltage" aria-describedby="vHelp" placeholder="Enter voltage"  min="12" max="600" integer required ng-change="battery_full_voltage=battery_voltage/12*13.8;">
    
        <button class="btn dropdown-toggle" data-toggle="dropdown">Select<span class="caret"></span></button>
        <ul class="dropdown-menu">
            <li><a ng-click='setV(12)' href='#'>12V</a></li>
            <li><a ng-click='setV(24)' href='#'>24V</a></li>
            <li><a ng-click='setV(48)' href='#'>48V</a></li>
            <li><a ng-click='setV(60)' href='#'>60V (<? print(lang('WITH_EXTERNAL_SENSOR','battery')); ?>)</a></li>
            <li><a ng-click='setV(72)' href='#'>72V (<? print(lang('WITH_EXTERNAL_SENSOR','battery')); ?>)</a></li>
            <li><a ng-click='setV(96)' href='#'>96V (<? print(lang('WITH_EXTERNAL_SENSOR','battery')); ?>)</a></li>
            <li><a ng-click='setV(144)' href='#'>144V (<? print(lang('WITH_EXTERNAL_SENSOR','battery')); ?>)</a></li>
            <li><a ng-click='setV(360)' href='#'>360V (<? print(lang('WITH_EXTERNAL_SENSOR','battery')); ?>)</a></li>
        </ul>
        <small id="vHelp" class="form-text text-muted"><? print(lang('BATTERY_AH_NOMINAL','battery')); ?></small>    
        <div class="invalid-feedback" ng-show='form.battery_ah.$invalid'>
            <? print(lang('BATTERY_AH_INVALID','battery')); ?>
        </div>
    </div>
    <div class="form-group">
        <label for="battery_full_voltage"><? print(lang('BATTERY_FULL_VOLTAGE','battery')); ?></label>
        <input type="text" class="form-control" id="battery_full_voltage" ng-model="battery_full_voltage" aria-describedby="fvHelp" placeholder="Enter full voltage">
        <small id="fvHelp" class="form-text text-muted"><? print(lang('BATTERY_FULL_VOLTAGE_TITLE','battery')); ?></small>
    </div>
    <div class="form-group">
        <label for="met_time"><? print(lang('CHARGE_MET','battery')); ?></label>
        <input type="text" class="form-control" id="met_time" ng-model="met_time" aria-describedby="cmHelp" placeholder="Enter minutes">
        <small id="cmHelp" class="form-text text-muted"><? print(lang('CHARGE_MET_TITLE','battery')); ?></small>
    </div>
    <div class="form-group">
        <label for="c_rating"><? print(lang('C_RATING','battery')); ?></label>
        <select ng-model="c_rating" class="form-control" name='c_rating' required aria-describedby="crHelp" title="<? print(lang('C_RATING_TITLE','battery')); ?>" data-rel="tooltip">
			                <option value="1">1-hour (C)</option>                
                            <option value="5">5-hour (C/5)</option>
                            <option value="10">10-hour (C/10)</option>
                            <option value="20">20-hour (C/20)</option>
                            <option value="40">40-hour (C/40)</option>
        </select>
        <small id="crHelp" class="form-text text-muted"><? print(lang('C_RATING_TITLE','battery')); ?></small>
    </div>        
    <div class="form-group">
        <label for="charge_efficiency"><? print(lang('CHARGE_EFF','battery')); ?></label>
        <select ng-model="charge_efficiency" class="form-control" name='charge_efficiency' required aria-describedby="ceHelp" title="<? print(lang('CHARGE_EFF','battery')); ?>" data-rel="tooltip">
			               <option value="60">60%</option>
                            <option value="65">65%</option>
                            <option value="70">70%</option>
                            <option value="75">75%</option>
                            <option value="80">80%</option>
                            <option value="85">85%</option>
                            <option value="90">90%</option>
                            <option value="95">95%</option>
                            <option value="100">100%</option>
        </select>
        <small id="ceHelp" class="form-text text-muted"><? print(lang('CHARGE_EFF_TITLE','battery')); ?></small>
    </div>           
    <div class="form-group">
        <label for="met_time"><? print(lang('PEUKERT','battery')); ?></label>
        <input type="number" class="form-control" id="peukert_const" ng-model="peukert_const" aria-describedby="pkHelp"  min="0" required placeholder="Enter constant">
        <small id="pkHelp" class="form-text text-muted"><? print(lang('PEUKERT_TITLE','battery')); ?></small>
        <div class="invalid-feedback" ng-show='form.peukert_const.$invalid'><? print(lang('PEUKERT_DESC','battery')); ?>Peukert const is invalid. Enter 1 if you don't require peukert compensation</div>
    </div>         

    <h4><i class="icon-pencil"></i> <? print(lang('BATTERY_SOC','battery')); ?></h4>
    <div class="form-group">
        <label for="battery_cur_ah"><? print(lang('BATTERY_AH','battery')); ?></label>
        <input type="number" class="form-control" id="battery_cur_ah" ng-model="battery_cur_ah" aria-describedby="cahHelp" placeholder="Enter AH" min="0" max="{{battery_ah}}">
        <small id="cahHelp" class="form-text text-muted"><? print(lang('BATTERY_CUR_AH_TITLE','battery')); ?></small>
        <div class="invalid-feedback" ng-show='form.battery_cur_ah.$invalid'>
          Invalid Cur AH value
        </div>
  </div>
</form>



    
     <script>
     var app = angular.module('myApp', []);
function BatteryEditCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";
   $scope.setV=function (v) {
        $scope.battery_voltage=v;
        $scope.battery_full_voltage=Number(Math.floor(v/12*13.8*100)/100);
   }
   
   $scope.saveSettings=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       if ($scope.battery_full_voltage < $scope.battery_voltage) {
            $scope.errormsg="<? print(lang('ERROR_BAT_VOLTAGE','battery')); ?>";
            return;
       }
       //alert();
       //
       $http.post('/app/configsave.cgi?config=battery.ini&section=battery',"charge_efficiency="+$scope.charge_efficiency+"&battery_ah="+$scope.battery_ah+"&battery_voltage="+$scope.battery_voltage+
        "&battery_full_voltage="+$scope.battery_full_voltage+"&c_rating="+$scope.c_rating+"&charge_efficiency="+$scope.charge_efficiency+"&peukert_const="+$scope.peukert_const+"&met_time="+$scope.met_time
        +"&return_amps_pc="+$scope.return_amps_pc)
        .then(function (response) {
          var data = response.data;      
          $scope.successmsg=(data.status==1)?"<? print(lang('SAVE_SUCCESS')); ?>":"";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="<? print(lang('SAVE_ERROR')); ?>";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
     $scope.setBatteryAH=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       if (confirm("<? print(lang('CONFIRM_SET_AH','battery')); ?>")) {
           $http.get('/app/globalset.cgi?var=battery_cur_ah&val='+$scope.battery_cur_ah)
            .then(function (response) {
              var data = response.data;      
              $scope.successmsg=(data.status==1)?"<? print(lang('AH_SUCCESS','battery')); ?>":"";
              $scope.errormsg=data.error;
              $scope.sysmsg=data.sysmsg;
              return data;
            }, function(reason) {
                $scope.errormsg="<? print(lang('AH_ERROR','battery')); ?>";
                $scope.successmsg="";
            });
       }
   }    
    
  //poll();

}</script>
</div>
<? include("/app/footer.inc"); ?>
