<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : datalogging.cgi
 * 
 *  Description: Data logging management page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Ruchir Sharma        17/10/17    v1.1
 * Akash Heimlich       21/06/18    v2.0 WattmonOS 3
 ********************************************************************/
/*

Create Groups Of Data Points For Logging
Data Group:
ID
Description
Log Interval

Data Type 1 = System Var
Data Type 2 = Device Var
Data TYpe 3 = Global Var (for custom programming)

Preset Variables:
1 - Solar Current
2 - Solar Wattage
3 - Grid Charge Current
4 - Grid Charge Wattage
5 - Grid Load Current
6 - Grid Load Wattage
7 - Battery Voltage
8 - Battery Charge Percent
9 - Battery AH remaining
10 - Solar kwH today
11 - Grid Charge kWh today
12 - Grid Load kWh today
*/
include("/app/config.inc");
$angular_controller="DataCtrl"; 
$title=lang('PAGE_TITLE','datalogging');
include("/app/header.inc");
print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
?>
<style>
    /* GLOBAL STYLES
    -------------------------------------------------- */
table {
    font: 90%/140% Verdana,Arial,Helvetica,sans-serif;
}
    
.enabled0 td{
    background-color:#CCC!important;
    color:#333;
}
</style>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','datalogging')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-edit"></i> <? print(lang('PAGE_TITLE','datalogging')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="btn btn-primary" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','datalogging')) ?>
  </a>
  </li>
  <li ng-hide='settings_locked' class="nav-item">
    <a class="btn btn-primary" ng-click="addGroup()"><i class="icon-plus"></i>
    <? print(lang('ADD_FILE','datalogging')) ?>
  </a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  <? print(lang('HELP1','datalogging')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

<!-- VARIABLES -->
        
<div class='clearfix'></div>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('DATA_COLLECTION','datalogging')) ?></h5>
        <p class="card-text">   
            <div class="table-responsive">					
                <table class='table table-striped'>
                    <tr>
                        <th scope="col">ID</th>
                        <th scope="col"><? print(lang('GROUP_NAME','datalogging')) ?></th></th>
                        <th scope="col"><? print(lang('STATUS','datalogging')) ?></th>
                        <th scope="col"><? print(lang('INFO','datalogging')) ?></th>
                        <th scope="col"><? print(lang('OPTIONS','datalogging')) ?></th>
                    </tr>
  
                    <tr ng-repeat="item in groups" ng-show='item.status!=2'>
                        <td><span class="badge badge-pill badge-dark">{{$index+1}}</span></td>
                        <td><strong>{{item.name}}</strong></td>    
                        <td><div ng-show='item.status>0' class="label label-success">{{isActive(item)}}</div><div ng-show='item.status==0' class="label label-failure">{{isActive(item)}}</div></td>
                        <td>Created: <strong>{{item.date_created}}</strong><br>Num Entries: {{item.num_entries}}<br>Num Days: {{item.num_days}}</td>
                        <td>
                            <div ng-hide="refresh" class="dropdown">
                                <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Action <span class="caret"></span>
                                </button>
                            
                                <div class="dropdown-menu dropdown-menu-right text-dark" >
                                    <a class="dropdown-item" ng-click='edit($index)' href='#'><i class="icon-pencil"></i>&nbsp;<? print(lang('CONFIGURE','datalogging')) ?></a>
                                    <a ng-hide='settings_locked' class="dropdown-item" ng-click='del($index)' href='#'><i class="icon-remove"></i>&nbsp;<? print(lang('DELETE','datalogging')) ?></a>
                                </div>
                            </div>
                        
                       </td>
                    </tr>
                </table>
            </div>
        </p>
    </div>
</div>

<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Warning</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>{{question}}</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><? print(lang('CANCEL','datalogging')) ?></button>
        <button type="button" class="btn btn-primary" ng-click="doModal()"><? print(lang('CONTINUE','datalogging')) ?></button>
      </div>
    </div>
  </div>
</div>

<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.factory('dataService', function($http) {
  
  this.async = function() {
    return $http.get('/app/datalog_ajax.cgi?action=list')
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
    });
    
  };
  
  return this;
});


function DataCtrl(dataService, $scope, $timeout, $http) {
	var self = this;
	var pc = 100;
	$scope.scanning = 0;
	$scope.refresh = 0;
	$scope.helpvisible = 0;
	$scope.items = [];
    $scope.settings_locked=settings_locked;
    if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";

	$scope.asyncData = dataService.async();
	$scope.poll = function() {
		$scope.asyncData = dataService.async();

	};
	$scope.edit = function(idx) {
		document.location = "/app/datalogedit.cgi?data_idx=" + idx;
	}

	$scope.addGroup = function() {
		document.location = "/app/datalogedit.cgi?new=1";
	}
	$scope.del = function(idx) {
		// alert('del '+item.id);
		//  alert('in del');
		$scope.selectedIdx = idx;
		$scope.action = 1;
		$scope.question = "Delete this group?";
		$('#myModal').modal('show');
	}

	$scope.hideModal = function() {
		$('#myModal').modal('hide');
	}

	$scope.doModal = function() {

		$scope.delGroup();

	}
	$scope.delGroup = function() {
		$('#myModal').modal('hide');
		$scope.errormsg = "";
		$scope.successmsg = "";

		$http.get('/app/datalog_ajax.cgi?action=delete&group_idx=' + $scope.selectedIdx)
			.then(function(response) {
				if (response.data.status == 0) {
					$scope.errormsg = "There was an error deleting the data group.";
				} else $scope.successmsg = "Data group deleted successfully";

				poll();
				return response;
			}, function(reason) {
				$scope.errormsg = "Error while updating";
			});
	}
	$scope.isActive = function(item) {
		if (item.status == 0)
			return "Disabled";
		if (item.status == 1)
			return "Active";
		if (item.status == 2)
			return "Deleted";
	}
	$scope.isDisabled = function(item) {
		if (item.status == 0) return 1;
		return 0;
	}
	$scope.isError = function(item) {
		if (item.status != 0 && item.last_response >= 2) return 1;
		return 0;
	}

	$scope.$watch('refresh', function(ref) {
		if (ref) poll();
	});
	$scope.$watch('scanning', function(ref) {
		if (ref) poll();
	});
	$scope.$watch('asyncData', function(asyncData) {
		if (angular.isDefined(asyncData)) {
			$scope.connectstatus = asyncData.loggedin ? "loggedin" : "loggedout";
			$scope.groups = asyncData.groups;

			pc = 0;
		}
	});


}

</script>    
<? include("/app/footer.inc");
?>
