<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : devices.cgi
 * 
 *  Description: Device manager page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Akash Heimlich       24/11/16    v1.1 Modbus TCP
 * Ruchir Sharma        17/10/17    v1.2
 * Akash Heimlich       17/05/18    v2.0
 * Akash Heimlich       25/09/18    v3.0
 *                      02/10/18    v3.1 Virtual Device RS232
 ********************************************************************/
include("/app/config.inc");
$angular_controller="DeviceCtrl"; 
$title='Devices';
include("/app/header.inc");
print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');

print('<script src="'.$url_prefix.'/js/devctrl.js"></script>'); 
?>
<style>
    /* GLOBAL STYLES
    -------------------------------------------------- */
table {
    font: 90%/140% Verdana,Arial,Helvetica,sans-serif;
}
    
.enabled0 td{
    background-color:#CCC!important;
    color:#333;
}
</style>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('MODBUS_DEVICES','devices')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-sitemap"></i> <? print(lang('MODBUS_DEVICES','devices')) ?></h2>
<ul class="nav justify-content-end">
    
    <div class='pull-right'><small>Poll time: {{poll_time}} seconds<? if ($_SERVER['HW_PLATFORM']==11 || $_SERVER['HW_PLATFORM']==21 || $_SERVER['HW_PLATFORM']==22) {  print(' (RS485 1), {{poll_time2}} seconds (RS485 2)'); }; ?></small></div>

<div ng-cloak ng-show='loading==1'><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i></div>
  <li class="nav-item">
    <a class="btn btn-primary" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  
  <li class="nav-item">
    <div class="dropdown">
        <button ng-hide='settings_locked' class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButtonAdd" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            Add <span class="caret"></span>
        </button>
    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuButtonAdd">
    <!-- dropdown menu links -->
    <a class="dropdown-item"  href='/app/deviceadd.cgi'>Manually Add a Device</a>
    <a class="dropdown-item" ng-click='quickScan(0)' href='#'>Quick Scan RS-485 Bus</a>
<? if ($_SERVER['HW_PLATFORM']==20 || $_SERVER['HW_PLATFORM']==21 || $_SERVER['HW_PLATFORM']==22 ) { ?>      
    <a class="dropdown-item" ng-click='quickScan(1)' href='#'>Quick Scan RS-485 Bus 2</a>
<? } ?>    
    <a class="dropdown-item" ng-click='fullScan(0)' href='#'>Full Scan RS-485 Bus</a>
    </div>
    </div>
  </li>
  <li class="nav-item">
    <div class="dropdown">
     <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
    Options <span class="caret"></span>
  </button>
    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuButton">
        <a class="dropdown-item" ng-click='poll();' href='#'>Refresh List</a>
        <a class="dropdown-item" ng-show='refresh==0' ng-click='refresh=1' href='#'>Enable Automatic Refresh</a>
        <a class="dropdown-item" ng-show='refresh==1' ng-click='refresh=0' href='#'>Disable Automatic Refresh</a>
        <a class="dropdown-item" ng-show='roles==0' ng-click='roles=1' href='#'>Enable Full View</a>
        <a class="dropdown-item" ng-show='roles==1' ng-click='roles=0' href='#'>Disable Full View</a>
        
        <a class="dropdown-item" href='/app/modbusconfig.cgi' href='#'>Edit Communication Settings</a>
        <a class="dropdown-item" href='/app/modbustest.cgi' href='#'>Modbus Tester</a>
    </div>
    </div>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
   <h4>Scanning For Devices</h4>If you are just setting up your system, plug in a single device at a time, and click the Add button.  If you are using Wattmon modules then 
click <i>Quick Scan RS-485 Bus for New Wattmon Devices</i>.  The device will be automatically detected and installed.   Repeat this for every new device you wish to install in the system.
<br>If you are using third party modbus compliant devices, click <i>Manually Add a Device</i> to proceed.
    <br>
    Next, click <i>Action > Edit</i> to configure the device and assign it a role in your setup.<br>
    You can enable or disable a device at any time using the <i>Action > Enable/Disable</i> option
    <br>
    To change RS-485 (or Modbus TCP) settings, click <i>Options > Edit Communication Settings</i>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="scanning"> Scanning: <div class="progress"><div class="progress-bar" style="width: {{scanpercent}}%;"></div></div></div>
<!-- VARIABLES -->
<div class='clearfix'></div>
<div class="card">
    <div class="card-body">
        <p class="card-text">   					
            <div class="table-responsive">					
                <table class='table table-striped' summary="Device List">
                    <tr>
                        <th scope="col">Index</th>
                        <th scope="col"><a href="" ng-click="predicate = 'id'; reverse=!reverse">ID</a></th>
                        <th scope="col">Channel</th>
                        <th scope="col"><a href="" ng-click="predicate = 'name'; reverse=!reverse">Name</a></th>
                        <th scope="col"><a href="" ng-click="predicate = 'type'; reverse=!reverse">Type</a></th>
                        <th scope="col">Role</th>
<? if ($_SERVER['HW_PLATFORM']>=7) { ?>                        
                        <th scope="col">Time</th>
<? } ?>                           
                        <th scope="col"><a href="" ng-click="predicate = 'status'; reverse=!reverse">Status</a></th>
                        <th scope="col">Options</th>
                    </tr>
                    <tr ng-repeat="item in devices | orderBy:predicate:reverse" class="enabled{{item.status}}">
                        <td><strong>{{$index}}</strong></td>
                        <td><span class="badge  badge-dark">{{item.id}}</span></td>
                        <td><span ng-show='item.params==0'>RS-485</span><span ng-show='item.params==100'>Virtual</span><span ng-show='item.params==1'><? if (($_SERVER['HW_PLATFORM']==11) || ($_SERVER['HW_PLATFORM']>=20)) { ?>RS-485 2<? } else { ?>RS-232<? } ?></span><span ng-show='item.params==101'>RS-232</span><?
                          $is_mega = $_SERVER['HW_PLATFORM']>=7;
                          if (!$is_mega) {
                            $max_tcp=1;
                          } else {
                            $max_tcp = 1;
                            if (function_exists('sysvar')) {
                                $max_tcp=intval(sysvar("MODBUS_TCP_CONNECTION_COUNT"));
                            }
                          }
                          for ($i=0;$i<$max_tcp;$i++) {
                              print("<span ng-show='item.params==".($i+2)."'>TCP Channel ".($i+1)."</span>");
                          }
                          ?>
                        </td>
                        <td><strong>{{item.name}}<i class='fa fa-exclamation-triangle'></i></strong></td><td>{{item.description}}<span ng-show='item.serial.length>0'><br><i>Serial:<strong> {{item.serial}}</strong></i></span><span ng-show='item.model.length>0'><br>Model: {{item.model}}</span></td>
                        <td width='40%'><div class="row" style='margin-bottom:5px' ng-repeat="role in item.roles" ng-show='role.role!="Undefined"'>
                                <div class='col-md-12 col-lg-6' >{{role.desc}}</div><div class="col-md-12 col-lg-6"><div class='col-12 badge badge-secondary text-left'>{{role.role}}</div>
                                </div>
                                
                            </div>
                        </td>
<? if ($_SERVER['HW_PLATFORM']>=8) { ?>                        
                        <td><strong>{{item.poll_time/1000|number:1}}s</strong></td>
<? } ?>                        
                        <td>
                            <span ng-show="isActive(item)" class="badge badge-success">{{lastAccess(item)}}</span><span ng-show="isError(item)" class="badge badge-danger">{{lastAccess(item)}}</span><span class="badge badge-secondary" ng-show="isDisabled(item)">Disabled</span>
                                <a ng-show="item.exceptions>0" href="javascript:void()" data-toggle="tooltip" title="This device is getting modbus exceptions.  Possible driver issue."><span  class="badge badge-warning"><i class='icon icon-exclamation-sign'></i></span></a>
                                <a ng-show="$index>=device_limit" href="javascript:void()" data-toggle="tooltip" title="This device is not being polled as the device limit for this Wattmon has been reached."><span  class="badge badge-warning"><i class='icon icon-exclamation-sign'></i></span></a>
                        </td>
                        <td>
                            <div ng-show="refresh">Disable Refresh to edit</div>
                            <div ng-hide="refresh" class="dropdown">
                                <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <? print(lang('ACTION','devices')) ?> <span class="caret"></span>
                                </button>
                        
                                <div class="dropdown-menu dropdown-menu-right text-dark" >
                                    <a class="dropdown-item" ng-click='edit($index)' href='#'><i class="icon-pencil"></i>&nbsp;<? print(lang('CONFIGURE','devices')) ?></a>
                                    <a class="dropdown-item"  ng-show='item.status==1' ng-hide='settings_locked' ng-click='disable(item)' href='#'><i class="icon-check-empty"></i>&nbsp;<? print(lang('DISABLE','devices')) ?></a>
                                    <a class="dropdown-item"  ng-show='item.status==0' ng-hide='settings_locked' ng-click='enable(item)' href='#'><i class="icon-check"></i>&nbsp;<? print(lang('ENABLE','devices')) ?></a>
                                    <a class="dropdown-item" ng-hide='settings_locked' ng-click='del($index)' href='#'><i class="icon-remove"></i>&nbsp;<? print(lang('DELETE','devices')) ?></a>
                                    <a class="dropdown-item" class='text-danger' ng-click='calib($index)' href='#'><i class="icon-wrench"></i>&nbsp;<? print(lang('CALIBRATE','devices')) ?></a>
                                </div>
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
<div class="clearfix"></div>    <!-- actionlist-->
					</div>
				</div>
			</div>  
            </p>
        </div><!--/span-->
      </div><!--/row-->

   <? include("/app/footer.inc"); ?>
   
 <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Warning</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>{{question}}</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" ng-click="doModal()">Continue</button>
      </div>
    </div>
  </div>
</div>

    

<script src="/js/devctrl.js"></script>    












