{<?
//print_r($_POST);
/*

11 10 0001 0002 04 000A 0102 C6F0

11: The Slave Address (17 = 11 hex)
10: The Function Code (Preset Multiple Registers 16 = 10 hex)
0001: The Data Address of the first register. (# 40002 - 40001 = 1 )
0002: The number of registers to write
04: The number of data bytes to follow (2 registers x 2 bytes each = 4 bytes)
000A: The value to write to register 40002
0102: The value to write to register 40003
C6F0: The CRC (cyclic redundancy check) for error checking.
*/
if ($_POST['baud']) {
	$f=f485open(intval($_POST['baud']),intval($_POST['parity']));
}

if ($_POST['value']) {
	$value=intval($_POST['value']);
} else $value=0;

if ($_POST['start']) {
	$start=intval($_POST['start']);
} else $start=1;

if ($_POST['end']) {
	$end=intval($_POST['end']);
} else $end=10;

if ($_POST['count']) {
	$len=intval($_POST['count']);
} else $len=1;

if ($_POST['func']) {
	$func=intval($_POST['func']);
} else $func=3;

if ($_POST['register']) {
	$register=intval($_POST['register']);
} else $register=1;

$bus=intval($_POST['bus']);
max_execution_time(30);

$base_addr=$register;
$b1=$base_addr >> 8;
$b2=$base_addr & 0xFF;

for ($i=$start;$i<$end;$i++) {
  if ($func<6) {
      //printf("TX: %02X %02X %02X %02X %02X %02X\r\n",($i & 0xFF),($func & 0xFF),($b1 & 0xFF),($b2 & 0xFF),(0),($len & 0xFF));
      print('"tx":['.implode(array($i,$func,$b1,$b2,0,$len),',').']');
      $start=microtime();
      
      $res=mb_send_command($bus,array($i,$func,$b1,$b2,0,$len));
      if (!is_array($res)) {
    		$res=mb_send_command($bus,array($i,$func,$b1,$b2,0,$len));
      }
      print(',"time":'.(microtime()-$start));
      if (is_array($res)) {
          
        print(',"rx":['.implode($res,',').']');
    	//print("Response from ".$i."\r\n");
    	//for ($c=0;$c<sizeof($res);$c++) {
    	  //  printf("%02X ",($res[$c]&0xFF));
    	//}
    	//print("\r\n");
    	print(',"registers":[');
    	$type=intval($_POST['vtype']);
    	if ($type==1) {  // signed int
    	   for ($r=0;$r<$len;$r++) {
    	       $val=($res[3+$r*2] & 0x7F) << 8 + $res[4+$r*2] & 0xFF;
    	       if ($res[3+$r*2]&0x80) $val=-$val^0x7FFF;
    	       if ($r) print(",");
    	       print('{"reg":'.($register+$r).',"val":'.$val."}\r\n");
    	       //print("Register ".($register+$r).": ".$val."\r\n");
    	   }
    	}
    	if ($type==2) {  // unsigned int
    	   for ($r=0;$r<$len;$r++) {
    	       $val=($res[3+$r*2] & 0xFF) << 8 + $res[4+$r*2] & 0xFF;
//    	       print("Register ".($register+$r).": ".$val."\r\n");
    	       if ($r) print(",");
    	       print('{"reg":'.($register+$r).',"val":'.$val."}\r\n");

    	   }
    	}
    	if ($type==3) {  // signed int 32 big endian
    	   for ($r=0;$r<$len/2;$r++) {
    	       $val=($res[3+$r*4] & 0x7F) << 24 + ($res[4+$r*4] & 0xFF) << 16 + ($res[5+$r*4] & 0xFF) << 8 + ($res[6+$r*4] & 0xFF);
    	       //if ($res[3+$r*4]&0x80) $val=-$val;
    	       if ($res[3+$r*4]&0x80) $val=-$val^0x7FFFFFFF;
//    	       print("Register ".($register+$r*2).": ".$val."\r\n");
    	       if ($r) print(",");
    	       print('{"reg":'.($register+$r*2).',"val":'.$val."}\r\n");

    	   }
    	}
    	if ($type==4) {  // signed int 32 little endian
    	   for ($r=0;$r<$len/2;$r++) {
    	       $val=($res[5+$r*4] & 0x7F) << 24 + ($res[6+$r*4] & 0xFF) << 16 + ($res[3+$r*4] & 0xFF) << 8 + ($res[4+$r*4] & 0xFF);
    	       if ($res[3+$r*4]&0x80) $val=-$val^0x7FFFFFFF;
//    	       print("Register ".($register+$r*2).": ".$val."\r\n");
    	       if ($r) print(",");
    	       print('{"reg":'.($register+$r*2).',"val":'.$val."}\r\n");

    	   }
    	}
    	if ($type==5) {  // unsigned int 32 big endian
    	   for ($r=0;$r<$len/2;$r++) {
    	       $val=($res[3+$r*4] & 0xFF) << 24 + ($res[4+$r*4] & 0xFF) << 16 + ($res[5+$r*4] & 0xFF) << 8 + ($res[6+$r*4] & 0xFF);
//    	       print("Register ".($register+$r*2).": ".$val."\r\n");
    	       if ($r) print(",");
    	       print('{"reg":'.($register+$r*2).',"val":'.$val."}\r\n");

    	   }
    	}
    	if ($type==6) {  // unsigned int 32 big endian
    	   for ($r=0;$r<$len/2;$r++) {
    	       $val=($res[5+$r*4] & 0xFF) << 24 + ($res[6+$r*4] & 0xFF) << 16 + ($res[3+$r*4] & 0xFF) << 8 + ($res[4+$r*4] & 0xFF);
    	       //print("Register ".($register+$r*2).": ".$val."\r\n");
    	       if ($r) print(",");
    	       print('{"reg":'.($register+$r*2).',"val":'.$val."}\r\n");
    	       
    	   }
    	}
    	if ($type==7) {  // unsigned int 32 big endian
    	   for ($r=0;$r<$len/2;$r++) {
    	       $val=($res[3+$r*4] & 0xFF) << 24 + ($res[4+$r*4] & 0xFF) << 16 + ($res[5+$r*4] & 0xFF) << 8 + ($res[6+$r*4] & 0xFF);
    	       $fval=inttoieee754($val);
//    	       print("Register ".($register+$r*2).": ".$fval."\r\n");
    	       if ($r) print(",");
    	       print('{"reg":'.($register+$r*2).',"val":'.$fval."}\r\n");

    	   }
    	}
    	if ($type==8) {  // float (little endian)
    	   for ($r=0;$r<$len/2;$r++) {
    	       $val=($res[5+$r*4] & 0xFF) << 24 + ($res[6+$r*4] & 0xFF) << 16 + ($res[3+$r*4] & 0xFF) << 8 + ($res[4+$r*4] & 0xFF);
    	       $fval=inttoieee754($val);
//    	       print("Register ".($register+$r).": ".$fval."\r\n");
    	       if ($r) print(",");
    	       print('{"reg":'.($register+$r*2).',"val":'.$fval."}\r\n");

    	   }
    	}
    	if ($type==9) {  // float 64 (little endian)
    	   for ($r=0;$r<$len/4;$r++) {
    	       $val=($res[5+$r*4] & 0xFF) << 24 + ($res[6+$r*4] & 0xFF) << 16 + ($res[3+$r*4] & 0xFF) << 8 + ($res[4+$r*4] & 0xFF);
    	       $val2=($res[9+$r*4] & 0xFF) << 24 + ($res[10+$r*4] & 0xFF) << 16 + ($res[7+$r*4] & 0xFF) << 8 + ($res[8+$r*4] & 0xFF);
        	   $fval=int64toieee754($val,$val2);
//    	       print("Register ".($register+$r).": ".$fval."\r\n");
    	       if ($r) print(",");
    	       print('{"reg":'.($register+$r*2).',"val":'.$fval."}\r\n");

    	   }
    	}
    	if ($type==10) {  // float 64 (little endian)
    	   for ($r=0;$r<$len/4;$r++) {
    	       $val=($res[5+$r*4] & 0xFF) << 24 + ($res[6+$r*4] & 0xFF) << 16 + ($res[3+$r*4] & 0xFF) << 8 + ($res[4+$r*4] & 0xFF);
    	       $val2=($res[9+$r*4] & 0xFF) << 24 + ($res[10+$r*4] & 0xFF) << 16 + ($res[7+$r*4] & 0xFF) << 8 + ($res[8+$r*4] & 0xFF);
        	   $fval=int64toieee754($val2,$val);
//    	       print("Register ".($register+$r).": ".$fval."\r\n");
    	       if ($r) print(",");
    	       print('{"reg":'.($register+$r*2).',"val":'.$fval."}\r\n");

    	   }
    	}
    	if ($type==11) {  // unsigned int 64 big endian
    	   for ($r=0;$r<$len/4;$r++) {
    	       $val=longval($res[7+$r*8] & 0xFF) << 56 + longval($res[8+$r*8] & 0xFF) << 48 + longval($res[7+$r*9] & 0xFF) << 40 + longval($res[4+$r*10] & 0xFF) << 32 + longval($res[5+$r*8] & 0xFF) << 24 + ($res[6+$r*8] & 0xFF) << 16 + ($res[3+$r*8] & 0xFF) << 8 + ($res[4+$r*8] & 0xFF);
    	       //print("Register ".($register+$r*2).": ".$val."\r\n");
    	       if ($r) print(",");
    	       print('{"reg":'.($register+$r*4).',"val":'.$val."}\r\n");
    	       
    	   }
    	}
    	if ($type==12) {  // unsigned int 64 big endian
    	   for ($r=0;$r<$len/4;$r++) {
    	       $val=longval($res[3+$r*8] & 0xFF) << 56 + longval($res[4+$r*8] & 0xFF) << 48 + longval($res[5+$r*9] & 0xFF) << 40 + longval($res[6+$r*10] & 0xFF) << 32 + longval($res[7+$r*8] & 0xFF) << 24 + ($res[8+$r*8] & 0xFF) << 16 + ($res[9+$r*8] & 0xFF) << 8 + ($res[10+$r*8] & 0xFF);
    	       //print("Register ".($register+$r*2).": ".$val."\r\n");
    	       if ($r) print(",");
    	       print('{"reg":'.($register+$r*4).',"val":'.$val."}\r\n");
    	       
    	   }
    	}
    	
    	print('],"result":1');
      } else {
          //print("No response from ".$i."\r\n");
          print(',"result":0');
      }
  } else if ($func==6) {  // set a register
      print('"tx":['.implode(array(($i & 0xFF),($func & 0xFF),($b1 & 0xFF),($b2 & 0xFF),($value >> 8) & 0xFF,($value & 0xFF)),',').']');
      $res=mb_send_command($bus,array($i,$func,$b1,$b2,($value >> 8) & 0xFF,($value & 0xFF)));
      if (!is_array($res)) {
    		$res=mb_send_command($bus,array($i,$func,$b1,$b2,($value >> 8) & 0xFF,($value & 0xFF)));
      }
  
      print(',"time":'.(microtime()-$start));
      if (is_array($res)) {
        print(',"registers":[');
    	$type=intval($_POST['vtype']);
        print('{"reg":'.($i).',"val":'.$value."}]");
        print(',"rx":['.implode($res,',').']');
        	print(',"result":1');
      }  else {
          //print("No response from ".$i."\r\n");
          print(',"result":0');
      }
      print("}");
      die();
  } else if ($func==16) {
      print('"tx":['.implode(array(($i & 0xFF),($func & 0xFF),($b1 & 0xFF),($b2 & 0xFF),0,1,2,($value >> 8) & 0xFF,($value & 0xFF)),',').']');
      $res=mb_send_command($bus,array($i,$func,$b1,$b2,0,1,2,($value >> 8) & 0xFF,($value & 0xFF)));
      if (!is_array($res)) {
    		$res=mb_send_command($bus,array($i,$func,$b1,$b2,0,1,2,($value >> 8) & 0xFF,($value & 0xFF)));
      }
  
      print(',"time":'.(microtime()-$start));
      if (is_array($res)) {
        print(',"registers":[');
    	$type=intval($_POST['vtype']);
        print('{"reg":'.($i).',"val":'.$value."}]");
        print(',"rx":['.implode($res,',').']');
        	print(',"result":1');
      }  else {
          //print("No response from ".$i."\r\n");
          print(',"result":0');
      }
      print("}");
      die();
  }
}
?>
}


