<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : ota.cgi
 * 
 *  Description: over the air update settings
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       22/04/21    v1.0
 ********************************************************************/
if ($_GET['action']=='force') {
    $ota_enabled = ini_get("/config/ota.ini",'config','ota_enabled', 0);
    if (!$ota_enabled) {
        $_GLOBALS['sysmsg']="OTA is not enabled.  Please ensure it is enabled before trying this.";
        header("Location: /app/firmwareman.cgi");
        die();
    }
    if ($_GLOBALS['VERMINOR']<1192) {
        $_GLOBALS['errormsg']="OTA is not enabled in this firmware version.  Please update to 1192 or above.";
        header("Location: /app/firmwareman.cgi?action=error");
        die();
    }
    $ota_stage = ini_get("/logs/ota.ini",'config','ota_stage', 0);
    if ($ota_stage>0) {
        $_GLOBALS['errormsg']="An OTA update is already in progress, cannot start a new one till it completes.";
        header("Location: /app/firmwareman.cgi?action=error");
        die();
    } else {
        // force an install
        ini_set("/config/ota.ini","config","ota_force_install",1);
        
        ini_set("/logs/ota.ini","config","ota_stage",1);
        ini_set("/logs/ota.ini","config","ota_type","firmware");
        ini_set("/logs/ota.ini","config","ota_version",$_GET['version']);
        ini_set("/logs/ota.ini","config","ota_filename",$_GET['filename']);
        ini_set("/logs/ota.ini","config","ota_filesize",$_GET['filesize']);
        ini_set("/logs/ota.ini","config","ota_md5",$_GET['md5']);
        log("Firmware ".$_GET['version']." to be installed in background");
        $_GLOBALS['sysmsg']="Firmware ".$_GET['version']." is being downloaded in the background.";
        download("www.wattmon.com/phocadownload/".$_GET['filename'],'/repository/'.$_GET['filename']);
        header("Location: /index.cgi");
        die();
    }
}
include("/app/config.inc");


$angular_controller="OTAEditCtrl"; 

$title=lang('OTA_SETTINGS','ota');
include("/app/header.inc");
print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
if ($_GET['action']=='cron') {
    include("/lib/uphp/system.inc");
    $res=add_cron("/scripts/ota_cron.cgi","10 * * *");
    if ($res) {
        $msg='CRON tab updated. ';
        $_GLOBALS['needreboot']=1;
    }
    else $msg='The crontab is already up to date. ';
    
}

?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('OTA_SETTINGS','ota')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-group"></i> <? print(lang('OTA_SETTINGS','ota')) ?></h2>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','ota')) ?></a>
  </li>
<li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/ota.cgi?action=check';"><i class="icon-remove"></i> <? print(lang('CHECK','ota')) ?></a>
  </li>
    
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked' ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','ota')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('OTA_HELP1','ota')); print(lang('OTA_HELP2','ota')); ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<!-- VARIABLES -->
<? 
      $ota_interval=ini_get("/config/ota.ini","config","ota_inverval",86400);
      $ota_enabled=ini_get("/config/ota.ini","config","ota_enabled",0);
      $ota_auto_install=ini_get("/config/ota.ini","config","ota_auto_install",0);
      $ota_auto_resync=ini_get("/config/ota.ini","config","ota_auto_resync",0);
      $ota_email=ini_get("/config/ota.ini","config","ota_email",'');
      $ota_email_status=ini_get("/config/ota.ini","config","ota_email_status",0);
      $ota_firmware=ini_get("/config/ota.ini","config","ota_firmware",0);
      $ota_packages=ini_get("/config/ota.ini","config","ota_packages",0);
      $ota_custom_packages=ini_get("/config/ota.ini","config","ota_custom_packages",0);
      $ota_custom_url=ini_get("/config/ota.ini","config","ota_custom_url",'');
      $ota_os=ini_get("/config/ota.ini","config","ota_os",0);
      if ($_GLOBALS['VERMINOR']<1192) {
          $msg="OTA is not supported in this firmware version.  Please update to x.1192 or above. ";
      }
      
?>
<div ng-init="sysmsg='<? print($msg); if ($_GLOBALS['needreboot']) print(lang('NEED_REBOOT')); ?>';"></div>

<?
    if ($_GET['action']=='check') {
        
        $ota_stage=ini_get("/logs/ota.ini","config","ota_stage",0); 
        $ota_enabled=ini_get("/config/ota.ini","config","ota_enabled",0);
        if ($ota_stage==0 && $ota_enabled) {
            ini_set("/logs/ota.ini",'config','ota_last_run',0);
            include("/scripts/ota_cron.cgi");
        } else {
            $msg='OTA must be anabled an not currently busy to do this now.';
        }
        //$msg='OTA check scheduled. ';
        
    }
?>

<div ng-init="ota_enabled=<? print($ota_enabled); ?>;"></div>
<div ng-init="ota_interval=<? print($ota_interval); ?>;"></div>
<div ng-init="ota_auto_install=<? print($ota_auto_install); ?>;"></div>
<div ng-init="ota_firmware=<? print($ota_firmware); ?>;"></div>
<div ng-init="ota_packages=<? print($ota_packages); ?>;"></div>
<div ng-init="ota_custom_packages=<? print($ota_custom_packages); ?>;"></div>
<div ng-init="ota_custom_url='<? print($ota_custom_url); ?>';"></div>
<div ng-init="ota_auto_resync=<? print($ota_auto_resync); ?>;"></div>
<div ng-init="ota_os=<? print($ota_os); ?>;"></div>
<div ng-init="ota_email_status=<? print($ota_email_status); ?>;"></div>
<div ng-init="ota_email='<? print($ota_email); ?>';"></div>
<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <p class="card-text">    
            <div class="form-group">
                <label for="ota_enabled"><? print(lang('OTA_ENABLED','ota')) ?></label>
                <select ng-model="ota_enabled" name='ota_enabled' class="custom-select custom-select-sm">
                    <option value='0'>Disabled</option>
                    <option value='1'>Enabled</option>
                </select>
                <small id="langH" class="form-text text-muted"><? print(lang('OTA_ENABLED_HELP','ota')) ?></small>
              </div>
             <div class="form-group">
                <label for="ota_interval"><? print(lang('OTA_INTERVAL','ota')) ?></label>
                <div class="input-group">
                    <input class="form-control" aria-label="<? print(lang('OTA_INTERVAL','ota')) ?>" ng-model="ota_interval" type="number" min=3600 size='5' integer required>
                    <div class="input-group-append">
                        <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><? print(lang('OTA_CHOOSE','ota')) ?></button>
                        <ul class="dropdown-menu dropdown-menu-right">
                            <li class="dropdown-item"><a ng-click='ota_interval=86400' href='#'>1 Day</a></li>
                            <li class="dropdown-item"><a ng-click='ota_interval=604800' href='#'>1 Week</a></li>
                        </ul>
                    </div>
                </div>
                <small id="pHelp" class="form-text text-muted"><? print(lang('OTA_INTERVAL_HELP','ota')) ?></small>
            </div>  
            <div class="form-group">
                <label for="ota_auto_install"><? print(lang('OTA_AUTO_INSTALL','ota')) ?></label>
                <select ng-model="ota_auto_install" name='ota_auto_install' class="custom-select custom-select-sm">
                    <option value='0'>Disabled</option>
                    <option value='1'>Enabled</option>
                </select>
                <small id="langH" class="form-text text-muted"><? print(lang('OTA_AUTO_INSTALL_HELP','ota')) ?></small>
             </div>
            <div class="form-group">
                <label for="ota_auto_resync"><? print(lang('OTA_AUTO_RESYNC','ota')) ?></label>
                <select ng-model="ota_auto_resync" name='ota_auto_resync' class="custom-select custom-select-sm">
                    <option value='0'>Disabled</option>
                    <option value='1'>Enabled</option>
                </select>
                <small id="langH" class="form-text text-muted"><? print(lang('OTA_AUTO_RESYNC_HELP','ota')) ?></small>
             </div>
            <div class="form-group">
                <label for="ota_email_status"><? print(lang('OTA_EMAIL_STATUS','ota')) ?></label>
                <select ng-model="ota_email_status" name='ota_auto_install' class="custom-select custom-select-sm">
                    <option value='0'>Disabled</option>
                    <option value='1'>Enabled</option>
                </select>
                <small id="langH" class="form-text text-muted"><? print(lang('OTA_EMAIL_STATUS_HELP','ota')) ?></small>
             </div>
             <div class="form-group" ng-show='ota_email_status==1'>
                <label for="ota_email"><? print(lang('OTA_EMAIL','ota')) ?></label>
                <input type="text" class="form-control" id="ota_email" ng-model="ota_email" aria-describedby="userHelp" placeholder="Enter email ID">&nbsp;<a class='btn btn-primary' href='/app/email.cgi'>Email Settings</a>
                <small id="userHelp" class="form-text text-muted"><? print(lang('OTA_EMAIL_HELP','ota')) ?></small>
            </div>
            <div class="form-group">
                <label for="ota_firmware"><? print(lang('OTA_FIRMWARE','ota')) ?></label>
                <select ng-model="ota_firmware" name='ota_auto_install' class="custom-select custom-select-sm">
                    <option value='0'>Disabled</option>
                    <option value='1'>Enabled</option>
                </select>
                <small id="langH" class="form-text text-muted"><? print(lang('OTA_FIRMWARE_HELP','ota')) ?></small>
             </div>

            <div class="form-group">
                <label for="ota_packages"><? print(lang('OTA_PACKAGES','ota')) ?></label>
                <select ng-model="ota_packages" name='ota_packages' class="custom-select custom-select-sm">
                    <option value='0'>Disabled</option>
                    <option value='1'>Enabled</option>
                </select>
                <small id="langH" class="form-text text-muted"><? print(lang('OTA_PACKAGES_HELP','ota')) ?></small>
             </div>
            <div class="form-group">
                <label for="ota_custom_packages"><? print(lang('OTA_CUSTOM_PACKAGES','ota')) ?></label>
                <select ng-model="ota_custom_packages" name='ota_custom_packages' class="custom-select custom-select-sm">
                    <option value='0'>Disabled</option>
                    <option value='1'>Enabled</option>
                </select>
                <small id="langH" class="form-text text-muted"><? print(lang('OTA_CUSTOM_PACKAGES_HELP','ota')) ?></small>
             </div>
            <div class="form-group" ng-show='ota_custom_packages==1'>
                <label for="ota_custom_url"><? print(lang('OTA_CUSTOM_URL','ota')) ?></label>
                <input type="text" class="form-control" id="ota_custom_url" ng-model="ota_custom_url" aria-describedby="userHelp" placeholder="Enter url">
                <small id="userHelp" class="form-text text-muted"><? print(lang('OTA_CUSTOM_URL_HELP','ota')) ?></small>
            </div> 
<!--            <div class="form-group">
                <label for="ota_os"><? print(lang('OTA_OS','ota')) ?></label>
                <select ng-model="ota_os" name='ota_os' class="custom-select custom-select-sm">
                    <option value='0'>Disabled</option>
                    <option value='1'>Enabled</option>
                </select>
                <small id="langH" class="form-text text-muted"><? print(lang('OTA_OS_HELP','ota')) ?></small>
             </div>
             -->
        </p>
    </div>
</div>
<br/>

</form>
     <script>
     var app = angular.module('myApp', []);
     function OTAEditCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";
   $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
   
   $scope.saveSettings=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       $http.post('/app/configsave.cgi?config=ota.ini&section=config',"ota_enabled="+$scope.ota_enabled+
                "&ota_auto_install="+$scope.ota_auto_install+
                "&ota_auto_resync="+$scope.ota_auto_resync+
                "&ota_email_status="+$scope.ota_email_status+
                "&ota_email="+$scope.ota_email+
                "&ota_firmware="+$scope.ota_firmware+
                "&ota_packages="+$scope.ota_packages+
                "&ota_custom_packages="+$scope.ota_custom_packages+
                "&ota_custom_url="+encodeURIComponent($scope.ota_custom_url)+
                "&ota_os="+$scope.ota_os+"&ota_interval="+$scope.ota_interval
                )
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"<? print(lang('MSG_SAVED','ota')) ?>":"<? print(lang('ERROR_SAVING','ota')) ?>";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          document.location='/app/ota.cgi?action=cron';
          return data;
        }, function(reason) {
            $scope.errormsg="<? print(lang('ERROR_SAVING','ota')) ?>";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

}</script>
<? include("/app/footer.inc"); ?>



