<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : owedit.cgi
 * 
 *  Description: Onewire Device edit page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       06/01/14    v1.0
 * Akash Heimlich       19/06/18    v2.0 WattmonOS 3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="DeviceEditCtrl"; 
$title='Onewire Device Settings';
include("/app/header.inc");

 $device_idx=$_GET['device_idx'];
  $device_type_id=ini_get("/config/onewire.ini","Device".$device_idx,"device_type_id",0);
  
  $info_ini="/dev/onewire/dev"+$device_type_id+".ini";
  $info_section="config";
  $role_ini="/config/roles.ini";
  $role_section="roles";
?>
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','onewire')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-group"></i> <? print(lang('PAGE_TITLE','onewire')) ?>  <small> <? print(ini_get($info_ini,$info_section,'description')); ?></small></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','time')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','onewire')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  <? print(lang('HELPEDIT1','onewire')) ?><br>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

<!--VARIABLES-->

<div ng-init="device_index=<? print($_GET['device_idx']); ?>;"></div>
<div ng-init="device_id='<? print(ini_get("/config/onewire.ini","Device".$device_idx,"address")); ?>';"></div>
<div ng-init="device_name='<? print(ini_get("/config/onewire.ini","Device".$device_idx,'name')); ?>';"></div>
<div ng-init="device_type_id=<? print($device_type_id); ?>;"></div>
<div ng-init="status=<? print(ini_get("/config/onewire.ini","Device".$device_idx,'status')); ?>;"></div>
<div ng-init="poll_interval=<? print(ini_get("/config/onewire.ini","Device".$device_idx,"poll_interval")); ?>;"></div>

<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('ONEWIRE_EDIT','onewire')) ?></h5>
        <p class="card-text">    
            <div class="form-group">
                <label for="device_id"><? print(lang('DEVICE_ID','onewire')) ?></label>
                <input type="text" size=16 class="form-control" id="device_id" ng-model="device_id" aria-describedby="userHelp" placeholder="<? print(lang('DEVICE_ID_HELP','onewire')) ?>">
                <div ng-cloak class='small text-danger' ng-show="form.device_id.$invalid"><strong><? print(lang('DEVICE_ID_INVALID','onewire')) ?></strong></div>
                <small id="sntpHelp" class="form-text text-muted"><? print(lang('DEVICE_ID_HELP','onewire')) ?></small>
            </div>  
            <div class="form-group">
                <label for="tcp_server"><? print(lang('DEVICE_NAME','onewire')) ?></label>
                <input type="text" class="form-control" id="device_name" ng-model="device_name" aria-describedby="userHelp" placeholder="<? print(lang('DEVICE_NAME_HELP','onewire')) ?>">
                <small id="sntpHelp" class="form-text text-muted"><? print(lang('DEVICE_NAME_HELP','onewire')) ?></small>
            </div>     
		    <div class="form-group">
                <label for="poll_interval"><? print(lang('POLL_INTERVAL','onewire')) ?></label>
                <div class="input-group">
                    <input class="form-control" aria-label="<? print(lang('POLL_INTERVAL','onewire')) ?>" ng-model="poll_interval" type="number" size='3' min="0" max="60000" integer required>
                    <div class="input-group-append">
                        <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><? print(lang('POLL_CHOOSE','onewire')) ?></button>
                        <ul class="dropdown-menu dropdown-menu-right">
                            <li class="dropdown-item"><a ng-click='poll_interval=0' href='#'>No polling</a></li>
                            <li class="dropdown-item"><a ng-click='poll_interval=1000' href='#'>Every Second</a></li>
                            <li class="dropdown-item"><a ng-click='poll_interval=2000' href='#'>Every 2 Seconds</a></li>
                            <li class="dropdown-item"><a ng-click='poll_interval=60000' href='#'>Every Minute</a></li>
                        </ul>
                    </div>
                </div>
                <small id="pHelp" class="form-text text-muted"><? print(lang('POLL_INTERVAL_HELP','onewire')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.poll_interval.$invalid"><? print(lang('POLL_INTERVAL_INVALID','onewire')) ?></small>
            </div>
            <div class="form-group">
                <label for="status"><small class='text-muted'><? print(lang('STATUS','onewire')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="status" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('DISABLED','onewire')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="status" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('ENABLED','onewire')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('STATUS_HELP','onewire')) ?></small>
            </div> 
              
        </p>
    </div>
</div>
<br>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('ONEWIRE_ROLES','onewire')) ?></h5>
        <p class="card-text">    
<?
$dev_ini="/dev/onewire/dev"+$device_type_id+".ini";
$num_roles=ini_get($dev_ini,"config","num_roles");
 print('<div ng-init="numroles='+$num_roles+';"></div>');
 print("<fieldset>");
  $role_cnt=ini_get($role_ini,$role_section,'num_roles',0);
  $devid=strval($device_type_id);
  // Create the role arrays for the different device types
  $rolearr=array();
  $rolearr[0]=array();
  $rolearr[1]=array();
  $rolearr[2]=array();
  $rolearr[3]=array();
  $rolearr[4]=array();
  //print($devid."<br>");
  for ($i=1;$i<$role_cnt;$i++) {
      $rt=ini_get($role_ini,$role_section,'role'.$i.'type',0);
      //print($st."<br>");
      if ($rt==4) {
          $x=intval(ini_get($role_ini,$role_section,'role'.$i.'type',0));
          //print("Match found! - ".$x."=".$i."<br>");
          $rolearr[$x][]=$i;
      }
  }
 // print_r($rolearr);
  for ($r=0;$r<$num_roles;$r++)  {
        $rt=intval(ini_get($info_ini,$info_section,'role_type_'+$r,0));
        //print($rt."-");
        
        $num_roles=0;//sizeof($rolearr[$rt]);
  //      while ($rolearr[$rt][$num_roles]>0) $num_roles++;
    //    print($num_roles);
      
    print('<div ng-init="role'+$r+'='+ini_get("/config/onewire.ini","Device".$device_idx,'role'+$r+"_id")+';"></div>'); ?>
            <div class="form-group">
            <label><? print(ucfirst(ini_get($info_ini,$info_section,'role_var_'+$r))); ?></label>
               <div class="form-row" style='line-height:40px'>
                
                <div class="col-6">
                <?
                    print('<select ng-model="role'+$r+'" class="custom-select custom-select-sm">');
        
                    $num_roles2=sizeof($rolearr[ini_get($info_ini,$info_section,'role_type_'+$r)]);
                    for ($i=0;$i<$num_roles2;$i++) {
                        print('<option value="'+$rolearr[$rt][$i]+'">'+ini_get($role_ini,$role_section,'role'+$rolearr[$rt][$i]));                
                        print('</option>');                 
                    }
                    print('</select>'); 
                ?>
               </div>
               <div class="col-6">
               <div class='input-append' style='margin-right:20px;margin-left:20px;'>Scale:<? print(ini_get($info_ini,$info_section,'role_scale_'+$r,1));   ?>
               </div>
               </div>
            </div>
        </div>
    
  <?
        
        
        
  }
 ?>
        </p>
    </div>
</div>
</form>

<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.factory('dataService', function($http, $q,$timeout) {
  
  this.async = function(devid) {
    return $http.get('/app/ow_ajax.cgi?action=get&index='+devid)
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
        alert('Failed: ' + reason);
        $timeout(poll, 100);  // try again
    });
    
  };
  
  return this;
});



function DeviceEditCtrl(dataService,$scope, $timeout,$http) {
    
//app.controller('ItemListCtrl', function( dataService,$scope,$timeout) {
    
  var self = this;
  $scope.infomsg="";
     $scope.isChecked=function(invert) {
    if (!invert) {
        if (Number($scope.status)) return 'checked';
        return 'unchecked';
   } else {
       if (!Number($scope.status)) return 'checked';
        return 'unchecked';
   }
   }
   $scope.saveSettings=function () {
      $scope.successmsg="";
      $scope.errormsg="";
      $scope.infomsg="";
      rolestr="";
      for (i=0;i<$scope.numroles;i++) {
           rolestr+="&role"+i+"="+$scope.$eval('role'+i);
      }
      //alert(rolestr);
//      $scope.form.$setPristine();
      $http.post('/app/ow_ajax.cgi?action=save&device_idx='+$scope.device_index,"address="+$scope.device_id+"&device_name="+$scope.device_name+"&poll_interval="+$scope.poll_interval+"&role_id="+$scope.role_id+"&status="+$scope.status+rolestr)
        .then(function (response) {
        //alert(response.data);
          var data = response.data;
          //alert(data);
          if (data.status)
            $scope.successmsg="Settings saved. You will need to reboot for changes to take effect";
          else {
            $scope.errormsg=data.error;
          }
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

}
//);
//app.ItemListCtrl.$inject=['$defer'];


</script>
<? include("/app/footer.inc"); ?>      
