<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : widgets.cgi
 * 
 *  Description: Widget management in control panel
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       18/12/13    v1.0
 * Ruchir Sharma        17/10/17    v1.1
 * Akash Heimlich       21/06/18    v2.0 WattmonOS 3
 ********************************************************************/

include("/app/config.inc");
$angular_controller="WidgetCtrl"; 
$title='Widgets';
include("/app/header.inc");
?>
<style>
    
    table {
        font: 90%/140% Verdana,Arial,Helvetica,sans-serif;
    }

.enabled0 td{
    background-color:#CCC!important;
    color:#333;
}
.enabled1 {

}
</style>



<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('WIDGETS','wigets')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-pushpin"></i> <? print(lang('WIDGETS_TITLE','widgets')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked' ng-click="addWidget()" ><i class="icon-check"></i> <? print(lang('ADD','widgets')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked' ng-click="newWidget()" ><i class="icon-check"></i> <? print(lang('CREATE','widgets')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','widgets')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<!-- VARIABLES -->
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('WIDGET_LIST','widgets')) ?></h5>
        <p class="card-text">    
            <div class="table-responsive">					
                <table class='table table-striped'>
                    <tr>
                        <th scope="col">ID</th>
                        <th scope="col"><? print(lang('TITLE','widgets')) ?></th></th>
                        <th scope="col"><? print(lang('TEMPLATE','widgets')) ?></th>
                        <th scope="col"><? print(lang('ICON','widgets')) ?></th>
                        <th scope="col"><? print(lang('WIDTH','widgets')) ?></th>
                        <th scope="col"><? print(lang('VISIBILITY','widgets')) ?></th>
                        <th scope="col"><? print(lang('OPTIONS','widgets')) ?></th>
                    </tr>

                    <tr ng-repeat="item in widgets" ng-show='item.status!=2'>
                        <td><span class="badge badge-pill badge-dark">{{item.id}}</span></td>
                        <td><strong>{{item.title}}</strong></td>    
                        <td><strong>{{item.template}}</strong></td>    
                        <td><strong>{{item.icon}}</strong></td>
                        <td><strong>{{item.width}}</strong></td>
                        <td><strong>{{makeVis(item.show)}}</strong><div ng-show='item.show==0 && !settings_locked' ><a href='#' ng-click='hide(item.id)'><? print(lang('HIDE','widgets')) ?></a></div>
                            <div ng-show='item.show!=0 && !settings_locked' ><a href='#' ng-click='show(item.id)'><? print(lang('SHOW','widgets')) ?></a></div>
                        </td>
                        <td>
                            <div ng-hide="refresh" class="dropdown">
                                <button ng-hide='settings_locked'  class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <? print(lang('ACTION','widgets')) ?> <span class="caret"></span>
                                </button>
                            
                                <div class="dropdown-menu dropdown-menu-right text-dark" >
                                    <a class="dropdown-item" ng-click='edit(item.id)' href='#'><i class="icon-pencil"></i>&nbsp;<? print(lang('CONFIGURE','widgets')) ?></a>
                                    <a class="dropdown-item" ng-click='del(item.id)' href='#'><i class="icon-remove"></i>&nbsp;<? print(lang('DELETE','widgets')) ?></a>
                                    <a class="dropdown-item" ng-click='moveUp(item.id)' href='#'><i class="icon-arrow-up"></i>&nbsp;<? print(lang('MOVE_UP','widgets')) ?></a>
                                    <a class="dropdown-item" ng-click='moveDown(item.id)' href='#'><i class="icon-arrow-down"></i>&nbsp;<? print(lang('MOVE_DOWN','widgets')) ?></a>
                                </div>
                            </div>
                        
                        </td>
                    </tr>
                </table>
            </div>
        </p>
    </div>
</div>

<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Warning</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>{{question}}</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" ng-click="doModal()">Continue</button>
      </div>
    </div>
  </div>
</div>

<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.factory('dataService', function($http) {
  
  this.async = function() {
    return $http.get('/app/widget_ajax.cgi?action=list')
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
    });
    
  };
  
  return this;
});
function WidgetCtrl(dataService, $scope, $timeout, $http) {
	var self = this;
	var pc = 100;
	$scope.scanning = 0;
	$scope.refresh = 0;
	$scope.helpvisible = 0;
	$scope.items = [];
  $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";

	$scope.asyncData = dataService.async();
	$scope.poll = function() {
		$scope.asyncData = dataService.async();

	};
	$scope.del = function(idx) {
		// alert('del '+item.id);
		//  alert('in del');
		$scope.selectedIdx = idx;
		$scope.action = 1;
		$scope.question = "Deleting a widget will remove it from the dashboard.  Continue?";
		$('#myModal').modal('show');
	}
	$scope.edit = function(idx) {
		document.location = "/app/widgetedit.cgi?widget_idx=" + idx;
	}

	$scope.newWidget = function(idx) {
		document.location = "/app/blockedit.cgi?newhome=1";
	}

	$scope.addWidget = function() {
		document.location = "/app/widgetedit.cgi?new=1";
	}

	$scope.hideModal = function() {
		$('#myModal').modal('hide');
	}

	$scope.doModal = function() {
		$scope.delWidget();

	}
	$scope.delWidget = function() {
		$('#myModal').modal('hide');
		$scope.errormsg = "";
		$scope.successmsg = "";

		$http.get('/app/widget_ajax.cgi?action=delete&widget_id=' + $scope.selectedIdx)
			.then(function(response) {
				if (response.data.status == 0) {
					$scope.errormsg = "There was an error deleting the widget.";
				} else {
					$scope.successmsg = "Widget deleted successfully";
				}

				$timeout($scope.poll, 500);
				return response;
			}, function(reason) {
				$scope.errormsg = "Error while updating";
			});
	}

	$scope.moveUp = function(widget_id) {
		$scope.errormsg = "";
		$scope.successmsg = "";

		$http.get('/app/widget_ajax.cgi?action=moveup&widget_id=' + widget_id)
			.then(function(response) {
				if (response.data.status == 0) {
					$scope.errormsg = "There was an error adjusting positions";
				} else {
					$scope.successmsg = "";
				}

				$timeout($scope.poll, 500);

				return response;
			}, function(reason) {
				$scope.errormsg = "Error while updating";
			});
	}
	$scope.hide = function(widget_id) {
		$scope.errormsg = "";
		$scope.successmsg = "";

		$http.get('/app/widget_ajax.cgi?action=hide&widget_id=' + widget_id)
			.then(function(response) {
				if (response.data.status == 0) {
					$scope.errormsg = "There was an error hiding widget";
				} else {
					$scope.successmsg = "";
				}

				$timeout($scope.poll, 500);

				return response;
			}, function(reason) {
				$scope.errormsg = "Error while updating";
			});
	}
	$scope.show = function(widget_id) {
		$scope.errormsg = "";
		$scope.successmsg = "";

		$http.get('/app/widget_ajax.cgi?action=show&widget_id=' + widget_id)
			.then(function(response) {
				if (response.data.status == 0) {
					$scope.errormsg = "There was an error hiding widget";
				} else {
					$scope.successmsg = "";
				}

				$timeout($scope.poll, 500);

				return response;
			}, function(reason) {
				$scope.errormsg = "Error while updating";
			});
	}
	$scope.moveDown = function(widget_id) {
		$scope.errormsg = "";
		$scope.successmsg = "";

		$http.get('/app/widget_ajax.cgi?action=movedown&widget_id=' + widget_id)
			.then(function(response) {
				if (response.data.status == 0) {
					$scope.errormsg = "There was an error adjusting positions";
				} else {
					$scope.successmsg = "";
				}

				$scope.poll();
				return response;
			}, function(reason) {
				$scope.errormsg = "Error while updating";
			});
	}
	$scope.isDisabled = function(item) {
		if (item.status == 0) return 1;
		return 0;
	}
	$scope.isError = function(item) {
		if (item.status != 0 && item.last_response >= 2) return 1;
		return 0;
	}
	$scope.makeVis = function(vis) {
		switch (vis) {
			case 0:
				return "Visible";
				break;
			case 1:
				return "Hidden";
				break;
			case 2:
				return "Hidden on phones";
				break;
			case 3:
				return "Hidden on phones and tablets";
				break;
			case 4:
				return "Hidden on desktops";
				break;
		}
	}
	$scope.$watch('refresh', function(ref) {
		if (ref) poll();
	});

	$scope.$watch('asyncData', function(asyncData) {
		if (angular.isDefined(asyncData)) {
			$scope.connectstatus = asyncData.loggedin ? "loggedin" : "loggedout";
			$scope.widgets = asyncData.widgets;

			pc = 0;
		}
	});


}
</script>    
<? include("/app/footer.inc"); ?>

