/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : EZDisplay.js
 * 
 *  Description: EZ Display Controller
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013-2018 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich                   v1.0
 * Latest revision: 	11/09/18
 ********************************************************************/
 console.log("EZ");
function EZDisplayCtrl($scope,$http) {
const TYPE_GENSET=1;
const TYPE_GRID=2;
const TYPE_SOLAR_METER=3;
const TYPE_LOAD=4;
const FONT_SIZE=18;

console.log("Call init scope");
init_scope($scope);
console.log("after init scope");




bar_color="#808080FF";
text_color="#000";
text_color2="#333";
text_color_group="#41873a";
background_color="#FFF";
text_background_color="#fff";
label_color="#6bae3f";
num_matrix_rows=1;
num_matrix_cols=5;

matrix_width=100;
matrix_height=100;
function get_font_size() {
    if (gridWidth < 65) {
        return '12px sans-serif';
    }
    
    if (gridWidth < 74) {
        return '13px sans-serif';
    }
    if (gridWidth < 84) {
        return '13px sans-serif';
    }
    return '14px sans-serif';
    
}

function rebuild_layout() {
if (!num_groups || num_groups<=1) {
items_left=[];      // grid stuff
items_top=[];       // solar stuff
items_right=[];     // load stuff
items_bottom=[];    // DG stuff
max_items_x=0;
max_items_y=0;
/*
* Possible lines:
* vertical_line, horizontal_line, horizontal_split_bottom, horizontal_split_top, vertical_split_bottom, vertical_split_top
*/


if (hasSolarMeter) {
    item={
            //count:pm.length,
            top:'horizontal_split_top',
            bottom:'horizontal_split_bottom',
            margin:5,
            height:matrix_height,
            items:[]
        };
        
    for (i=0; i < pm.length; i++) {
        if (pm[i].type==TYPE_SOLAR_METER) {
            item.items.push({
                    image:'/img/energymeter.png',
                    dynamic:true,
                    type:'meter',
                    index:i,
                    height:matrix_height,
                    width:matrix_width
                });
        }
    }
    item.count=item.items.length;
    if (item.count>max_items_x) 
        max_items_x=item.count;
    items_top.push(item);
}

if (hasSolar) {
    item={
            count:hasSolar,
            top:'horizontal_split_top',
            bottom:'horizontal_split_bottom',
            margin:5,
            height:matrix_height,
            items:[]
            };      
            
    for (i=0;i<hasSolar;i++) {
        item.items.push({
                    image:urlPrefix+'/img/inverter.png',
                    caption:"",
                    dynamic:1,
                    type:'inverter',
                    index:i,
                    height:matrix_height,
                    width:matrix_width
                }
            );

    }
    if (item.items.length>max_items_x) 
        max_items_x=item.items.length;
    
    items_top.push(item);
    items_top.push({
            count:1,
            bottom:'vertical_line',
            margin:5,
            height:matrix_height,
            
            items:[
                {
                    image:urlPrefix+'/img/solar.svg',
                    label_right:"Solar",
                    height:matrix_height,
                    width:matrix_width
                }
            ]
            });
            
}


if (hasGrid) {
    // add the grid meters
    item={
            
            left:'vertical_split_left',
            right:'vertical_split_right',
            margin:5,
            height:matrix_height,
            
            items:[]
            };      

    for (i=0; i < pm.length; i++) {
        if (pm[i].type==TYPE_GRID) {
            item.items.push({
                    image:urlPrefix+'/img/energymeter.png',
                    caption:"",
                    dynamic:true,
                    type:'meter',
                    index:i,
                    height:matrix_height,
                    width:matrix_width
                });
        }
    } 
    item.count=item.items.length;
    if (item.items.length>max_items_y) 
        max_items_y=item.items.length;
    
    items_left.push(item);
    // add the grid icon
       
}

items_left.push({
            count:1,
            right:'horizontal_line',
            margin:5,
            items:[
                {
                    image:urlPrefix+'/img/grid.svg',
                    label_bottom:"Grid",
                    height:matrix_height,
                    width:matrix_width,
                }
            ]
            });
    

if (hasLoad) {
    // add the grid meters
    item={
            count:hasLoad,
            left:'vertical_split_left',
            right:'vertical_split_right',
            margin:5,
            height:matrix_height,
            
            items:[]
            };      

    for (i=0; i < pm.length; i++) {
        if (pm[i].type==TYPE_LOAD) {
            item.items.push({
                    image:urlPrefix+'/img/energymeter.png',
                    caption:"",
                    dynamic:true,
                    type:'meter',
                    index:i,
                    height:matrix_height,
                    width:matrix_width
                });
        }
    }            
    if (item.items.length>max_items_y) 
        max_items_y=item.items.length;
    items_right.push(item);
    // add the grid icon
    
    
}

items_right.push({
            count:1,
            left:"horizontal_line",
            margin:5,
            items:[
                {
                    image:urlPrefix+'/img/load.svg',
                    label_bottom:"Load",
                    height:matrix_height,
                    width:matrix_width,
                }
            ]
            });

if (hasGenset) {
    item={
            
            top:'horizontal_split_top',
            bottom:'vertical_lines',
            margin:5,
            height:matrix_height,
            items:[]
        };
        
    for (i=0; i < pm.length; i++) {
        if (pm[i].type==TYPE_GENSET) {
            item.items.push({
                    image:urlPrefix+'/img/energymeter.png',
                    caption:"",
                    dynamic:true,
                    type:'meter',
                    index:i,
                    height:matrix_height,
                    width:matrix_width 
                });
        }
    }
    item.count=item.items.length;
    items_bottom.push(item);
    item={
            //count:1,
            top:'vertical_lines',
            margin:5,
            height:matrix_height,
            items:[]
        };
        
    for (i=0; i < pm.length; i++) {
        if (pm[i].type==TYPE_GENSET) {
            item.items.push({
                    image:urlPrefix+'/img/genset.svg',
                    label_bottom:"Genset",
                    height:matrix_height,
                    width:matrix_width
                });
        };
    }
    item.count=item.items.length;
    items_bottom.push(item);
}
} else {
    for (g=1;g<num_groups;g++) {
        groups[g].inv_count=groups[g].inv?groups[g].inv.length:0;
        groups[g].items_left=[];      // grid stuff
        groups[g].items_top=[];       // solar stuff
        groups[g].items_right=[];     // load stuff
        groups[g].items_bottom=[];    // DG stuff
        groups[g].max_items_x=0;
        groups[g].max_items_y=0;
        groups[g].hasSolar=0;
        for (i=0;i<inv.length;i++) {
            
            if (inv[i].cur_group==Math.pow(2,g-1) || (inv[i].cur_group==0 && inv[i].group & Math.pow(2,g-1))) {
                console.log("g "+g+" = "+inv[i].cur_group+" "+groups[g].hasSolar);
                groups[g].hasSolar++;
            }
        }
        console.log("rebuild_layout:group_"+g+" hasSolar="+groups[g].hasSolar);
/*
* Possible lines:
* vertical_line, horizontal_line, horizontal_split_bottom, horizontal_split_top, vertical_split_bottom, vertical_split_top
*/


if (groups[g].hasSolarMeter) {
    item={
            //count:pm.length,
            top:'horizontal_split_top',
            bottom:'horizontal_split_bottom',
            margin:5,
            height:matrix_height,
            items:[]
        };
        
    for (i=0; i < groups[g].pm.length; i++) {
        if (groups[g].pm[i].type==TYPE_SOLAR_METER) {
            item.items.push({
                    image:'/img/energymeter.png',
                    dynamic:true,
                    type:'meter',
                    index:i,
                    pm_index:groups[g].pm[i].pm_index,
                    height:matrix_height,
                    width:matrix_width
                });
        }
    }
    item.count=item.items.length;
    if (item.count>groups[g].max_items_x) 
        groups[g].max_items_x=item.count;
    groups[g].items_top.push(item);
}

if (groups[g].hasSolar) {
    item={
            count:groups[g].hasSolar,
            top:'horizontal_split_top',
            bottom:'horizontal_split_bottom',
            margin:5,
            height:matrix_height,
            items:[]
            };      
    
    if (groups[g].inv) {
        for (i=0;i<groups[g].inv.length;i++) {
                item.items.push({
                            image:urlPrefix+'/img/inverter.png',
                            caption:"",
                            dynamic:1,
                            type:'inverter',
                            index:groups[g].inv[i].index,
                            height:matrix_height,
                            width:matrix_width
                        }
                    );
    
        }
    }
    if (item.items.length>groups[g].max_items_x) 
        groups[g].max_items_x=item.items.length;
    
    groups[g].items_top.push(item);
    groups[g].items_top.push({
            count:1,
            bottom:'vertical_line',
            margin:5,
            height:matrix_height,
            
            items:[
                {
                    image:urlPrefix+'/img/solar.svg',
                    label_right:"Solar",
                    height:matrix_height,
                    width:matrix_width
                }
            ]
            });
            
}


if (groups[g].hasGrid) {
    // add the grid meters
    item={
            
            left:'vertical_split_left',
            right:'vertical_split_right',
            margin:5,
            height:matrix_height,
            
            items:[]
            };      

    for (i=0; i < groups[g].pm.length; i++) {
        if (groups[g].pm[i].type==TYPE_GRID) {
            item.items.push({
                    image:urlPrefix+'/img/energymeter.png',
                    caption:"",
                    dynamic:true,
                    type:'meter',
                    index:i,
                    pm_index:groups[g].pm[i].pm_index,
                    height:matrix_height,
                    width:matrix_width
                });
        }
    } 
    item.count=item.items.length;
    if (item.items.length>groups[g].max_items_y) 
        groups[g].max_items_y=item.items.length;
    
    groups[g].items_left.push(item);
    // add the grid icon
       


groups[g].items_left.push({
            count:1,
            right:'horizontal_line',
            margin:5,
            items:[
                {
                    image:urlPrefix+'/img/grid.svg',
                    label_bottom:"Grid",
                    height:matrix_height,
                    width:matrix_width,
                }
            ]
            });
    
}
if (groups[g].hasLoad) {
    // add the grid meters
    item={
            count:groups[g].hasLoad,
            left:'vertical_split_left',
            right:'vertical_split_right',
            margin:5,
            height:matrix_height,
            
            items:[]
            };      

    for (i=0; i < groups[g].pm.length; i++) {
        if (groups[g].pm[i].type==TYPE_LOAD) {
            item.items.push({
                    image:urlPrefix+'/img/energymeter.png',
                    caption:"",
                    dynamic:true,
                    type:'meter',
                    index:i,
                    pm_index:groups[g].pm[i].pm_index,
                    height:matrix_height,
                    width:matrix_width
                });
        }
    }            
    if (item.items.length>groups[g].max_items_y) 
        groups[g].max_items_y=item.items.length;
    groups[g].items_right.push(item);
    // add the grid icon
    
    
}

groups[g].items_right.push({
            count:1,
            left:"horizontal_line",
            margin:5,
            items:[
                {
                    image:urlPrefix+'/img/load.svg',
                    label_bottom:"Load",
                    height:matrix_height,
                    width:matrix_width,
                }
            ]
            });

if (groups[g].hasGenset) {
    item={
            
            top:'horizontal_split_top',
            bottom:'vertical_lines',
            margin:5,
            height:matrix_height,
            items:[]
        };
        
    for (i=0; i < groups[g].pm.length; i++) {
        if (groups[g].pm[i].type==TYPE_GENSET) {
            item.items.push({
                    image:urlPrefix+'/img/energymeter.png',
                    caption:"",
                    dynamic:true,
                    type:'meter',
                    index:i,
                    pm_index:groups[g].pm[i].pm_index,
                    height:matrix_height,
                    width:matrix_width 
                });
        }
    }
    item.count=item.items.length;
    groups[g].items_bottom.push(item);
    item={
            //count:1,
            top:'vertical_lines',
            margin:5,
            height:matrix_height,
            items:[]
        };
        
    for (i=0; i < groups[g].pm.length; i++) {
        if (groups[g].pm[i].type==TYPE_GENSET) {
            item.items.push({
                    image:urlPrefix+'/img/genset.svg',
                    label_bottom:"Genset",
                    height:matrix_height,
                    width:matrix_width
                });
        };
    }
    item.count=item.items.length;
    groups[g].items_bottom.push(item);
}

}  

  max_items_x=0;
  max_items_y=0;
  for (g=1;g<groups.length;g++) {
      max_items_x+=groups[g].max_items_x+1;
      max_items_y+=groups[g].max_items_y;
  }
}
console.log("max_items_x="+max_items_x);
console.log("max_items_y="+max_items_y);
console.log(groups);
}

rebuild_layout();
/**
 * Draw an arrowhead on a line on an HTML5 canvas.
 *
 * Based almost entirely off of http://stackoverflow.com/a/36805543/281460 with some modifications
 * for readability and ease of use.
 *
 * @param context The drawing context on which to put the arrowhead.
 * @param from A point, specified as an object with 'x' and 'y' properties, where the arrow starts
 *             (not the arrowhead, the arrow itself).
 * @param to   A point, specified as an object with 'x' and 'y' properties, where the arrow ends
 *             (not the arrowhead, the arrow itself).
 * @param radius The radius of the arrowhead. This controls how "thick" the arrowhead looks.
 */
function drawArrowhead(context, from, to, radius) {
	var x_center = to.x;
	var y_center = to.y;

	var angle;
	var x;
	var y;

	context.beginPath();

	angle = Math.atan2(to.y - from.y, to.x - from.x)
	x = radius * Math.cos(angle) + x_center;
	y = radius * Math.sin(angle) + y_center;

	context.moveTo(x, y);

angle += (1.0/3.0) * (2 * Math.PI)
	x = radius * Math.cos(angle) + x_center;
	y = radius * Math.sin(angle) + y_center;

	context.lineTo(x, y);

	angle += (1.0/3.0) * (2 * Math.PI)
	x = radius *Math.cos(angle) + x_center;
	y = radius *Math.sin(angle) + y_center;

	context.lineTo(x, y);

	context.closePath();

	context.fill();
}
//drawLine(ctx,bar_color,item.bottom,item.count,cur_x,cur_y+gridWidth*0.9,cur_width,gridHeight-gridWidth*0.9); // top quadrant
function drawLine(ctx, color, line_type, num_items, x, y, w, h) {
    ctx.beginPath();

    ctx.lineWidth=1;
    ctx.strokeStyle=color;

    if (line_type=='horizontal_line') {
        ctx.moveTo(x,Math.floor(y+h/2));
        ctx.lineTo(x+w,Math.floor(y+h/2));
        ctx.stroke();

    }

    if (line_type=='horizontal_lines') {
        item_height=h/num_items;
        console.log("item height="+item_height);
        for (i=0;i<num_items;i++) {

            ctx.moveTo(x,Math.floor(y+item_height*i+item_height/2));
            ctx.lineTo(x+w,Math.floor(y+item_height*i+item_height/2));
            ctx.stroke();
        }

    }
    
    if (line_type=='vertical_line') {
        console.log("VLINE=");
        console.log((x+w/2)+" "+y);
        ctx.moveTo((x+w/2),y);
        ctx.lineTo((x+w/2),y+h);
        ctx.stroke();

    }
    
    if (line_type=='vertical_lines') {
        item_width=w/num_items;
        console.log("item width="+item_width);
        for (i=0;i<num_items;i++) {
            ctx.moveTo(Math.floor(x+item_width*i+item_width/2),y);
            ctx.lineTo(Math.floor(x+item_width*i+item_width/2),y+h);
            ctx.stroke();
        }
    }
    
    if (line_type=='horizontal_split_top') {
    
        item_width=w/num_items;
        console.log("item width="+item_width);
        ctx.moveTo(x+w/2,y);
        ctx.lineTo(x+w/2,y+h/3);
        ctx.stroke();
        
        ctx.moveTo(x+item_width/2,y+h/3);        
        ctx.lineTo(x+w-item_width/2,y+h/3);
        ctx.stroke();
        
        for (i=0;i<num_items;i++) {
            ctx.moveTo(x+item_width*i+item_width/2,y+h/3);
            ctx.lineTo(x+item_width*i+item_width/2,y+h);
            ctx.stroke();
        }
    }
    
    if (line_type=='horizontal_split_bottom') {
        item_width=w/num_items;
        console.log("item width="+item_width);
        ctx.moveTo(Math.floor(x+item_width/2),Math.floor(y+h*2/3));
        ctx.lineTo(Math.floor(x+w-item_width/2),Math.floor(y+h*2/3));
        ctx.stroke();
    
        
        for (i=0;i<num_items;i++) {
            ctx.moveTo(Math.floor(x+item_width*i+item_width/2),y);
            ctx.lineTo(Math.floor(x+item_width*i+item_width/2),Math.floor(y+h*2/3));
            ctx.stroke();
        }
        ctx.moveTo(Math.floor(x+w/2),Math.floor(y+h*2/3));
        ctx.lineTo(Math.floor(x+w/2),y+h);
        ctx.stroke();
    }
    
    if (line_type=='vertical_split_left') {
        item_height=h/num_items;
        console.log("item height="+item_height);
        ctx.moveTo(x,Math.floor(y+h/2));
        ctx.lineTo(Math.floor(x+w/3),Math.floor(y+h/2));
        ctx.stroke();
        
        ctx.moveTo(Math.floor(x+w/3),Math.floor(y+item_height/2));
        ctx.lineTo(Math.floor(x+w/3),Math.floor(y+h-item_height/2));
        ctx.stroke();
        for (i=0;i<num_items;i++) {

            ctx.moveTo(Math.floor(x+w/3),Math.floor(y+item_height*i+item_height/2));
            ctx.lineTo(Math.floor(x+w),Math.floor(y+item_height*i+item_height/2));
            ctx.stroke();
        }

    }
    if (line_type=='vertical_split_right') {
        item_height=h/num_items;
        console.log("item height="+item_height);
        ctx.moveTo(x+w*2/3,y+item_height/2);
        ctx.lineTo(x+w*2/3,y+h-item_height/2);
        ctx.stroke();
        for (i=0;i<num_items;i++) {

            ctx.moveTo(x,y+item_height*i+item_height/2);
            ctx.lineTo(x+w*2/3,y+item_height*i+item_height/2);
            ctx.stroke();
        }
        ctx.moveTo(x+w*2/3,y+h/2);
        ctx.lineTo(x+w,y+h/2);
        ctx.stroke();
    }
    //ctx.endPath();
    
}

links=[];
var canvas = document.getElementById('ezcanvas');
fitToContainer(canvas);

function fitToContainer(canvas) {
  // Make it visually fill the positioned parent
  canvas.style.width ='100%';
  canvas.style.height='100%';
  // ...then set the internal size to match
  canvas.width  = canvas.offsetWidth;
  canvas.height = canvas.offsetHeight;
}

const getContext = () => document.getElementById('ezcanvas').getContext('2d');

canvasWidth=document.getElementById('ezcanvas').width;
canvasHeight=document.getElementById('ezcanvas').height;

function calc_gridsize() {
    var max_c=0;
    var l=1;
    
    if (num_groups<=1) {
        for (i=0;i<items_left.length;i++) {
            if (items_left[i].count>max_c) {
               max_c=items_left[i].count;
               l=1;
            }
        }
        for (i=0;i<items_right.length;i++) {
            if (items_right[i].count>max_c) {
               max_c=items_right[i].count;
               l=0;
            }
        } 
    // calculate the total number of 'blocks' vertically
    gridSizeY = items_top.length + items_bottom.length + max_c + 4;
    console.log("itemstop.legnth="+items_top.length+" bottom="+items_bottom.length);
    
    if (!items_top.length && !items_bottom.length) gridSizeY=3;
    
    gridSizeX = items_left.length + items_right.length;
    console.log("items_left.legnth="+items_left.length+" items_right="+items_right.length);
    console.log("GridSizeX="+gridSizeX);
    
    console.log("GridSizeY="+gridSizeY);
    } else {  // multi group
        var num_v=0;
        gridSizeY=3;
        gridSizeX=0;
        for (g=1;g<num_groups;g++) {
            for (i=0;i<groups[g].items_left.length;i++) {
                if (groups[g].items_left[i].count>max_c) {
                   max_c=groups[g].items_left[i].count;
                   l=1;
                }
    
            }
            for (i=0;i<groups[g].items_right.length;i++) {
                if (groups[g].items_right[i].count>max_c) {
                   max_c=groups[g].items_right[i].count;
                   l=0;
                }
            } 
        
        // calculate the total number of 'blocks' vertically
        if (groups[g].items_top.length + groups[g].items_bottom.length + max_c + 3 > gridSizeY)
            gridSizeY = groups[g].items_top.length + groups[g].items_bottom.length + max_c + 3;
        console.log("itemstop.legnth="+groups[g].items_top.length+" bottom="+groups[g].items_bottom.length);
        
        //if (!groups[g].items_top.length && !groups[g].items_bottom.length && !gridS) gridSizeY=3;
        
        gridSizeX += groups[g].items_left.length + groups[g].items_right.length;
        console.log("items_left.legnth="+groups[g].items_left.length+" items_right="+groups[g].items_right.length);
        console.log("GridSizeX="+gridSizeX);
        
        console.log("GridSizeY="+gridSizeY);
        }
      
    }
    
    ctx = canvas.getContext('2d')
    ctx.font = FONT_SIZE+'px sans-serif';
    lineHeight=ctx.measureText('M').width+2;
    lineWidth=ctx.measureText('88.8kW').width+5;
    gridWidth=(canvasWidth)/(max_items_x+num_groups*3);  //   gridWidth=canvasWidth/gridSizeX;
    gridHeight=(canvasHeight-20)/gridSizeY;
    console.log("max_itemsX="+max_items_x);
    console.log("max_itemsY="+max_items_y);
    if (gridWidth*max_items_x > canvasWidth) gridWidth=canvasWidth / (max_items_x+1);
    if (gridHeight*max_items_y > canvasHeight) gridHeight=canvasHeight / (max_items_y+1);
    if (gridWidth > gridHeight) {
        gridWidth=gridHeight;
    } else gridHeight=gridWidth;
    
    //if (gridHeight<100) 
     //gridHeight=100;
    console.log("GridSizeX="+gridSizeX);
    console.log("GridSizeY="+gridSizeY);
    
    console.log("w="+gridSizeX*gridWidth);
    console.log("GridSizeY="+gridSizeY);
     
    console.log("GridWidth="+gridWidth);
    console.log("GridHeight="+gridHeight);
    
    if (lineHeight>12) 
        gridHeight+=10+lineHeight-12;  // adjust for larger fonts
    centerX=canvasWidth/2 - gridWidth/2;//-(gridWidth*items_left.length)/2;
    centerY=0;//gridHeight*items_top.length;
    if (!centerY) centerY=canvasHeight/2 - gridHeight/2;
}

calc_gridsize();

// It's better to use async image loading.
const loadImage = url => {
  return new Promise((resolve, reject) => {
    const img = new Image();
    img.onload = () => resolve(img);
    img.onerror = () => reject(new Error('load ${url} fail'));
    img.src = url;
  });
};

// Here, I created a function to draw image.
const depict = options => {
  const ctx = getContext();
  // And this is the key to this solution
  // Always remember to make a copy of original object, then it just works :)
  const myOptions = Object.assign({}, options);
  return loadImage(myOptions.uri).then(img => {
    ctx.drawImage(img, myOptions.x, myOptions.y, myOptions.sw, myOptions.sh);
  });
};

imgs = [];
var canvas = document.getElementById('ezcanvas');
ctx = canvas.getContext('2d');
//myctx.save();
ctx.save()

function drawGrid(ctx) {
    ctx.beginPath();
    
    ctx.lineWidth=0.5;
    ctx.strokeStyle="#c0c0c0";
    offsetX=centerX-items_left.length*gridWidth;
    offsetY=centerY-items_top.length*gridHeight;
    for (i=0;i<=gridSizeX;i++) {
        ctx.moveTo(i*gridWidth+offsetX,0);
        ctx.lineTo(i*gridWidth+offsetX,canvasHeight);
        ctx.stroke();    
    }
    
    for (i=0;i<=gridSizeY;i++) {
        ctx.moveTo(0,i*gridHeight+offsetY);
        ctx.lineTo(canvasWidth,i*gridHeight+offsetY);
        ctx.stroke();    
    }
    //ctx.endPath();

}

//drawGrid(ctx);
 
function progressBar(context,x,y,size,percent,percent_now,percent_potential){
    diff=(percent/100)*Math.PI*2;
    diff2=(percent_now/100)*Math.PI*2;
    diff3=(percent_potential/100)*Math.PI*2;
    
    start=0;
    cw=x+size/2;
    ch=y+size/2;
    context.clearRect(x-size/2,y-size/2,size*2,size*2);
    context.beginPath();
    context.lineWidth=size*0.8;
    context.strokeStyle='#eeeeee';
    context.arc(cw,ch,size/2,0,2*Math.PI,false);
    context.fillStyle='#eeeeee';
    context.fill();
    if (percent_potential>percent) {
        // potential generation
        context.lineWidth=size*0.8;
        context.strokeStyle='#b3cccc';//#b3cf3c';
        context.beginPath();
        context.arc(cw,ch,size/2,start,diff3+start,false);
        context.stroke();
    }
    context.strokeStyle='#e7f2ba';
    context.stroke();
    context.fillStyle='#000';
    context.strokeStyle='#ffad99';//#b3cf3c';
    context.textAlign='center';
    context.lineWidth=size*0.8;
    //context.font = '10pt Verdana';
    context.beginPath();
    context.arc(cw,ch,size/2,start,diff+start,false);
    context.stroke();
    
    
    //context.fillText(percent+'%',cw+2,ch+6);
    
    context.beginPath();
    context.lineWidth=size*0.4;
    context.arc(cw,ch,size/2,0,2*Math.PI,false);
    context.fillStyle='#FFFFFF';
    context.fill();
    context.strokeStyle='#e7f2ba';
//    context.stroke();
    context.fillStyle='#000';
    /*if (percent-percent_now>2) 
        context.strokeStyle='#ff9900';
    else*/
        context.strokeStyle='#009900';//#b3cf3c';
    context.textAlign='center';
    context.lineWidth=size*0.4;
    //context.font = '10pt Verdana';
    context.beginPath();
    context.arc(cw,ch,size/2,start,diff2+start,false);
    context.stroke();
    context.fillStyle='#000000';
    context.textBaseline = 'top';
    context.font = '10px Roboto, Helvetica, Arial';
   // context.fillText(percent_now+"%",cw, ch-5);
}
function drawCanvas(ctx) {

    if (hasIrradiation)
        imgs.push({ uri: "/img/sun.png", x: canvasWidth-gridWidth, y:  0, sw: gridWidth*0.56, sh: gridWidth*0.56 });
    if (hasWindSpeed)
        imgs.push({ uri: "/img/wind.png", x: canvasWidth-gridWidth*2, y:  0, sw: gridWidth*0.56, sh: gridWidth*0.56 });
        
    if (num_groups<=1) {
        var max_c=0;
        var l=1;
        
        for (i=0;i<items_left.length;i++) {
            if (items_left[i].count>max_c) {
               max_c=items_left[i].count;
               l=1;
            }
        }
        for (i=0;i<items_right.length;i++) {
            if (items_right[i].count>max_c) {
               max_c=items_right[i].count;
               l=0;
            }
        }    
        console.log("max_c ="+max_c)    ;
            
        //yOffset = gridHeight*(items_left.length?items_left.length-1:items_left.length;    
        if (max_c>1) {
            if (l) 
                top_offset = gridHeight/2+(items_left.length-1)*gridHeight;
            else top_offset = gridHeight/2+(items_right.length-1)*gridHeight;
        }
        else top_offset=gridHeight/2;
        if (items_top.length)
            drawLine(ctx,bar_color,"vertical_line",1,centerX,Math.floor(centerY+gridHeight/2),gridWidth,-top_offset); // top quadrant
            
        if (items_bottom.length)
            drawLine(ctx,bar_color,"vertical_line",1,centerX,centerY,gridWidth,Math.floor(top_offset+gridHeight/2));//gridHeight/2); // top quadrant
        console.log("num left ="+ items_left.length)    ;
        if (items_left.length)        
            drawLine(ctx,bar_color,"horizontal_line",1,centerX,centerY,Math.floor(gridWidth/2),gridHeight); // top quadrant
        if (items_right.length)        
            drawLine(ctx,bar_color,"horizontal_line",1,Math.floor(centerX+gridWidth/2),centerY,Math.floor(gridWidth/2),gridHeight); // top quadrant        
        
            
        var i;
        if (max_c>1)
            cur_y=centerY-((max_c/2)*gridHeight);
        else cur_y=centerY;
        console.log("Cur_Y="+cur_y);
        var i;
        var font_size='16px';
        console.log("Has_Solar="+hasSolar);
        if (hasSolar>12) 
            font_size='13px';
            
        for (i=0;i<items_top.length;i++) {
            
            console.log("Item "+i);
            cur_x=centerX+gridWidth/2;
            console.log("Cur_X="+cur_x);
            cur_y-=gridHeight;
            console.log("Cur_Y="+cur_y);
            item = items_top[i];
            cur_width=item.count*gridWidth;
            cur_x-=cur_width/2;
            console.log("Width is "+cur_width);
            drawLine(ctx,bar_color,item.top,item.count,cur_x,cur_y,cur_width,gridHeight*0.2); // top quadrant
            drawLine(ctx,bar_color,item.bottom,item.count,cur_x,cur_y+gridWidth*0.8,cur_width,gridHeight-gridWidth*0.6); // top quadrant
            console.log("item items length="+item.items.length);
            if (item.items.length>10) {
                console.log("font size 13");
                font_size='13px';
            }
        
            for (j=0;j<item.items.length;j++) {
                 
                 imgs.push({ uri: item.items[j].image, x: cur_x+(gridWidth*0.22), y:  cur_y+(gridHeight*0.22), sw: gridWidth*0.56, sh: gridWidth*0.56 });
                 
                 item.items[j].x=cur_x+(gridWidth*0.22);
                 item.items[j].w=gridWidth*0.56;
                 item.items[j].h=gridWidth*0.56;
                 item.items[j].y=cur_y+(gridHeight*0.22);
                 if (item.items[j].label_right) {
                    ctx.fillStyle=label_color;
                    ctx.textBaseline = 'top';
                    
                    ctx.font = font_size+' Roboto, Helvetica, Arial';
                    ctx.fillText(item.items[j].label_right, item.items[j].x+item.items[j].w*1.1, item.items[j].y+ item.items[j].h*0.5);
                 }
                 cur_x+=gridWidth;
            }
        }
        //cur_y=centerY+(items_left.length/2*gridHeight);
        console.log(items_left);
        if (max_c>1)
            cur_y=centerY+((max_c/2)*gridHeight);
        else cur_y=centerY;
        
        cur_x=centerX;
        var i;
        for (i=0;i<items_bottom.length;i++) {
            cur_y+=gridHeight;;
            console.log("Item "+i);
            cur_x=centerX+gridWidth/2;
            console.log("Cur_X="+cur_x);
            
            console.log("Cur_Y="+cur_y);
            item = items_bottom[i];
            cur_width=item.count*gridWidth;
            cur_x-=cur_width/2;
            console.log("Width is "+cur_width);
            drawLine(ctx,bar_color,item.top,item.count,cur_x,cur_y,cur_width,gridHeight*0.22); // top quadrant
            drawLine(ctx,bar_color,item.bottom,item.count,cur_x,cur_y+gridHeight*0.78,cur_width,gridHeight*0.22); // top quadrant
            for (j=0;j<item.items.length;j++) {
                 
                 imgs.push({ uri: item.items[j].image, x: cur_x+(gridWidth*0.22), y:  cur_y+(gridHeight*0.22), sw: gridWidth*0.56, sh: gridHeight*0.56 });
                 
                 item.items[j].x=cur_x+(gridWidth*0.22);
                 item.items[j].w=gridWidth*0.56;
                 item.items[j].h=gridHeight*0.56;
                 item.items[j].y=cur_y+(gridHeight*0.22);
                 if (item.items[j].label_bottom) {
                    ctx.fillStyle=label_color;
                    ctx.textBaseline = 'top';
                    ctx.font = font_size+' Roboto, Helvetica, Arial';
                    ctx.fillText(item.items[j].label_bottom, item.items[j].x+item.items[j].w*0.5-ctx.measureText(item.items[j].label_bottom).width/2, item.items[j].y+ item.items[j].h*1.05);
                 }
                 cur_x+=gridWidth;
            }
            
        }
        cur_y=centerY;
        cur_x=centerX;
        for (i=0;i<items_left.length;i++) {
            console.log("Item "+i);
            cur_y=centerY+gridHeight/2;
            console.log("Cur_X="+cur_x);
            cur_x-=gridWidth;
            console.log("Cur_Y="+cur_y);
            item = items_left[i];
            cur_height=item.count*gridHeight;
            cur_width=gridWidth;
            cur_y-=cur_height/2;
            console.log("Width is "+cur_width);
            drawLine(ctx,bar_color,item.left,item.count,cur_x,cur_y,gridWidth*0.22,cur_height); // top quadrant
            drawLine(ctx,bar_color,item.right,item.count,cur_x+gridWidth*0.78,cur_y,gridWidth*0.22,cur_height); // top quadrant
            for (j=0;j<item.items.length;j++) {
                 
                 imgs.push({ uri: item.items[j].image, x: cur_x+(gridWidth*0.22), y:  cur_y+(gridHeight*0.22), sw: gridWidth*0.56, sh: gridHeight*0.56 });
                 item.items[j].x=cur_x+(gridWidth*0.22);
                 item.items[j].y=cur_y+(gridHeight*0.22);
                 item.items[j].w=gridWidth*0.56;
                 item.items[j].h=gridHeight*0.56;
                 if (item.items[j].label_bottom) {
                    ctx.fillStyle=label_color;
                    ctx.textBaseline = 'top';
                    ctx.font = font_size+' Roboto, Helvetica, Arial';
                    ctx.fillText(item.items[j].label_bottom, item.items[j].x+item.items[j].w*0.5-ctx.measureText(item.items[j].label_bottom).width/2, item.items[j].y+ item.items[j].h*1.05);
                 }
                 cur_y+=gridHeight;
            }
        }
        cur_y=centerY;
        cur_x=centerX;
        for (i=0;i<items_right.length;i++) {
            console.log("Item "+i);
            cur_y=centerY+gridHeight/2;
            console.log("Cur_X="+cur_x);
            cur_x+=gridWidth;
            console.log("Cur_Y="+cur_y);
            item = items_right[i];
            cur_height=item.count*gridHeight;
            cur_width=gridWidth;
            cur_y-=cur_height/2;
            console.log("Width is "+cur_width);
            drawLine(ctx,bar_color,item.left,item.count,cur_x,cur_y,gridWidth*0.22,cur_height); // top quadrant
            drawLine(ctx,bar_color,item.right,item.count,cur_x+gridWidth*0.78,cur_y,gridWidth*0.22,cur_height); // top quadrant
            for (j=0;j<item.items.length;j++) {
                 
                 imgs.push({ uri: item.items[j].image, x: cur_x+(gridWidth*0.22), y:  cur_y+(gridHeight*0.22), sw: gridWidth*0.56, sh: gridHeight*0.56 });
                 item.items[j].x=cur_x+(gridWidth*0.22);
                 item.items[j].y=cur_y+(gridHeight*0.22);
                 item.items[j].w=gridWidth*0.56;
                 item.items[j].h=gridHeight*0.56;
                 if (item.items[j].label_bottom) {
                    ctx.fillStyle=label_color;
                    ctx.textBaseline = 'top';
                    ctx.font = font_size+' Roboto, Helvetica, Arial';
                    ctx.fillText(item.items[j].label_bottom, item.items[j].x+item.items[j].w*0.5-ctx.measureText(item.items[j].label_bottom).width/2, item.items[j].y+ item.items[j].h*1.05);
                 }
                 cur_y+=gridHeight;
            }
        }
        
    } else {        // multi cluster mode
        cur_left=(canvasWidth-gridSizeX*gridWidth)/(num_groups+2);
        for (g=1;g<num_groups;g++) {
            var max_c=0;
            var l=1;
            if (groups[g].inv) {
                if (groups[g].inv.length) {
                    centerX=cur_left+gridWidth*(groups[g].inv.length) / 2;
                    console.log("cur_left="+cur_left+" gridWidth="+gridWidth);
                    console.log("inv length g "+g+" = "+groups[g].inv.length);
                
                    cur_left += gridWidth*(groups[g].inv.length+2);
                }  
                else {
                    centerX=cur_left+gridWidth*(1) / 2;
                    cur_left += gridWidth*(3);
                    
                }
            } else {
                centerX=cur_left+gridWidth*5;
            
                cur_left += gridWidth*5;
                
            }
            
            for (i=0;i<groups[g].items_left.length;i++) {
                if (groups[g].items_left[i].count>max_c) {
                   max_c=groups[g].items_left[i].count;
                   l=1;
                }
            }
            for (i=0;i<groups[g].items_right.length;i++) {
                if (groups[g].items_right[i].count>max_c) {
                   max_c=groups[g].items_right[i].count;
                   l=0;
                }
            }    
            console.log("max_c ="+max_c)    ;
                
            //yOffset = gridHeight*(items_left.length?items_left.length-1:items_left.length;    
            if (max_c>1) {
                if (l) 
                    top_offset = gridHeight/2+(groups[g].items_left.length-1)*gridHeight;
                else top_offset = gridHeight/2+(groups[g].items_right.length-1)*gridHeight;
            }
            else top_offset=gridHeight/2;
            if (groups[g].items_top.length)
                drawLine(ctx,bar_color,"vertical_line",1,centerX,centerY+gridHeight/2,gridWidth,-top_offset); // top quadrant
                
            if (groups[g].items_bottom.length)
                drawLine(ctx,bar_color,"vertical_line",1,centerX,centerY,gridWidth,top_offset+gridHeight/2);//gridHeight/2); // top quadrant
            console.log("num left ="+ groups[g].items_left.length)    ;
            if (groups[g].items_left.length)        
                drawLine(ctx,bar_color,"horizontal_line",1,centerX,centerY,gridWidth/2,gridHeight); // top quadrant
            if (groups[g].items_right.length)        
                drawLine(ctx,bar_color,"horizontal_line",1,centerX+gridWidth/2,centerY,gridWidth/2,gridHeight); // top quadrant        
            
                
            var i;
            if (max_c>1)
                cur_y=centerY-((max_c/2)*gridHeight);
            else cur_y=centerY;
            console.log("Cur_Y="+cur_y);
            var i;
            var font_size='16px';
            console.log("Has_Solar="+hasSolar);
            if (hasSolar>12) 
                font_size='13px';
                
            for (i=0;i<groups[g].items_top.length;i++) {
                
                console.log("Item "+i);
                cur_x=centerX+gridWidth/2;
                console.log("Cur_X="+cur_x);
                cur_y-=gridHeight;
                console.log("Cur_Y="+cur_y);
                item = groups[g].items_top[i];
                cur_width=item.count*gridWidth;
                cur_x-=cur_width/2;
                console.log("Width is "+cur_width);
                drawLine(ctx,bar_color,item.top,item.count,cur_x,cur_y,cur_width,gridHeight*0.2); // top quadrant
                drawLine(ctx,bar_color,item.bottom,item.count,cur_x,cur_y+gridWidth*0.8,cur_width,gridHeight-gridWidth*0.6); // top quadrant
                console.log("item items length="+item.items.length);
                if (item.items.length>10) {
                    console.log("font size 13");
                    font_size='13px';
                }
            
                for (j=0;j<item.items.length;j++) {
                     
                     imgs.push({ uri: item.items[j].image, x: cur_x+(gridWidth*0.22), y:  cur_y+(gridHeight*0.22), sw: gridWidth*0.56, sh: gridWidth*0.56 });
                     
                     item.items[j].x=cur_x+(gridWidth*0.22);
                     item.items[j].w=gridWidth*0.56;
                     item.items[j].h=gridWidth*0.56;
                     item.items[j].y=cur_y+(gridHeight*0.22);
                     if (item.items[j].label_right) {
                        ctx.fillStyle=label_color;
                        ctx.textBaseline = 'top';
                        
                        ctx.font = font_size+' Roboto, Helvetica, Arial';
                        ctx.fillText(item.items[j].label_right, item.items[j].x+item.items[j].w*1.1, item.items[j].y+ item.items[j].h*0.5);
                     }
                     cur_x+=gridWidth;
                }
            }
            //cur_y=centerY+(items_left.length/2*gridHeight);
            console.log(groups[g].items_left);
            if (max_c>1)
                cur_y=centerY+((max_c/2)*gridHeight);
            else cur_y=centerY;
            
            cur_x=centerX;
            var i;
            for (i=0;i<groups[g].items_bottom.length;i++) {
                cur_y+=gridHeight;;
                console.log("Item "+i);
                cur_x=centerX+gridWidth/2;
                console.log("Cur_X="+cur_x);
                
                console.log("Cur_Y="+cur_y);
                item = groups[g].items_bottom[i];
                cur_width=item.count*gridWidth;
                cur_x-=cur_width/2;
                console.log("Width is "+cur_width);
                drawLine(ctx,bar_color,item.top,item.count,cur_x,cur_y,cur_width,gridHeight*0.22); // top quadrant
                drawLine(ctx,bar_color,item.bottom,item.count,cur_x,cur_y+gridHeight*0.78,cur_width,gridHeight*0.22); // top quadrant
                for (j=0;j<item.items.length;j++) {
                     
                     imgs.push({ uri: item.items[j].image, x: cur_x+(gridWidth*0.22), y:  cur_y+(gridHeight*0.22), sw: gridWidth*0.56, sh: gridHeight*0.56 });
                     
                     item.items[j].x=cur_x+(gridWidth*0.22);
                     item.items[j].w=gridWidth*0.56;
                     item.items[j].h=gridHeight*0.56;
                     item.items[j].y=cur_y+(gridHeight*0.22);
                     if (item.items[j].label_bottom) {
                        ctx.fillStyle=label_color;
                        ctx.textBaseline = 'top';
                        ctx.font = font_size+' Roboto, Helvetica, Arial';
                        ctx.fillText(item.items[j].label_bottom, item.items[j].x+item.items[j].w*0.5-ctx.measureText(item.items[j].label_bottom).width/2, item.items[j].y+ item.items[j].h*1.05);
                     }
                     cur_x+=gridWidth;
                }
                
            }
            cur_y=centerY;
            cur_x=centerX;
            for (i=0;i<groups[g].items_left.length;i++) {
                console.log("Item "+i);
                cur_y=centerY+gridHeight/2;
                console.log("Cur_X="+cur_x);
                cur_x-=gridWidth;
                console.log("Cur_Y="+cur_y);
                item = groups[g].items_left[i];
                cur_height=item.count*gridHeight;
                cur_width=gridWidth;
                cur_y-=cur_height/2;
                console.log("Width is "+cur_width);
                drawLine(ctx,bar_color,item.left,item.count,cur_x,cur_y,gridWidth*0.22,cur_height); // top quadrant
                drawLine(ctx,bar_color,item.right,item.count,cur_x+gridWidth*0.78,cur_y,gridWidth*0.22,cur_height); // top quadrant
                for (j=0;j<item.items.length;j++) {
                     
                     imgs.push({ uri: item.items[j].image, x: cur_x+(gridWidth*0.22), y:  cur_y+(gridHeight*0.22), sw: gridWidth*0.56, sh: gridHeight*0.56 });
                     item.items[j].x=cur_x+(gridWidth*0.22);
                     item.items[j].y=cur_y+(gridHeight*0.22);
                     item.items[j].w=gridWidth*0.56;
                     item.items[j].h=gridHeight*0.56;
                     if (item.items[j].label_bottom) {
                        ctx.fillStyle=label_color;
                        ctx.textBaseline = 'top';
                        ctx.font = font_size+' Roboto, Helvetica, Arial';
                        ctx.fillText(item.items[j].label_bottom, item.items[j].x+item.items[j].w*0.5-ctx.measureText(item.items[j].label_bottom).width/2, item.items[j].y+ item.items[j].h*1.05);
                     }
                     cur_y+=gridHeight;
                }
            }
            cur_y=centerY;
            cur_x=centerX;
            for (i=0;i<groups[g].items_right.length;i++) {
                console.log("Item "+i);
                cur_y=centerY+gridHeight/2;
                console.log("Cur_X="+cur_x);
                cur_x+=gridWidth;
                console.log("Cur_Y="+cur_y);
                item = groups[g].items_right[i];
                cur_height=item.count*gridHeight;
                cur_width=gridWidth;
                cur_y-=cur_height/2;
                console.log("Width is "+cur_width);
                drawLine(ctx,bar_color,item.left,item.count,cur_x,cur_y,gridWidth*0.22,cur_height); // top quadrant
                drawLine(ctx,bar_color,item.right,item.count,cur_x+gridWidth*0.78,cur_y,gridWidth*0.22,cur_height); // top quadrant
                for (j=0;j<item.items.length;j++) {
                     
                     imgs.push({ uri: item.items[j].image, x: cur_x+(gridWidth*0.22), y:  cur_y+(gridHeight*0.22), sw: gridWidth*0.56, sh: gridHeight*0.56 });
                     item.items[j].x=cur_x+(gridWidth*0.22);
                     item.items[j].y=cur_y+(gridHeight*0.22);
                     item.items[j].w=gridWidth*0.56;
                     item.items[j].h=gridHeight*0.56;
                     if (item.items[j].label_bottom) {
                        ctx.fillStyle=label_color;
                        ctx.textBaseline = 'top';
                        ctx.font = font_size+' Roboto, Helvetica, Arial';
                        ctx.fillText(item.items[j].label_bottom, item.items[j].x+item.items[j].w*0.5-ctx.measureText(item.items[j].label_bottom).width/2, item.items[j].y+ item.items[j].h*1.05);
                     }
                     cur_y+=gridHeight;
                }
            }
        }  //g
    }
}

calc_gridsize();
drawCanvas(ctx);

ctx.restore();

imgs.forEach(depict);

var hover = false, id;
var _i, _b;

// Render everything
//renderMap();
canvas.onmousemove = function(e) {
    e.preventDefault();
    e.stopPropagation();
    // Get the current mouse position
    var r = canvas.getBoundingClientRect(),
        x = e.clientX - r.left, y = e.clientY - r.top;
    hover = false;
    var newCursor='default';
    //ctx.clearRect(0, 0, canvas.width, canvas.height);
    if (num_groups<=1) {
    for (var i=0;i<items_top.length;i++) {
        for (var j=0;j<items_top[i].items.length;j++) {
             if (items_top[i].items[j].type=='inverter') {
                idx = items_top[i].items[j].index;
                item=items_top[i];
                if(x >= item.items[j].x && x <= item.items[j].x + item.items[j].w &&
                   y >= item.items[j].y && y <= item.items[j].y + item.items[j].h) {
                    // The mouse honestly hits the rect
                    hover = true;
                    id = i;
                    newCursor='pointer';
                    //console.log("Mouseover!");


/*get the coordinates of the button element using jquery offset*/
/*get the top Position of the info element. $(window).scrollTop() is used to calculate the right top coordinate of the button element after the window is scrolled*/
var offset = $("#ezcanvas").offset();	
var topOffset = $("#ezcanvas").offset().top- $(window).scrollTop();
if (item.items[j].reactive_power!=0) {
//    console.log("Reactive:"+item.items[j].reactive_power);
    tmpStr="<tr><td>Reactive Generation</td><td>"+(item.items[j].reactive_power/1000).toFixed(2)+"kW</td></tr>";
} else tmpStr="";
    $("#canvastitle").html("<table class='table table-striped'><tr><td>Rating</td><td>"+item.items[j].rating+"kW</td></tr><tr><td>Power Limit</td><td>"+item.items[j].pc+"% of rated</td></tr><tr><td>Active Generation</td><td>"+item.items[j].pc_now+"%</td></tr>"+(tmpStr.length>0?tmpStr:"")+"<tr><td>Potential</td><td>"+item.items[j].pc_potential+"%</td></tr></table>");
  /*set the position of the info element*/
	 $("#canvastitle").css({
        position: "fixed",
        top: (topOffset + item.items[j].y + item.items[j].h)+ "px",
        left: (offset.left+item.items[j].x) + "px",
        
    });


                    break;
                }
             }
        }
    }
    if (newCursor=='default') {
  /*hide info element on mouseout*/
             $('#canvastitle').css({'left':-9999});

    }
    canvas.style.cursor=newCursor;
    } else {  // multi cluster
    for (g=1;g<num_groups;g++) {
        for (var i=0;i<groups[g].items_top.length;i++) {
            for (var j=0;j<groups[g].items_top[i].items.length;j++) {
                 if (groups[g].items_top[i].items[j].type=='inverter') {
                    idx = groups[g].items_top[i].items[j].index;
                    item=groups[g].items_top[i];
                    if(x >= item.items[j].x && x <= item.items[j].x + item.items[j].w &&
                       y >= item.items[j].y && y <= item.items[j].y + item.items[j].h) {
                        // The mouse honestly hits the rect
                        hover = true;
                        id = i;
                        newCursor='pointer';
                        //console.log("Mouseover!");
    
    
    /*get the coordinates of the button element using jquery offset*/
    /*get the top Position of the info element. $(window).scrollTop() is used to calculate the right top coordinate of the button element after the window is scrolled*/
    var offset = $("#ezcanvas").offset();	
    var topOffset = $("#ezcanvas").offset().top- $(window).scrollTop();
    if (item.items[j].reactive_power!=0) {
    //    console.log("Reactive:"+item.items[j].reactive_power);
        tmpStr="<tr><td>Reactive Generation</td><td>"+(item.items[j].reactive_power/1000).toFixed(2)+"kW</td></tr>";
    } else tmpStr="";
        $("#canvastitle").html("<table class='table table-striped'><tr><td>Rating</td><td>"+item.items[j].rating+"kW</td></tr><tr><td>Power Limit</td><td>"+item.items[j].pc+"% of rated</td></tr><tr><td>Active Generation</td><td>"+item.items[j].pc_now+"%</td></tr>"+(tmpStr.length>0?tmpStr:"")+"<tr><td>Potential</td><td>"+item.items[j].pc_potential+"%</td></tr></table>");
      /*set the position of the info element*/
    	 $("#canvastitle").css({
            position: "fixed",
            top: (topOffset + item.items[j].y + item.items[j].h)+ "px",
            left: (offset.left+item.items[j].x) + "px",
            
        });
    
    
                        break;
                    }
                 }
            }
        }
    }
    if (newCursor=='default') {
  /*hide info element on mouseout*/
             $('#canvastitle').css({'left':-9999});

    }
    canvas.style.cursor=newCursor;        
    }
}

$scope.$watch('livedata', function(liveData) {        
    if (liveData) {
        $scope.data=liveData;
        imgs2=[];
        // recheck if a full redraw is required
        var found=0;
        var canvas = document.getElementById('ezcanvas');
        myctx = canvas.getContext('2d');
        myctx.save();
        console.log("LIVEDATA")    ;
        // check if inverters have switched groups, triggering a full redraw
        for (g=0;g<groups.length;g++) {
            groups[g].inv=[];
            groups[g].hasSolar=0;
        }
        for (i = 0; i < $scope.data.ez.inv.length; i++) {
            if ($scope.data.ez.inv[i].has_pc==1) {
                grp=$scope.data.ez.inv[i].group;
                inv[i].cur_group=grp;
                var grp_idx=1;
                for (gn=1;gn<64;gn*=2) {
                    if (inv[i].cur_group==gn) {
                        grp=grp_idx;
                        break;
                    } else if (grp==0 && (inv[i].group & gn)) {
                            console.log("inv "+i+" is part of gorup "+inv[i].group);
                            grp=grp_idx;
                            break;
                    }
                    grp_idx++;
                    
                    
                }
               /* groups[grp].hasSolar++;
                groups[grp].inv.push(inv[i]);*/
                 if (groups && (groups[grp])) {
                    groups[grp].hasSolar=Number(groups[grp].hasSolar)+1;
                    groups[grp].inv.push(inv[i]);
                }
            }
        }
        
        var need_redraw=0;
        for (g=1;g<groups.length;g++) {
            console.log("c "+groups[g].inv.length+" "+groups[g].inv_count);
            if (groups[g].inv.length!=groups[g].inv_count) {
                
                groups[g].inv_count=groups[g].inv.length;
                need_redraw=1;
            }
        }
        if (need_redraw) {
            console.log("GROUP DATA:");
            console.log(groups);
            console.log("Redrawing full layout as inverter positions have changed");
            
            myctx.clearRect(0, 0, canvas.width, canvas.height);
            imgs = [];
            
            rebuild_layout();
            calc_gridsize();
            
            drawCanvas(myctx);
            imgs.forEach(depict);
            console.log(groups);
            
        }
        myctx.font = get_font_size();
        lineHeight=myctx.measureText('M').width+2;
        //alert(lineHeight);
        //var text_title = $scope.data.ez1;
        //myctx.fillText(text_title, 15, canvas.height / 2 + 35);
        
        if (hasIrradiation) {
            myctx.fillStyle=text_background_color;
            myctx.textBaseline = 'top';
            myctx.fillRect(canvasWidth-gridWidth,gridHeight*0.6,gridWidth,gridHeight*0.3);
            myctx.fillStyle=text_color;
            //myctx.font = FONT_SIZE+'px sans-serif';
            myctx.font = '14px sans-serif';
            myctx.font = get_font_size();
            left_offset=(gridWidth*0.5-12 - myctx.measureText($scope.data.ez.solar_irradiation.toFixed(0) + " W").width)/20;
            console.log("left_offset="+left_offset+" grid_width="+gridWidth);
            //left_clear=gridWidth/2-myctx.measureText("-8888. WW").width/2;
             {
                myctx.fillText($scope.data.ez.solar_irradiation.toFixed(0)+" W", canvasWidth-gridWidth+left_offset,gridHeight*0.6,gridWidth,gridHeight*0.3);
                if ($scope.data.ez.potential_active>0) 
                    myctx.fillText($scope.data.ez.potential_active.toFixed(1)+" kW", canvasWidth-gridWidth+left_offset,gridHeight*0.75,gridWidth,gridHeight*0.3);
            }
            
        }
        
        if (hasWindSpeed) {
            myctx.fillStyle=background_color;
            myctx.textBaseline = 'top';
            myctx.fillRect(canvasWidth-gridWidth*2,gridHeight*0.6,gridWidth,gridHeight*0.3);
            myctx.fillStyle=text_color;
            //myctx.font = FONT_SIZE+'px sans-serif';
            myctx.font = '14px sans-serif';
            myctx.font = get_font_size();
            left_offset=(gridWidth*0.56 - myctx.measureText($scope.data.ez.wind_speed.toFixed(1) + " m/s").width)/2;

            myctx.fillText($scope.data.ez.wind_speed.toFixed(1)+" m/s", canvasWidth-gridWidth*2+left_offset,gridHeight*0.6,gridWidth,gridHeight*0.3);
            
        }

        
            
        if (num_groups<=1) {
        // check inverters
        for (i=0;i<items_top.length;i++) {
            for (j=0;j<items_top[i].items.length;j++) {
                if (items_top[i].items[j].type=='meter') {
                    item=items_top[i];
                    idx = items_top[i].items[j].index;
                    if ($scope.data.ez.pm[idx].status==1) {
                        meter_st=urlPrefix+'/img/energymeter.png';
                    } else meter_st=urlPrefix+'/img/energymeter_off.png';
                    
                    //console.log("Inverter at "+items_top[i].items[j].x+","+items_top[i].items[j].y+" and index "+idx+" power="+$scope.data.ez.inv[items_top[i].items[j].index].power);
                    
                    myctx.fillStyle=background_color;
                    myctx.textBaseline = 'top';

                    if (items_top[i].items[j].image!=meter_st) {
                        items_top[i].items[j].image=meter_st;
                        imgs2.push({ uri: item.items[j].image, x: item.items[j].x, y:  item.items[j].y, sw: item.items[j].w, sh: item.items[j].h });
                    }
                    if (hasSolar>15) 
                        myctx.font = '11px sans-serif';
                    else    
                        myctx.font = '12px sans-serif';

                    myctx.fillRect(items_top[i].items[j].x, items_top[i].items[j].y-items_top[i].items[j].h*0.2, items_top[i].items[j].w*0.4, items_top[i].items[j].h*0.2);
                    //myctx.fillStyle="#CCC";
                    myctx.fillRect(items_top[i].items[j].x+items_top[i].items[j].w*0.6, items_top[i].items[j].y+items_top[i].items[j].h, lineWidth+24, lineHeight*2);
                    myctx.fillStyle=text_color;
                    
                    myctx.fillText($scope.data.ez.pm[idx].id, items_top[i].items[j].x, items_top[i].items[j].y-items_top[i].items[j].h*0.2 );
                    if ($scope.num_groups>1) {
                        myctx.fillStyle=background_color;
                        myctx.fillRect(items_top[i].items[j].x+items_top[i].items[j].w-items_top[i].items[j].w*0.2, items_top[i].items[j].y-items_top[i].items[j].h*0.2, items_top[i].items[j].w*0.2, items_top[i].items[j].h*0.2);
                        myctx.fillStyle=text_color_group;                        
                        myctx.fillText($scope.data.ez.pm[idx].group, items_top[i].items[j].x+items_top[i].items[j].w-items_top[i].items[j].w*0.2, items_top[i].items[j].y-items_top[i].items[j].h*0.2 );
                        myctx.fillStyle=text_color;
                        
                    }
                    
                    myctx.font = FONT_SIZE+'px sans-serif';
                    if (hasSolar>15) 
                    
                        myctx.font = '12px sans-serif';
                    else myctx.font = '14px sans-serif';
                    myctx.fillStyle=text_color;
                    pwr=$scope.data.ez.pm[idx].power/1000;
                    
                    if ($scope.data.ez.pm[idx].status)
                        myctx.fillText(pwr.toFixed(1)+" kW", items_top[i].items[j].x+items_top[i].items[j].w*0.6, items_top[i].items[j].y+ items_top[i].items[j].h*1.05);

                    //console.log("Meter at "+items_top[i].items[j].x+","+items_top[i].items[j].y+" and index "+items_top[i].items[j].index);
                }
                if (items_top[i].items[j].type=='inverter') {
                    idx = items_top[i].items[j].index;
                    //idx = groups[g].inv[items_top[i].items[j].index].index;
                    if ($scope.data.ez.inv[idx].status==1) {
                        meter_st=urlPrefix+'/img/inverter.png';
                    } else meter_st=urlPrefix+'/img/inverter_off.png';
                    
                    item=items_top[i];
                    if (items_top[i].items[j].image!=meter_st) {
//                        console.log("top meter "+j+" changing meter to "+meter_st);
                        items_top[i].items[j].image=meter_st;


                        imgs2.push({ uri: item.items[j].image, x: item.items[j].x, y:  item.items[j].y, sw: item.items[j].w, sh: item.items[j].h });
                    }
                    //console.log("Inverter at "+items_top[i].items[j].x+","+items_top[i].items[j].y+" and index "+idx+" power="+$scope.data.ez.inv[items_top[i].items[j].index].power);
                    if ($scope.data.ez.inv[idx].has_pc==1) {
                    
                        progressBar(myctx,items_top[i].items[j].x+items_top[i].items[j].w*1.2, items_top[i].items[j].y+items_top[i].items[j].h*0.3,items_top[i].items[j].w*0.4,$scope.data.ez.inv[idx].pc,$scope.data.ez.inv[idx].pc_now,$scope.data.ez.inv[idx].pc_potential);
                        items_top[i].items[j].pc=$scope.data.ez.inv[idx].pc;
                        items_top[i].items[j].pc_now=$scope.data.ez.inv[idx].pc_now;
                        items_top[i].items[j].reactive_power=$scope.data.ez.inv[idx].reactive_power;
                        items_top[i].items[j].rating=$scope.data.ez.inv[idx].rating;
                        items_top[i].items[j].pc_potential=$scope.data.ez.inv[idx].pc_potential;
                        //console.log("Inverter at "+(items_top[i].items[j].x+items_top[i].items[j].w*1.2)+","+items_top[i].items[j].y+items_top[i].items[j].h*0.3+" and pc "+$scope.data.ez.inv[idx].pc);
                    }
                    if (hasSolar>15) 
                        myctx.font = '11px sans-serif';
                    else myctx.font = '12px sans-serif';
                    myctx.fillStyle=background_color;
                    myctx.textBaseline = 'top';
                    myctx.textAlign='left';
                    myctx.fillRect(items_top[i].items[j].x, items_top[i].items[j].y-items_top[i].items[j].h*0.2, items_top[i].items[j].w*0.4, items_top[i].items[j].h*0.2);
                    //myctx.fillStyle="#CCC"
                    // clear the old inverter power
                    
                    //myctx.fillStyle="#eee";
                    myctx.fillRect(items_top[i].items[j].x+items_top[i].items[j].w*0.6, items_top[i].items[j].y+items_top[i].items[j].h, lineWidth, lineHeight+4);
                    
                    myctx.fillStyle=text_color;
                    myctx.fillText($scope.data.ez.inv[idx].id, items_top[i].items[j].x, items_top[i].items[j].y-items_top[i].items[j].h*0.18 );

                    if ($scope.num_groups>1) {
                        myctx.fillStyle=background_color;
                        myctx.fillRect(items_top[i].items[j].x+items_top[i].items[j].w-items_top[i].items[j].w*0.2, items_top[i].items[j].y-items_top[i].items[j].h*0.2, items_top[i].items[j].w*0.2, items_top[i].items[j].h*0.2);
                        myctx.fillStyle=text_color_group;
                        myctx.fillText($scope.data.ez.inv[idx].group, items_top[i].items[j].x+items_top[i].items[j].w-items_top[i].items[j].w*0.2, items_top[i].items[j].y-items_top[i].items[j].h*0.2 );
                        myctx.fillStyle=text_color;
                        
                    }

                    
                    myctx.font = FONT_SIZE+'px sans-serif';
                    if (hasSolar > 15)
                        myctx.font = '12px sans-serif';
                    else
                        myctx.font = '14px sans-serif';
                    myctx.fillStyle=text_color;
                    pwr=$scope.data.ez.inv[idx].power/1000;
                    if ($scope.data.ez.inv[idx].status) {
                        if (items_top[i].items.length<10)
                            myctx.fillText(pwr.toFixed(1)+" kW", items_top[i].items[j].x+items_top[i].items[j].w*0.65, items_top[i].items[j].y+ items_top[i].items[j].h);
                        else
                        myctx.fillText(pwr.toFixed(1), items_top[i].items[j].x+items_top[i].items[j].w*0.65, items_top[i].items[j].y+ items_top[i].items[j].h);
                    }
                }
            
            }
        }
        for (i=0;i<items_bottom.length;i++) {
            for (j=0;j<items_bottom[i].items.length;j++) {
                if (items_bottom[i].items[j].type=='meter') {
                    item=items_bottom[i];
                    idx = items_bottom[i].items[j].index;
                    //console.log("Inverter at "+items_top[i].items[j].x+","+items_top[i].items[j].y+" and index "+idx+" power="+$scope.data.ez.inv[items_top[i].items[j].index].power);
                    if ($scope.data.ez.pm[idx].status==1) {
                        meter_st=urlPrefix+'/img/energymeter.png';
                    } else meter_st=urlPrefix+'/img/energymeter_off.png';
                    
                    if (items_bottom[i].items[j].image!=meter_st) {
//                        console.log("top meter "+j+" changing meter to "+meter_st);
                        items_bottom[i].items[j].image=meter_st;
                        imgs2.push({ uri: item.items[j].image, x: item.items[j].x, y:  item.items[j].y, sw: item.items[j].w, sh: item.items[j].h });
                    }
                   myctx.font = '12px sans-serif';   
                    myctx.fillStyle=background_color;
                    myctx.textBaseline = 'top';

                    myctx.fillRect(items_bottom[i].items[j].x, items_bottom[i].items[j].y-items_bottom[i].items[j].h*0.2, items_bottom[i].items[j].w*0.4, items_bottom[i].items[j].h*0.2);
                    myctx.fillRect(items_bottom[i].items[j].x+items_bottom[i].items[j].w*0.6, items_bottom[i].items[j].y+items_bottom[i].items[j].h*1.05, items_bottom[i].items[j].w*1.5, items_bottom[i].items[j].h*0.4);
                    myctx.fillStyle=text_color;
                    myctx.fillText($scope.data.ez.pm[idx].id, items_bottom[i].items[j].x, items_bottom[i].items[j].y-items_bottom[i].items[j].h*0.2 );
                    
                    if ($scope.num_groups>1) {
                        myctx.fillStyle=background_color;
                        myctx.fillRect(items_bottom[i].items[j].x+items_bottom[i].items[j].w-items_bottom[i].items[j].w*0.2, items_bottom[i].items[j].y-items_bottom[i].items[j].h*0.2, items_bottom[i].items[j].w*0.2, items_bottom[i].items[j].h*0.2);
                        myctx.fillStyle=text_color_group;                        
                        myctx.fillText($scope.data.ez.pm[idx].group, items_bottom[i].items[j].x+items_bottom[i].items[j].w-items_bottom[i].items[j].w*0.2, items_bottom[i].items[j].y-items_bottom[i].items[j].h*0.2 );
                        myctx.fillStyle=text_color;
                        
                    }
                    
                    pwr=$scope.data.ez.pm[idx].power/1000;
                    if (hasSolar > 15)
                        myctx.font = '12px sans-serif';
                    else
                        myctx.font = '14px sans-serif';
                    if ($scope.data.ez.pm[idx].status) {
                        if ($scope.data.ez.pm[idx].min || $scope.data.ez.pm[idx].max) {
                            if ((pwr<$scope.data.ez.pm[idx].min) || (pwr>$scope.data.ez.pm[idx].max)) {
                                myctx.fillStyle="red";
                            }
                        }
                        myctx.fillText(pwr.toFixed(1)+"kW", item.items[j].x+item.items[j].w*0.6, item.items[j].y+ item.items[j].h*1.05);
                        

                        if (powerMode==1) {
                            pwr_a = $scope.data.ez.pm[idx].pa/1000;
                            min_phase='A';
                            min_pwr = pwr_a;
                            
                            pwr_b = $scope.data.ez.pm[idx].pb/1000;
                            if (pwr_b<min_pwr) {
                                min_phase='B';
                                min_pwr = pwr_b;
                            }
                            pwr_c = $scope.data.ez.pm[idx].pc/1000;
                            if (pwr_c<min_pwr) {
                                min_phase='C';
                                min_pwr = pwr_c;
                            }
                            myctx.font = '11px sans-serif';
                            myctx.fillStyle=text_color2;
                            myctx.fillText(min_phase+":" + min_pwr.toFixed(1)+" kW", item.items[j].x+item.items[j].w*0.6, item.items[j].y+ item.items[j].h*1.25);
                            
                        }
                    }
                        
                }
            }
        }
        
        for (i=0;i<items_left.length;i++) {
            for (j=0;j<items_left[i].items.length;j++) {
                if (items_left[i].items[j].type=='meter') {
                    item=items_left[i];
                    idx = items_left[i].items[j].index;
                    //console.log("Inverter at "+items_top[i].items[j].x+","+items_top[i].items[j].y+" and index "+idx+" power="+$scope.data.ez.inv[items_top[i].items[j].index].power);
                    if ($scope.data.ez.pm[idx].status==1) {
                        meter_st=urlPrefix+'/img/energymeter.png';
                    } else meter_st=urlPrefix+'/img/energymeter_off.png';
                    console.log("left meter "+j+" changing meter to "+meter_st);
                    if (items_left[i].items[j].image!=meter_st) {
                        
                        items_left[i].items[j].image=meter_st;
                        imgs2.push({ uri: item.items[j].image, x: item.items[j].x, y:  item.items[j].y, sw: item.items[j].w, sh: item.items[j].h });
                    }
                      myctx.font = '12px sans-serif';
                    myctx.fillStyle=background_color;
                    myctx.textBaseline = 'top';
                    left_offset=0;
                    pwr=$scope.data.ez.pm[idx].power/1000;
                    if (item.bottom) {
                        left_offset = item.items[j].w*0.6
                        left_clear=item.items[j].w*0.6;
                    } else {
                        left_offset=item.items[j].w/2-myctx.measureText(pwr.toFixed(1)+" kW").width/2;
                        left_clear=item.items[j].w/2-myctx.measureText("-8888.8 kW").width/2;
                    }
                    console.log("Left Offset="+left_offset);
                   //myctx.fillStyle="#CCC";
                    //myctx.fillRect(item.items[j].x, item.items[j].y-item.items[j].h*0.2, item.items[j].w*0.4, item.items[j].h*0.2);
                    reactive_pwr=!Number.isNaN($scope.data.ez.pm[idx].reactive_power)?$scope.data.ez.pm[idx].reactive_power/1000:0;
                    
                    myctx.fillRect(item.items[j].x-lineWidth/2, item.items[j].y+item.items[j].h, lineWidth+25, lineHeight+15);
                    myctx.fillRect(item.items[j].x-item.items[j].w*0.22, item.items[j].y+item.items[j].h*0.1, item.items[j].w*0.21, item.items[j].h*0.25);
//                    myctx.fillRect(item.items[j].x+item.items[j].w, item.items[j].y+item.items[j].h*0.1, item.items[j].w*0.22, item.items[j].h*0.25);
                    
                    myctx.fillStyle=background_color;
                    myctx.fillRect(item.items[j].x, item.items[j].y-item.items[j].h*0.2, item.items[j].w*0.4, item.items[j].h*0.2);
                    //myctx.fillStyle="#ccc";
                    myctx.fillRect(item.items[j].x+left_clear, item.items[j].y+item.items[j].h*1.05, item.items[j].w*1.5, item.items[j].h*0.4);
                    myctx.fillStyle=text_color;
                    myctx.fillText($scope.data.ez.pm[idx].id, item.items[j].x, item.items[j].y-item.items[j].h*0.2 );

                    if ($scope.num_groups>1) {
                        myctx.fillStyle=background_color;
                        myctx.fillRect(items_left[i].items[j].x+items_left[i].items[j].w-items_left[i].items[j].w*0.2, items_left[i].items[j].y-items_left[i].items[j].h*0.2, items_left[i].items[j].w*0.2, items_left[i].items[j].h*0.2);
                        myctx.fillStyle=text_color_group;     
                        //console.log("idx="+idx+" grp = "+$scope.data.ez.pm[idx].group);
                        myctx.fillText($scope.data.ez.pm[idx].group, items_left[i].items[j].x+items_left[i].items[j].w-items_left[i].items[j].w*0.2, items_left[i].items[j].y-items_left[i].items[j].h*0.2 );
                        myctx.fillStyle=text_color;
                        
                    }

                    
                    pwr=$scope.data.ez.pm[idx].power/1000;
                    
                    if (hasSolar > 15)
                        myctx.font = '12px sans-serif';
                    else
                        myctx.font = '14px sans-serif';
                    if ($scope.data.ez.pm[idx].status) {
                        if ($scope.data.ez.pm[idx].min || $scope.data.ez.pm[idx].max) {
                            if ((pwr<$scope.data.ez.pm[idx].min) || (pwr>$scope.data.ez.pm[idx].max)) {
                                myctx.fillStyle="red";
                            }
                        }
                        myctx.fillText(pwr.toFixed(1)+" kW", item.items[j].x+left_offset, item.items[j].y+ item.items[j].h*1.06);
                        if (!Number.isNaN(reactive_pwr) && (reactive_pwr!=0)) {
                             myctx.fillText(reactive_pwr.toFixed(1)+" kVAr", item.items[j].x+left_offset, item.items[j].y+ item.items[j].h*1.25);
                        } else {
                        
                            if (powerMode==1) {
                                pwr_a = $scope.data.ez.pm[idx].pa/1000;
                                min_phase='A';
                                min_pwr = pwr_a;
                                
                                pwr_b = $scope.data.ez.pm[idx].pb/1000;
                                if (pwr_b<min_pwr) {
                                    min_phase='B';
                                    min_pwr = pwr_b;
                                }
                                pwr_c = $scope.data.ez.pm[idx].pc/1000;
                                if (pwr_c<min_pwr) {
                                    min_phase='C';
                                    min_pwr = pwr_c;
                                }
                                myctx.font = '11px sans-serif';
                                myctx.fillStyle=text_color2;
                                myctx.fillText(min_phase+":" + min_pwr.toFixed(1)+" kW", item.items[j].x+left_offset, item.items[j].y+ item.items[j].h*1.25);
                                
                            }
                        }
                        
                    }
                    
                    if (pwr>0) {
                        myctx.fillStyle="#70c041";
                        drawArrowhead(myctx, {x:item.items[j].x,y:item.items[j].y+item.items[j].h*0.2}, {x:item.items[j].x+item.items[j].w*1.1,y:item.items[j].y+item.items[j].h*0.2}, item.items[j].w/8);
                    } else if (pwr<0) {
                        myctx.fillStyle="#c93838";
                        drawArrowhead(myctx, {x:item.items[j].x+item.items[j].w,y:item.items[j].y+item.items[j].h*0.2}, {x:item.items[j].x-item.items[j].w*0.1,y:item.items[j].y+item.items[j].h*0.2},item.items[j].w/8);
                    }

                    //console.log("Meter at "+items_top[i].items[j].x+","+items_top[i].items[j].y+" and index "+items_top[i].items[j].index);
                }
            }
        }
        
        for (i=0;i<items_right.length;i++) {
            for (j=0;j<items_right[i].items.length;j++) {
                if (items_right[i].items[j].type=='meter') {
                    item=items_right[i];
                    idx = items_right[i].items[j].index;
                    //console.log("Inverter at "+items_top[i].items[j].x+","+items_top[i].items[j].y+" and index "+idx+" power="+$scope.data.ez.inv[items_top[i].items[j].index].power);
                    if ($scope.data.ez.pm[idx].status==1) {
                        meter_st=urlPrefix+'/img/energymeter.png';
                    } else meter_st=urlPrefix+'/img/energymeter_off.png';
                    myctx.font = '12px sans-serif';
                    if (items_right[i].items[j].image!=meter_st) {
//                        console.log("top meter "+j+" changing meter to "+meter_st);
                        items_right[i].items[j].image=meter_st;
                        imgs2.push({ uri: item.items[j].image, x: item.items[j].x, y:  item.items[j].y, sw: item.items[j].w, sh: item.items[j].h });
                    }
                      
                    myctx.fillStyle=background_color;
                    myctx.textBaseline = 'top';
                    left_offset=0;
                    pwr=$scope.data.ez.pm[idx].power/1000;
                    
                    if (item.bottom) {
                        left_offset = item.items[j].w*0.6
                        left_clear=item.items[j].w*0.6;
                    } else {
                        left_offset=item.items[j].w/2-myctx.measureText(pwr.toFixed(1)+"kW").width/2;
                        left_clear=item.items[j].w/2-myctx.measureText("-8888.8kW").width/2;
                    }
//                    myctx.fillRect(item.items[j].x-item.items[j].w*0.22, item.items[j].y+item.items[j].h*0.1, item.items[j].w*0.21, item.items[j].h*0.25);
                    //myctx.fillRect(item.items[j].x+item.items[j].w, item.items[j].y+item.items[j].h*0.1, item.items[j].w*0.22, item.items[j].h*0.25);
                    myctx.fillRect(item.items[j].x, item.items[j].y-item.items[j].h*0.2, item.items[j].w*0.4, item.items[j].h*0.2);
                    
                    myctx.fillRect(item.items[j].x-lineWidth/2, item.items[j].y+item.items[j].h, lineWidth+25, lineHeight+15);
                    
                    myctx.fillStyle=background_color;
                    myctx.fillRect(item.items[j].x, item.items[j].y-item.items[j].h*0.2, item.items[j].w*0.4, item.items[j].h*0.2);
                    myctx.fillRect(item.items[j].x+left_clear, item.items[j].y+item.items[j].h*1.05, item.items[j].w*1.1, item.items[j].h*0.2);
                    myctx.fillStyle=text_color;
                    myctx.fillText($scope.data.ez.pm[idx].id, item.items[j].x, item.items[j].y-item.items[j].h*0.2 );
                    if (hasSolar > 15)
                        myctx.font = '12px sans-serif';
                    else
                        myctx.font = '14px sans-serif';
                    if ($scope.data.ez.pm[idx].status)
                        myctx.fillText(pwr.toFixed(1)+"kW", item.items[j].x+left_offset, item.items[j].y+ item.items[j].h*1.06);
                }
            }
        }
        
           
        
        } else {  // multi group
          
          for (g=1;g<num_groups;g++) {
              console.log("GROUP "+g);
              console.log("TOP");
            for (i=0;i<groups[g].items_top.length;i++) {
                for (j=0;j<groups[g].items_top[i].items.length;j++) {
                    if (groups[g].items_top[i].items[j].type=='meter') {
                        item=groups[g].items_top[i];
                        //idx = groups[g].items_top[i].items[j].index;
                        idx = groups[g].items_top[i].items[j].pm_index;
                        
                        if ($scope.data.ez.pm[idx].status==1) {
                            meter_st=urlPrefix+'/img/energymeter.png';
                        } else meter_st=urlPrefix+'/img/energymeter_off.png';
                        
                        //console.log("Inverter at "+items_top[i].items[j].x+","+items_top[i].items[j].y+" and index "+idx+" power="+$scope.data.ez.inv[items_top[i].items[j].index].power);
                        
                        myctx.fillStyle=text_background_color;
                        myctx.textBaseline = 'top';
    
                        if (groups[g].items_top[i].items[j].image!=meter_st) {
                            groups[g].items_top[i].items[j].image=meter_st;
                            imgs2.push({ uri: groups[g].item.items[j].image, x: item.items[j].x, y:  item.items[j].y, sw: item.items[j].w, sh: item.items[j].h });
                            console.log("Meter state change");
                        }
                        //if (hasSolar>15) 
                        myctx.font = get_font_size();
                        //else    
                          //  myctx.font = '12px sans-serif';
    
                        myctx.fillRect(groups[g].items_top[i].items[j].x, groups[g].items_top[i].items[j].y-groups[g].items_top[i].items[j].h*0.2, groups[g].items_top[i].items[j].w*0.4, groups[g].items_top[i].items[j].h*0.2);
                        //myctx.fillStyle="#CCC";
                        myctx.fillRect(groups[g].items_top[i].items[j].x+groups[g].items_top[i].items[j].w*0.6, groups[g].items_top[i].items[j].y+groups[g].items_top[i].items[j].h, lineWidth+20, lineHeight*2+5);
                        myctx.fillStyle=text_color;
                        
                        myctx.fillText($scope.data.ez.pm[idx].id, groups[g].items_top[i].items[j].x-2, groups[g].items_top[i].items[j].y-groups[g].items_top[i].items[j].h*0.2-3 );
                        if ($scope.num_groups>1) {
                            myctx.fillStyle=text_background_color;
                            myctx.fillRect(groups[g].items_top[i].items[j].x+groups[g].items_top[i].items[j].w-groups[g].items_top[i].items[j].w*0.2, groups[g].items_top[i].items[j].y-groups[g].items_top[i].items[j].h*0.2, groups[g].items_top[i].items[j].w*0.2, groups[g].items_top[i].items[j].h*0.2);
                            myctx.fillStyle=text_color_group;                        
                            myctx.fillText($scope.data.ez.pm[idx].group, groups[g].items_top[i].items[j].x+groups[g].items_top[i].items[j].w-groups[g].items_top[i].items[j].w*0.2, groups[g].items_top[i].items[j].y-groups[g].items_top[i].items[j].h*0.2 );
                            myctx.fillStyle=text_color;
                            
                        }
                        
                        myctx.font = FONT_SIZE+'px sans-serif';
                        myctx.font = get_font_size();
                        myctx.fillStyle=text_color;
                        pwr=$scope.data.ez.pm[idx].power/1000;
                        reactive_pwr=$scope.data.ez.pm[idx].reactive_power/1000;
                        if ($scope.data.ez.pm[idx].status) {
                            myctx.fillText(pwr.toFixed(1)+" kW", groups[g].items_top[i].items[j].x+groups[g].items_top[i].items[j].w*0.6, groups[g].items_top[i].items[j].y+ groups[g].items_top[i].items[j].h*1.05);
                            console.log("Top meter reactive="+reactive_pwr);
                            if (reactive_pwr!=0) {
                                 myctx.fillText(reactive_pwr.toFixed(1)+" kVAr", groups[g].items_top[i].items[j].x+groups[g].items_top[i].items[j].w*0.6, item.items[j].y+ item.items[j].h*1.25+4);
                            } else {
                            
                                if (powerMode==1) {
                                    pwr_a = $scope.data.ez.pm[idx].pa/1000;
                                    min_phase='A';
                                    min_pwr = pwr_a;
                                    
                                    pwr_b = $scope.data.ez.pm[idx].pb/1000;
                                    if (pwr_b<min_pwr) {
                                        min_phase='B';
                                        min_pwr = pwr_b;
                                    }
                                    pwr_c = $scope.data.ez.pm[idx].pc/1000;
                                    if (pwr_c<min_pwr) {
                                        min_phase='C';
                                        min_pwr = pwr_c;
                                    }
                                    myctx.font = get_font_size();
                                    myctx.fillStyle=text_color2;
                                    myctx.fillText(min_phase+":" + min_pwr.toFixed(1)+" kW", item.items[j].x+left_offset, item.items[j].y+ item.items[j].h*1.25);
                                    
                                }
                            }
                            
                        }
    
                        //console.log("Meter at "+items_top[i].items[j].x+","+items_top[i].items[j].y+" and index "+items_top[i].items[j].index);
                    }
                    if (groups[g].items_top[i].items[j].type=='inverter') {
                        idx = groups[g].items_top[i].items[j].index;
                        
                        if ($scope.data.ez.inv[idx].status==1) {
                            meter_st=urlPrefix+'/img/inverter.png';
                        } else meter_st=urlPrefix+'/img/inverter_off.png';
                        
                        item=groups[g].items_top[i];
                        if (groups[g].items_top[i].items[j].image!=meter_st) {
    //                        console.log("top meter "+j+" changing meter to "+meter_st);
                            groups[g].items_top[i].items[j].image=meter_st;
    
    
                            imgs2.push({ uri: item.items[j].image, x: item.items[j].x, y:  item.items[j].y, sw: item.items[j].w, sh: item.items[j].h });
                        }
                        //console.log("Inverter at "+items_top[i].items[j].x+","+items_top[i].items[j].y+" and index "+idx+" power="+$scope.data.ez.inv[items_top[i].items[j].index].power);
                        if ($scope.data.ez.inv[idx].has_pc==1) {
                        
                            progressBar(myctx,groups[g].items_top[i].items[j].x+groups[g].items_top[i].items[j].w*1.2, groups[g].items_top[i].items[j].y+groups[g].items_top[i].items[j].h*0.3,
                                groups[g].items_top[i].items[j].w*0.4,$scope.data.ez.inv[idx].pc,$scope.data.ez.inv[idx].pc_now,$scope.data.ez.inv[idx].pc_potential);
                            groups[g].items_top[i].items[j].pc=$scope.data.ez.inv[idx].pc;
                            groups[g].items_top[i].items[j].pc_now=$scope.data.ez.inv[idx].pc_now;
                            groups[g].items_top[i].items[j].reactive_power=$scope.data.ez.inv[idx].reactive_power;
                            groups[g].items_top[i].items[j].rating=$scope.data.ez.inv[idx].rating;
                            groups[g].items_top[i].items[j].pc_potential=$scope.data.ez.inv[idx].pc_potential;
                            //console.log("Inverter at "+(items_top[i].items[j].x+items_top[i].items[j].w*1.2)+","+items_top[i].items[j].y+items_top[i].items[j].h*0.3+" and pc "+$scope.data.ez.inv[idx].pc);
                        }
                        myctx.font = get_font_size();
                        myctx.fillStyle=background_color;
                        myctx.textBaseline = 'top';
                        myctx.textAlign='left';
                        myctx.fillRect(groups[g].items_top[i].items[j].x, groups[g].items_top[i].items[j].y-groups[g].items_top[i].items[j].h*0.2, groups[g].items_top[i].items[j].w*0.4, groups[g].items_top[i].items[j].h*0.2);
                        //myctx.fillStyle="#CCC"
                        // clear the old inverter power
                        
                        //myctx.fillStyle="#eee";
                        myctx.fillRect(groups[g].items_top[i].items[j].x+groups[g].items_top[i].items[j].w*0.6, groups[g].items_top[i].items[j].y+groups[g].items_top[i].items[j].h, lineWidth, lineHeight+4);
                        
                        myctx.fillStyle=text_color;
                        myctx.fillText($scope.data.ez.inv[idx].id, groups[g].items_top[i].items[j].x, groups[g].items_top[i].items[j].y-groups[g].items_top[i].items[j].h*0.18-3 );
    
                        if ($scope.num_groups>1) {
                            myctx.fillStyle=background_color;
                            myctx.fillRect(groups[g].items_top[i].items[j].x+groups[g].items_top[i].items[j].w-groups[g].items_top[i].items[j].w*0.2, groups[g].items_top[i].items[j].y-groups[g].items_top[i].items[j].h*0.2, groups[g].items_top[i].items[j].w*0.2, groups[g].items_top[i].items[j].h*0.2);
                            myctx.fillStyle=text_color_group;
                            myctx.fillText($scope.data.ez.inv[idx].group, groups[g].items_top[i].items[j].x+groups[g].items_top[i].items[j].w-groups[g].items_top[i].items[j].w*0.2, groups[g].items_top[i].items[j].y-groups[g].items_top[i].items[j].h*0.2-3 );
                            myctx.fillStyle=text_color;
                            
                        }
    
                        
                        myctx.font = FONT_SIZE+'px sans-serif';
                        myctx.font = get_font_size();
                        myctx.fillStyle=text_color;
                        pwr=$scope.data.ez.inv[idx].power/1000;
                        if ($scope.data.ez.inv[idx].status)
                            myctx.fillText(pwr.toFixed(1)+" kW", groups[g].items_top[i].items[j].x+groups[g].items_top[i].items[j].w*0.65, groups[g].items_top[i].items[j].y+ groups[g].items_top[i].items[j].h);
                    }
                
                }
            }
            console.log("BOTTOM");
            for (i=0;i<groups[g].items_bottom.length;i++) {
                for (j=0;j<groups[g].items_bottom[i].items.length;j++) {
                    if (groups[g].items_bottom[i].items[j].type=='meter') {
                        item=groups[g].items_bottom[i];
                        idx = groups[g].items_bottom[i].items[j].pm_index;
                        //console.log("Inverter at "+items_top[i].items[j].x+","+items_top[i].items[j].y+" and index "+idx+" power="+$scope.data.ez.inv[items_top[i].items[j].index].power);
                        if ($scope.data.ez.pm[idx].status==1) {
                            meter_st=urlPrefix+'/img/energymeter.png';
                        } else meter_st=urlPrefix+'/img/energymeter_off.png';
                        
                        if (groups[g].items_bottom[i].items[j].image!=meter_st) {
    //                        console.log("top meter "+j+" changing meter to "+meter_st);
                            groups[g].items_bottom[i].items[j].image=meter_st;
                            imgs2.push({ uri: item.items[j].image, x: item.items[j].x, y:  item.items[j].y, sw: item.items[j].w, sh: item.items[j].h });
                        }
                       myctx.font = get_font_size();
                        myctx.fillStyle=text_background_color;
                        myctx.textBaseline = 'top';
    
                        myctx.fillRect(groups[g].items_bottom[i].items[j].x, groups[g].items_bottom[i].items[j].y-groups[g].items_bottom[i].items[j].h*0.2, groups[g].items_bottom[i].items[j].w*0.4, groups[g].items_bottom[i].items[j].h*0.2);
                        myctx.fillRect(groups[g].items_bottom[i].items[j].x+groups[g].items_bottom[i].items[j].w*0.6, groups[g].items_bottom[i].items[j].y+groups[g].items_bottom[i].items[j].h*1.05, groups[g].items_bottom[i].items[j].w*1.5, groups[g].items_bottom[i].items[j].h*0.4);
                        myctx.fillStyle=text_color;
                        myctx.fillText($scope.data.ez.pm[idx].id, groups[g].items_bottom[i].items[j].x, groups[g].items_bottom[i].items[j].y-groups[g].items_bottom[i].items[j].h*0.2 );
                        
                        if ($scope.num_groups>1) {
                            myctx.fillStyle=text_background_color;
                            myctx.fillRect(groups[g].items_bottom[i].items[j].x+groups[g].items_bottom[i].items[j].w-groups[g].items_bottom[i].items[j].w*0.2, groups[g].items_bottom[i].items[j].y-groups[g].items_bottom[i].items[j].h*0.2, groups[g].items_bottom[i].items[j].w*0.2, groups[g].items_bottom[i].items[j].h*0.2);
                            myctx.fillStyle=text_color_group;                        
                            myctx.fillText($scope.data.ez.pm[idx].group, groups[g].items_bottom[i].items[j].x+groups[g].items_bottom[i].items[j].w-groups[g].items_bottom[i].items[j].w*0.2, groups[g].items_bottom[i].items[j].y-groups[g].items_bottom[i].items[j].h*0.2 );
                            myctx.fillStyle=text_color;
                            
                        }
                        
                        pwr=$scope.data.ez.pm[idx].power/1000;
                        myctx.font = get_font_size();
                        if ($scope.data.ez.pm[idx].status) {
                            if ($scope.data.ez.pm[idx].min || $scope.data.ez.pm[idx].max) {
                                if ((pwr<$scope.data.ez.pm[idx].min) || (pwr>$scope.data.ez.pm[idx].max)) {
                                    myctx.fillStyle="red";
                                }
                            }
                            myctx.fillText(pwr.toFixed(1)+"kW", item.items[j].x+item.items[j].w*0.6, item.items[j].y+ item.items[j].h*1.05);
                            
    
                            if (powerMode==1) {
                                pwr_a = $scope.data.ez.pm[idx].pa/1000;
                                min_phase='A';
                                min_pwr = pwr_a;
                                
                                pwr_b = $scope.data.ez.pm[idx].pb/1000;
                                if (pwr_b<min_pwr) {
                                    min_phase='B';
                                    min_pwr = pwr_b;
                                }
                                pwr_c = $scope.data.ez.pm[idx].pc/1000;
                                if (pwr_c<min_pwr) {
                                    min_phase='C';
                                    min_pwr = pwr_c;
                                }
                                myctx.font = get_font_size();
                                myctx.fillStyle=text_color2;
                                myctx.fillText(min_phase+":" + min_pwr.toFixed(1)+" kW", item.items[j].x+item.items[j].w*0.6, item.items[j].y+ item.items[j].h*1.25);
                                
                            }
                        }
                            
                    }
                }
            }
            console.log("LEFT");
            for (i=0;i<groups[g].items_left.length;i++) {
                for (j=0;j<groups[g].items_left[i].items.length;j++) {
                    if (groups[g].items_left[i].items[j].type=='meter') {
                        item=groups[g].items_left[i];
                        idx = groups[g].items_left[i].items[j].pm_index;
                        console.log("idx="+idx);
                        //console.log("Inverter at "+items_top[i].items[j].x+","+items_top[i].items[j].y+" and index "+idx+" power="+$scope.data.ez.inv[items_top[i].items[j].index].power);
                        
                        if ($scope.data.ez.pm[idx].status==1) {
                            meter_st=urlPrefix+'/img/energymeter.png';
                        } else meter_st=urlPrefix+'/img/energymeter_off.png';
                            console.log("top meter "+j+" changing meter to "+meter_st);                    
                        if (groups[g].items_left[i].items[j].image!=meter_st) {
    
                            groups[g].items_left[i].items[j].image=meter_st;
                            imgs2.push({ uri: item.items[j].image, x: item.items[j].x, y:  item.items[j].y, sw: item.items[j].w, sh: item.items[j].h });
                        }
                          myctx.font = get_font_size();
                        myctx.fillStyle=text_background_color;
                        myctx.textBaseline = 'top';
                        left_offset=0;
                        pwr=$scope.data.ez.pm[idx].power/1000;
                        if (item.bottom) {
                            left_offset = item.items[j].w*0.6
                            left_clear=item.items[j].w*0.6;
                        } else {
                            left_offset=item.items[j].w/2-myctx.measureText(pwr.toFixed(1)+" kW").width/2;
                            left_clear=item.items[j].w/2-myctx.measureText("-8888.8 kW").width/2;
                        }
                        console.log("Left Offset="+left_offset+" idx="+idx);
                       //myctx.fillStyle="#CCC";
                        //myctx.fillRect(item.items[j].x, item.items[j].y-item.items[j].h*0.2, item.items[j].w*0.4, item.items[j].h*0.2);
                        reactive_pwr=$scope.data.ez.pm[idx].reactive_power/1000;
                        
                        myctx.fillRect(item.items[j].x-lineWidth/2+10, item.items[j].y+item.items[j].h, lineWidth+25, lineHeight*2.15);
                        myctx.fillRect(item.items[j].x-item.items[j].w*0.22, item.items[j].y+item.items[j].h*0.1, item.items[j].w*0.21, item.items[j].h*0.25);
                        myctx.fillRect(item.items[j].x+item.items[j].w, item.items[j].y+item.items[j].h*0.1, item.items[j].w*0.22, item.items[j].h*0.25);
                        
                        myctx.fillStyle=text_background_color;
                        myctx.fillRect(item.items[j].x, item.items[j].y-item.items[j].h*0.2, item.items[j].w*0.4, item.items[j].h*0.2);
                        myctx.fillRect(item.items[j].x+left_clear, item.items[j].y+item.items[j].h*1.05, item.items[j].w*1.5, item.items[j].h*0.3);
                        myctx.fillStyle=text_color;
                        myctx.fillText($scope.data.ez.pm[idx].id, item.items[j].x, item.items[j].y-item.items[j].h*0.2 );
    
                        if ($scope.num_groups>1) {
                            myctx.fillStyle=text_background_color;
                            myctx.fillRect(groups[g].items_left[i].items[j].x+groups[g].items_left[i].items[j].w-groups[g].items_left[i].items[j].w*0.2, groups[g].items_left[i].items[j].y-groups[g].items_left[i].items[j].h*0.2, groups[g].items_left[i].items[j].w*0.2, groups[g].items_left[i].items[j].h*0.2);
                            myctx.fillStyle=text_color_group;     
                            //console.log("idx="+idx+" grp = "+$scope.data.ez.pm[idx].group);
                            myctx.fillText($scope.data.ez.pm[idx].group, groups[g].items_left[i].items[j].x+groups[g].items_left[i].items[j].w-groups[g].items_left[i].items[j].w*0.2, groups[g].items_left[i].items[j].y-groups[g].items_left[i].items[j].h*0.2 );
                            myctx.fillStyle=text_color;
                            
                        }
    
                        
                        pwr=$scope.data.ez.pm[idx].power/1000;
                        
                        myctx.font = get_font_size();
                        if ($scope.data.ez.pm[idx].status) {
                            if ($scope.data.ez.pm[idx].min || $scope.data.ez.pm[idx].max) {
                                if ((pwr<$scope.data.ez.pm[idx].min) || (pwr>$scope.data.ez.pm[idx].max)) {
                                    myctx.fillStyle="red";
                                }
                            }
                            myctx.fillText(pwr.toFixed(1)+" kW", item.items[j].x+left_offset, item.items[j].y+ item.items[j].h*1.06);
                            if (reactive_pwr!=0) {
                                 myctx.fillText(reactive_pwr.toFixed(1)+" kVAr", item.items[j].x+left_offset, item.items[j].y+ item.items[j].h*1.25+2);
                            } else {
                            
                                if (powerMode==1) {
                                    pwr_a = $scope.data.ez.pm[idx].pa/1000;
                                    min_phase='A';
                                    min_pwr = pwr_a;
                                    
                                    pwr_b = $scope.data.ez.pm[idx].pb/1000;
                                    if (pwr_b<min_pwr) {
                                        min_phase='B';
                                        min_pwr = pwr_b;
                                    }
                                    pwr_c = $scope.data.ez.pm[idx].pc/1000;
                                    if (pwr_c<min_pwr) {
                                        min_phase='C';
                                        min_pwr = pwr_c;
                                    }
                                    myctx.font = get_font_size();
                                    myctx.fillStyle=text_color2;
                                    myctx.fillText(min_phase+":" + min_pwr.toFixed(1)+" kW", item.items[j].x+left_offset, item.items[j].y+ item.items[j].h*1.25);
                                    
                                }
                            }
                            
                        }
                        
                        if (pwr>0) {
                            myctx.fillStyle="#70c041";
                            drawArrowhead(myctx, {x:item.items[j].x,y:item.items[j].y+item.items[j].h*0.2}, {x:item.items[j].x+item.items[j].w*1.1,y:item.items[j].y+item.items[j].h*0.2}, item.items[j].w/8);
                        } else if (pwr<0) {
                            myctx.fillStyle="#c93838";
                            drawArrowhead(myctx, {x:item.items[j].x+item.items[j].w,y:item.items[j].y+item.items[j].h*0.2}, {x:item.items[j].x-item.items[j].w*0.1,y:item.items[j].y+item.items[j].h*0.2},item.items[j].w/8);
                        }
    
                        //console.log("Meter at "+items_top[i].items[j].x+","+items_top[i].items[j].y+" and index "+items_top[i].items[j].index);
                    }
                }
            }
            
            console.log("RIGHT");
            for (i=0;i<groups[g].items_right.length;i++) {
                for (j=0;j<groups[g].items_right[i].items.length;j++) {
                    if (groups[g].items_right[i].items[j].type=='meter') {
                        item=groups[g].items_right[i];
                        idx = groups[g].items_right[i].items[j].pm_index;
                        console.log("idx="+idx);
                        //console.log("Inverter at "+items_top[i].items[j].x+","+items_top[i].items[j].y+" and index "+idx+" power="+$scope.data.ez.inv[items_top[i].items[j].index].power);
                        if ($scope.data.ez.pm[idx].status==1) {
                            meter_st=urlPrefix+'/img/energymeter.png';
                        } else meter_st=urlPrefix+'/img/energymeter_off.png';
                        
                        myctx.font = get_font_size();
                        if (groups[g].items_right[i].items[j].image!=meter_st) {
    //                        console.log("top meter "+j+" changing meter to "+meter_st);
                            groups[g].items_right[i].items[j].image=meter_st;
                            imgs2.push({ uri: item.items[j].image, x: item.items[j].x, y:  item.items[j].y, sw: item.items[j].w, sh: item.items[j].h });
                        }
                          
                        myctx.fillStyle=text_background_color;
                        myctx.textBaseline = 'top';
                        left_offset=0;
                        pwr=$scope.data.ez.pm[idx].power/1000;
                        reactive_pwr=$scope.data.ez.pm[idx].reactive_power/1000;
                        console.log("Reactive Power: "+reactive_pwr);
                        if (item.bottom) {
                            left_offset = item.items[j].w*0.6
                            left_clear=item.items[j].w*0.6;
                        } else {
                            left_offset=item.items[j].w/2-myctx.measureText(pwr.toFixed(1)+"kW").width/2;
                            left_clear=item.items[j].w/2-myctx.measureText("-8888.8kW").width/2;
                        }

    //                    myctx.fillRect(item.items[j].x-item.items[j].w*0.22, item.items[j].y+item.items[j].h*0.1, item.items[j].w*0.21, item.items[j].h*0.25);
                        //myctx.fillRect(item.items[j].x+item.items[j].w, item.items[j].y+item.items[j].h*0.1, item.items[j].w*0.22, item.items[j].h*0.25);
                        myctx.fillRect(item.items[j].x, item.items[j].y-item.items[j].h*0.2, item.items[j].w*0.4, item.items[j].h*0.2);
                        
                        myctx.fillRect(item.items[j].x-lineWidth/2+20, item.items[j].y+item.items[j].h, lineWidth+30, lineHeight*2.15);
                        
                        myctx.fillStyle=text_background_color;
                        myctx.fillRect(item.items[j].x, item.items[j].y-item.items[j].h*0.2, item.items[j].w*0.4, item.items[j].h*0.2);
                        myctx.fillRect(item.items[j].x+left_clear, item.items[j].y+item.items[j].h*1.05, item.items[j].w*1.1, item.items[j].h*0.2);
                        myctx.fillStyle=text_color;
                        myctx.fillText($scope.data.ez.pm[idx].id, item.items[j].x, item.items[j].y-item.items[j].h*0.2 );
                        myctx.font = get_font_size();
                        if ($scope.data.ez.pm[idx].status) {
                            myctx.fillText(pwr.toFixed(1)+"kW", item.items[j].x+left_offset, item.items[j].y+ item.items[j].h*1.06);
                        if (reactive_pwr!=0) {
                                 myctx.fillText(reactive_pwr.toFixed(1)+" kVAr", item.items[j].x+left_offset, item.items[j].y+ item.items[j].h*1.25+2);
                            } else {
                            
                                if (powerMode==1) {
                                    pwr_a = $scope.data.ez.pm[idx].pa/1000;
                                    min_phase='A';
                                    min_pwr = pwr_a;
                                    
                                    pwr_b = $scope.data.ez.pm[idx].pb/1000;
                                    if (pwr_b<min_pwr) {
                                        min_phase='B';
                                        min_pwr = pwr_b;
                                    }
                                    pwr_c = $scope.data.ez.pm[idx].pc/1000;
                                    if (pwr_c<min_pwr) {
                                        min_phase='C';
                                        min_pwr = pwr_c;
                                    }
                                    myctx.font = get_font_size();
                                    myctx.fillStyle=text_color2;
                                    myctx.fillText(min_phase+":" + min_pwr.toFixed(1)+" kW", item.items[j].x+left_offset, item.items[j].y+ item.items[j].h*1.25);
                                    
                                }
                            }
                            
                        }
                            
                    }
                }
            }
          }   
        }
        //console.log(imgs2);
//        console.log("imgs2:");
        //console.log(imgs2);
        myctx.restore();
        imgs2.forEach(depict);
        console.log("END OF UPDATE");
    }
});
}









