/* Graph Control for live data groups 
The GRP array will contain the available data points
*/
function GraphCtrl($scope) {
    container=document.getElementById("containergraph");
    var numsecs=300;
    var max=10;
    var data = [],
        energybal = [],
        // Data
        ticks = [
            [-40, "Lower"], 20, 0, 20, [40, "Upper"]
        ],
        // Ticks for the Y-Axis
        graph;
    var liveData;
    function ticksFn(n) {
        num=Math.abs((Number(n)-numsecs));
        if (num>=60) {
            return (Math.round(num/6)/10)+"m ago";
        }
        return num + 's ago';
    }

    function myFormat(a) {
        return a.y+" kW";
    }
    function update() {
//        alert(numsecs+" "+energybal.length);
        for (g=0;g<$scope.liveData.grp.length;g++) {
            data[g].splice(0,1);
            if (($scope.liveData.grp[g].c>0) || ($scope.liveData.grp[g].w_in>0))
                data[g].push([numsecs,Number($scope.liveData.grp[g].w_in)/1000]);
            else
                data[g].push([numsecs,-Number($scope.liveData.grp[g].w_out)/1000]);
        }
        
        
        max=10;
        // get the max value of the reading
        energybal.splice(0,1);
        energybal.push([numsecs,Number($scope.liveData.total_watts)]);
        
        for (i=0;i<data[0].length;i++) {
            for (j=0;j<data.length;j++) {
                data[j][i][0]=i;
                if (Math.abs(Number(data[j][i][1])/1000)>max) max=Math.abs(Number(data[j][i][1])/1000);
            }
            energybal[i][0]=i;
        }
        ticks = [
            [Math.round(-max),Math.round(-max)+"kW"], Math.round(-max/2), 0, Math.round(max/2), [Math.round(max),Math.round(max)+"kW"]
        ];
        
        // define what fields are shown
        var fields=[];
        var gColors=[];
        
        for (i=0;i<$scope.liveData.grp.length;i++) {
            if ($scope.liveData.grp[i].show==1) {
                obj=new Object();
                obj.data=data[i];
                obj.label=$scope.liveData.grp[i].name;
                obj.lines={fill:true};
                fields.push(obj);
                gColors.push($scope.liveData.grp[i].color?$scope.liveData.grp[i].color:"#C0D800");
            }
        }
        // push the energy balance
        obj=new Object();
        obj.data=energybal;
        obj.label="Balance";
        obj.lines={fill:false};
//        fields.push(obj);
        gColors.push("#0000F0");
        
        graph = Flotr.draw(container, fields, {
            colors: gColors,
            xaxis: {
                noTicks: 5,
                 margin:false,
                // Display 7 ticks.
                tickFormatter: ticksFn,
                // Displays tick values between brackets.
                min: 1,
                // Part of the series is not displayed.
                max: numsecs // Part of the series is not displayed.
            },
            yaxis: {
    //            ticks: ticks,
                // Set Y-Axis ticks
    //            min:-max,
                labelsAngle:90,
                autoscale:true,
                autoscaleMargin:0.1
    //            max: max // Maximum value along Y-Axis
            },
            grid: {
                verticalLines: true,
                backgroundColor: {
                    colors: [
                        [0, '#fff'],
                        [1, '#fff']
                    ],
                    start: 'top',
                    end: 'bottom'
                }
            },
            legend: {
                position: 'nw'
            },
            mouse: {
                track:true,
                trackFormatter:myFormat,
                relative:true
            },
            title: '',
            subtitle: ''
        });
    //setTimeout(update,1000);
    }
    setTimeout(update,1000);



   
    // this is our updater function
    $scope.$watch('livedata', function(liveData) {        
        /**
        * IMPORTANT: Must convert the data (which is a string) to numbers
        */
        //alert("called for "+scope.graphinstanceid);
        $scope.liveData=liveData;
        if(angular.isDefined(liveData)) {
            
            if (data.length==0) {
                
                // blank data to start
                
                for (g=0;g<liveData.grp.length;g++) {
                    var arr=[];
                    for (var i = 0; i <= numsecs; i += 1) {
                        arr.push([i, 0]);
                    }
//                    alert('adding group '+liveData.grp[g].name);
                    data.push(arr);
                }
                var arr=[];
                for (var i = 0; i <= numsecs; i += 1) {
                        arr.push([i, 0]);
                }
                energybal=arr;
                

            }
            update();
        }
    });
    
    
}

