<?
/**
 * @file array_sort.inc
 * @author Akash Heimlich
 * @version 1.0
 * @date 24/04/2019
 * @description Array quick sort routine
 */

define("SORT_KEY",0);
define("SORT_VALUE",1);
 
/**
  * Quick sort an array
  *
  * Since uPHP does not have a sort function, this function does the same and takes any array and sort type
  * and returns a sorted array
  *
  * @param array $array Array of key-value pairs
  * @param number $sort_type SORT_KEY (0) for key sorting, SORT_VALUE (1) for value sorting
  *
  * @return array - sorted array
  */ 
function quick_sort( $array, $sort_type )
{
    $cur = 1;
    $stack[1]['l'] = 0;
    $stack[1]['r'] = count($array)-1;
    
    // place keys & values into separate arrays
    $keys=array();
    $vals=array();
    for ($k=0;$k<count($array);$k++) {
        $keys[]=array_key($array,$k);
        $vals[]=$array[$k];
    }
    
    for ($x=1;( $cur != 0 );$x=0) {
        $l = $stack[$cur]['l'];
        $r = $stack[$cur]['r'];
        $cur--;
          
        for ($q=0;( $l < $r );$q=1) {
            $i = $l;
            $j = $r;
            $tmp_idx=intval( ($l+$r)/2 );
            if ($sort_type==SORT_KEY)
                $tmp = $keys[$tmp_idx];
            else
                $tmp = $vals[$tmp_idx];
                
           // partion the array in two parts.
           // left from $tmp are with smaller values,
           // right from $tmp are with bigger ones
            for ($p=0;( $i <= $j );$p=1) {
                if ($sort_type==SORT_KEY) {
                    while( $keys[$i] < $tmp )
                        $i++;
                    
                    while( $tmp < $keys[$j] ) 
                        $j--;
                } else {
                    while( $vals[$i] < $tmp )
                        $i++;
                
                    while( $tmp < $vals[$j] ) 
                        $j--;
                
                }
                
                // swap elements from the two sides 
                if( $i <= $j ) {
                    $w = $keys[$i];
                    $v = $vals[$i];

                    $keys[$i] = $keys[$j];
                    $keys[$j] = $w;
                    $vals[$i]=$vals[$j];
                    $vals[$j]=$v;

                    $i++;
                    $j--;
                }
               
            } ;
           
        
            if( $i < $r )
            {
                $cur++;
                $stack[$cur]['l'] = $i;
                $stack[$cur]['r'] = $r;
            }
            $r = $j;
          
        };
  
    }
    $array=array();
 
    for ($i=0;$i<count($keys);$i++) {
        $array[$keys[$i]]=$vals[$i];
    }
    return $array;
}
	
?>


