<?
/**
 * @file string.inc
 * @author Akash Heimlich
 * @version 1.0
 * @date 24/06/2019
 * @description Common uPHP string functions
 */
 
/**
  * Replace a sequence ina  string
  *
  * Since uPHP does not have a str_replace() function, this function does the same and takes any string of characters
  * and returns a URL-encoded version of the string
  *
  * @param string $s String sequence to find
  * @param string $s String sequence to replace with
  * @param string $s String to search through
  *
  * @return string String with characters replaced
  */ 
function str_replace($search,$replace,$s)
{
    $slen=strlen($s);
    $searchlen=strlen($search);
    $res='';
	for ($i=0; $i<$slen; $i++) {
	    if (substr($s,$i,$searchlen)==$search) {
	        $res.=$replace;
	        $i+=$searchlen-1;
	    } else $res.=substr($s,$i,1);
	}
	return $res;
}

/**
  * hex2dec - get the decimal value of a 2-digit hex string
  *
  * Since uPHP does not have a hex2dec function this can be used to quickly convert 2-character hex strings
  * into their equivalent byte value.
  *
  * @param string $b String containing 2 characteres (0-0,A-F)
  *
  * @return number Converted numeric value
  */
function hex2dec($b) {
    $b = strtoupper($b);
    $v=0;
    if (charat($b,0)>=ord('0') && charat($b,0)<=ord('9')) {
        $v+=(charat($b,0)-ord('0')) << 4;
    } else {
        $v+=(charat($b,0)-ord('A')+10) << 4;
    }
    if (charat($b,1)>=ord('0') && charat($b,1)<=ord('9')) {
        $v+=charat($b,1)-ord('0') ;
    } else {
        $v+=(charat($b,1)-ord('A')+10);
    }
    return $v;
}

?>



