<?
function widget_include($widget_number,$options) {
    $f=fopen($options['filename'],'r');
    $res='';
    if ($f) {
        while (!feof($f)) {
            $res.=fread($f,2048);
        }
        fclose($f);
    }
    
    return $res;
}
    
function diff_kwh_graph($widget_number,$options) {
    print("in diff_kwh_graph - ".$widget_number."\r\n");
    print_r($options);
    if (!$options) {
        $options=array();
        return '';
        $options['color']='#3398DB';
    }
    $data_point_name=$options['datapoint'];
    $num_days=intval($options['num_days']);
    $height=intval($options['num_days']);
    if (!$height) $height='300px';
    
    $res='<div id="container'.$widget_number.'" style="height: 300px"></div>
       
       <script type="text/javascript">
var dom'.$widget_number.' = document.getElementById("container'.$widget_number.'");
var myChart'.$widget_number.' = echarts.init(dom'.$widget_number.');
var app = {};'.'
option = null;
option = {
    color: ["'.$options['color'].'"],
    tooltip: {
        trigger: "axis",
        axisPointer: {            
            type: "shadow"'.'       
        }
    },
    grid: {
        left: "3%",
        right: "4%",
        bottom: "3%",'.'
        containLabel: true
    },
    xAxis: [
        {'.'
            type: "category",
            data: [';
    $prefix='';
    for ($i=$num_days+1;$i>0;$i--) {
        
        $res.=$prefix.'"{{DATE("%d/%m","'.$i.' DAY")}}"';
        $prefix=',';
    }
    $res.='],
            axisTick: {
                alignWithLabel: true
            }
        }'.'
    ],
    yAxis: [
        {
            type: "value"
        }
    ],
    series: [
        {'.'
            name: "kWh",
            type: "bar",
            barWidth: "60%",
            data: [';
    $prefix='';
    for ($i=$num_days+1;$i>0;$i--) {
        
        $res.=$prefix."{{DIFF('".$data_point_name."','1 DAY','".($i-1)." DAY')}}";
        $prefix=',';
    }        

        $res.=']
    }]
};
;
if (option && typeof option === "object") {
    myChart'.$widget_number.'.setOption(option, true);
}
       </script>';
       return $res;
}

include("/lib/uphp/string.inc");

function dynamic_graph($widget_number,$options) {
    print("in dynamic_graph - ".$widget_number."\r\n");
    print_r($options);
    if (!$options) {
        $options=array();
        return '';
        $options['color']='#3398DB';
    }
    
    $data_point_name=$options['datapoint'];
    $legend=$options['legend'];
    $num_days=intval($options['num_items']);
    $start=intval($options['start']);
    $height=intval($options['height']);
    if (!$height) $height='300px';
    
    $res='<div id="container'.$widget_number.'" style="height: 300px"></div>
       
       <script type="text/javascript">
var dom'.$widget_number.' = document.getElementById("container'.$widget_number.'");
var myChart'.$widget_number.' = echarts.init(dom'.$widget_number.');
var app = {};'.'
option = null;
option = {
    color: ["'.$options['color'].'"],
    tooltip: {
        trigger: "axis",
        axisPointer: {            
            type: "shadow"'.'       
        }
    },
    grid: {
        left: "3%",
        right: "4%",
        bottom: "3%",'.'
        containLabel: true
    },
    xAxis: [
        {'.'
            type: "category",
            data: [';
    $prefix='';
    for ($i=$num_days;$i>=$start;$i--) {
        
        $res.=$prefix.'"{{'.str_replace("$$",$i*intval($options['increment']),$legend).'}}"';
        $prefix=',';
    }
    $res.='],
            axisTick: {
                alignWithLabel: true
            }
        }'.'
    ],
    yAxis: [
        {
            type: "value"
        }
    ],
    series: [
        {'.'
            name: "kWh",
            type: "bar",
            barWidth: "60%",
            data: [';
    $prefix='';
    for ($i=$num_days;$i>=$start;$i--) {
        
        $res.=$prefix."{{".str_replace("$$",$i*intval($options['increment']),$data_point_name)."}}";
        $prefix=',';
    }        

        $res.=']
    }]
};
;
if (option && typeof option === "object") {
    myChart'.$widget_number.'.setOption(option, true);
}
       </script>';
       return $res;
}
?>
