<?
/**
 * @package Pyranometer
 * @author Akash Heimlich
 * @description This dummy widget shows the basic functionality of widgets and can be used as a starting point
 * for further development
 * @version 1.0
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function Pyranometer_install($val) {
        Pyranometer_enable();
        return 1;
    }
     
    function Pyranometer_uninstall() {
        setPackageStatus("Pyranometer",0);
        return 1;
    }
    
    function Pyranometer_enable() {
        setPackageStatus("Pyranometer",2);
        //addWidget("/package/Pyranometer.inc","Pyranometer",4,"icon-play",1,0); // enable
        
        $num_dev=mb_num_devices();
        $found_index=-1;
        $found_id=-1;
        for ($i=0; $i < $num_dev; $i++) {
            $dev=mb_get_dev_by_index($i);
            if ($dev['slave_id']==200 && $dev['device_type_id']==8010) {
                $found_index=$i;
                $found_id=$dev['slave_id'];
                break;
            }
        }
        if ($found_index==-1) {
            $res=mb_add_dev(200,8010,"Pyranometer",1000,1,100);
            if (!$res) {
                $_GLOBALS['pyra_idx']=mb_num_devices()-1;
                $_GLOBALS['pyra_id']=200;
            } else {
                log("Unable to add virtual device");
            }
        } else {
            $_GLOBALS['pyra_idx']=$found_index;
            $_GLOBALS['pyra_id']=$found_id;
            
            mb_set_dev_var($_GLOBALS['pyra_id'],"status",1);
        }
        return 1;
    }
    
    function Pyranometer_disable() {
        setPackageStatus("Pyranometer",3);
        //addWidget("/package/Pyranometer.inc","Pyranometer",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function Pyranometer_init() {
        $prefix='';
        if ($_SERVER['HW_PLATFORM']==11) {
            $prefix='0:';
        }
        if ($_SERVER['HW_PLATFORM']>=20) {  // ULTRA
                $prefix=intval($_GLOBALS['log_drive']).':';
}
        // load the test Value into the globals
        $_GLOBALS['pyra_mul']=ini_get("/config/Pyranometer.ini","config","pyra_mul",600);
        // the role id if set will be used, otherwise the A3 input will be used.
        $_GLOBALS['pyra_role']=ini_get("/config/Pyranometer.ini","config","pyra_role",0);
        
        $_GLOBALS['pyra_plant_size']=ini_get("/config/Pyranometer.ini","config","plant_size",0);
        $_GLOBALS['pyra_pr_ratio']=ini_get("/config/Pyranometer.ini","config","pr_ratio",0.8);
        
        $_GLOBALS['pyra_day'] = ini_get($prefix."/logs/Pyranometer.ini","config","kWh_Day_Irradiance",0.0);
        $_GLOBALS['kWh_Day_Potential'] = ini_get($prefix."/logs/Pyranometer.ini","config","kWh_Day_Potential",0.0);    
        $month_irradiance = ini_get($prefix."/logs/Pyranometer.ini","config","kWh_Month_Irradiance",0)+$_GLOBALS['pyra_day'];
        $_GLOBALS['kWh_Month_Irradiance']=$month_irradiance/1000;
        $life_irradiance = ini_get($prefix."/logs/Pyranometer.ini","config","kWh_Lifetime_Irradiance",0)+$_GLOBALS['pyra_day'];
        $_GLOBALS['kWh_Lifetime_Irradiance']=$life_irradiance/1000;
        
        log("Irradiation is now ".$_GLOBALS['pyra_day']);
        $num_dev=mb_num_devices();
        $found_index=-1;
        $found_id=-1;
        for ($i=0; $i < $num_dev; $i++) {
            $dev=mb_get_dev_by_index($i);
            if ($dev['slave_id']==200 && $dev['device_type_id']==8010) {
                $found_index=$i;
                $found_id=$dev['slave_id'];
                break;
            }
        }
        if ($found_index==-1) {
            $res=mb_add_dev(200,8010,"Pyranometer",1000,1,100);
            if (!$res) {
                $_GLOBALS['pyra_idx']=mb_num_devices()-1;
                $_GLOBALS['pyra_id']=200;
            } else {
                log("Unable to add virtual device");
            }
        } else {
            $_GLOBALS['pyra_idx']=$found_index;
            $_GLOBALS['pyra_id']=$found_id;
            mb_set_dev_var($_GLOBALS['pyra_id'],"status",1);
        }
        mb_set_dev_var($_GLOBALS['pyra_id'],'kWh_Day_Irradiance',$_GLOBALS['pyra_day']);
        mb_set_dev_var($_GLOBALS['pyra_id'],'roleval17',$month_irradiance/1000);
        mb_set_dev_var($_GLOBALS['pyra_id'],'roleval18',$life_irradiance/1000);

        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/Pyranometer.cgi?action=configure';
        $arr['title']='Pyranometer';
        $arr['icon']='icon-hdd';
        $arr['desc']='Irradiation Sensor Settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/pyranometer/PyranometerAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/pyranometer/PyranometerAjax.inc';

        // runs this file once a second
        if (file_exists('/package/pyranometer/PyranometerSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/pyranometer/PyranometerSec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/pyranometer/PyranometerMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/pyranometer/PyranometerMin.inc';
            
        // runs this file once a day
        if (file_exists('/package/pyranometer/PyranometerDay.inc')) 
            $_GLOBALS['hooks']['day'][]='/package/pyranometer/PyranometerDay.inc';            
        return 1;
    }
    
    function Pyranometer_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="Pyranometer"; 
        $title='Configure Package Pyranometer';
        $config_file="Pyranometer.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/pacman.cgi">Packages</a></li>
    <li class="breadcrumb-item active" aria-current="page">Pyranometer</li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-group"></i> Pyranometer / Irradiation Sensor</h2>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked' ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','user')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  Pyranometers measure solar irradiance.  These devices are used to calculate plant performance.  Most sensors have an anlog output in volts that needs to be multiplied
  by a fixed number to get a value in Watts.  For example, a 0-3V sensor with 0-1800W range would require a scale factor or multiplier of 600.
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
			

        </div><!--/span-->
      </div><!--/row-->
      
<div ng-init="pyra_mul=<? print(ini_get("/config/".$config_file,"config","pyra_mul",600)); ?>;">
<div ng-init="pyra_role=<? print(ini_get("/config/".$config_file,"config","pyra_role",0)); ?>;">
<div ng-init="plant_size=<? print(ini_get("/config/".$config_file,"config","plant_size",0)); ?>;">
<div ng-init="pr_ratio=<? print(ini_get("/config/".$config_file,"config","pr_ratio",0.8)); ?>;">
<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Sensor Settings</h5>
        <p class="card-text">    

          <div class="form-group">
            <label for="pyra_mul">Scale Factor</label>
            <input type="number" class="form-control" id="pyra_mul" ng-model="pyra_mul" aria-describedby="userHelp" placeholder="Enter scale factor">
            <small id="userHelp" class="form-text text-muted">The measured voltage will be multiplied by this to obtain the watt value</small>
          </div>
          <div class="form-group">
            <label for="pyra_role">Role</label>
            <select ng-model="pyra_role" name='pyra_role' class="custom-select custom-select-sm">
                <?
                $num_roles=ini_get("/config/roles.ini","roles","num_roles",0);
                for ($i=0;$i<$num_roles;$i++) {
                    print('<option value="'+$i+'">'.ini_get("/config/roles.ini","roles",'role'+$i,"").'</option>');
                }
                ?>
            </select>
            <small id="langH" class="form-text text-muted">Select an optional role to use as a voltage source or leave as undefined to use the default A3 input.</small>
          </div>
          <div class="form-group">
            <label for="plant_size">Plant Size</label>
            <input type="number" class="form-control" id="plant_size" ng-model="plant_size" aria-describedby="userHelp" placeholder="Enter plant size in kW">
            <small id="userHelp" class="form-text text-muted">Enter the plant size in kW</small>
          </div>
          <div class="form-group">
            <label for="pr_ratio">Static PR Ratio</label>
            <input type="number" class="form-control" id="pr_ratio" ng-model="pr_ratio" aria-describedby="userHelp" placeholder="PR Ratio">
            <small id="userHelp" class="form-text text-muted">Enter the performance ratio as a fraction (i.e. 0.8)</small>
          </div>
        </p>
    </div>
</div>
<br/>

        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function Pyranometer($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
     $scope.settings_locked=settings_locked;
    if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";

   $scope.saveSettings=function() {
       post_data="pyra_mul="+$scope.pyra_mul+
                "&plant_size="+$scope.plant_size+
                "&pr_ratio="+$scope.pr_ratio+
                "&pyra_role="+$scope.pyra_role;
       post_config="Pyranometer.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
       <?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>





