<?

function send_alert($alert_text,$type) {

    $send_mqtt = ini_get("/config/Alerts.ini","config","send_mqtt",0);
    $_GLOBALS['sysmsg']=$alert_text;
    if ($send_mqtt) {	            
        $mqtt_server = ini_get("/config/Alerts.ini","config","mqtt_server",0);
        $custom_formatter = ini_get("/config/Alerts.ini","config","mqtt_custom_formatter",'');
        if (file_exists($custom_formatter)) {
            include($custom_formatter);
        }
    	mqtt_publish(ini_get("/config/Alerts.ini","config","mqtt_channel","/"),$alert_text,$mqtt_server);
    	log("[alert] MQTT Alert sent: ".$alert_text." to ".$mqtt_channel);
    }

    $app=ini_get("/config/uphp.ini","app",0);
    if ($app) {
        mqtt_publish("/m2m/".getmac()."/wm2app/alert",$alert_text,2);
    }

    
    $send_export = ini_get("/config/Alerts.ini","config","send_export",0);
    if ($send_export)
        log($type.'|'.$alert_text,"/logs/alert.txt");
    
    
    $send_sms = ini_get("/config/Alerts.ini","config","send_sms",0);
    if ($send_sms) {
        $sms_number = ini_get("/config/Alerts.ini","config","sms_number",'');
        if (strlen($sms_number)) {
            $res=send_sms($alert_text,$sms_number);
            if ($res)
                log("[alert] SMS Alert sent: ".$alert_text." to ".$sms_number);
            else log("[alert] SMS Alert FAILED: ".$alert_text." to ".$sms_number);
        }
    }

    $send_email = ini_get("/config/Alerts.ini","config","send_email",0);
    if ($send_email) {
        $email_address = ini_get("/config/Alerts.ini","config","email_address",'');
        if (strlen($email_address)) {
            $device = ini_get("/config/user.ini","user","device",getmac());
            $res=send_email($email_address,'Alert from '.$device, $alert_text);
            if ($res)
                log("[alert] Email Alert sent: ".$alert_text." to ".$email_address);
            else log("[alert] Email Alert FAILED: ".$alert_text." to ".$email_address);
        }
    }

}

?>