<?
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : cronsec.cgi
 * 
 *  Description: CRON script that runs once a second
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013-2017 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich           v1.0
 * 
 * Change Log
 * 1
 * Description
 * Groups in Wattmon are stored in float indexed arrays, and their matching
 * indexes are:
            0: ah_in  - ampere hours in
            1: ah_out - ampere hours out
            2: ahd_in  - ampere hours in today
            3: ahd_out - 
            4: wd_in - watt hours in today
            5: wd_out
            6: kwh_in - lifetime kwh
            7: kwh_out
            8: am_in - amp counter per minute
            9: am_out
            10: a_in - current amps
            11: a_out
            12: w_in  - current watts
            13: w_out
            14: wm_in  - watt counter (appended per second)
            15: wm_out
              

 ************************************************************************/
 
// don't time out
error_reporting(0);

// only start once runonce has completed

if ($_GLOBALS['loaded'] && !$_GLOBALS['locked_min']) {
    
    
    $_GLOBALS['cnt']=$_GLOBALS['cnt']+1;

    // get the voltage, either from an external or an internal variable
    
    if (!$_GLOBALS['v_role']) {
        $v=adc_read(0);
        $v=floatval($_GLOBALS['v_adc_mul'])*(floatval($v)+floatval($_GLOBALS['v_adc_offset']));
    } else {
        $v = mb_get_val_by_role($_GLOBALS['v_role']);
    }
        
    $total_current=0;
    $total_watts=0;
    
    // iterate through all loaded groups, and update the ah and watt hour counters
    
    $numgrp=sizeof($_GLOBALS['grp']);
    
	for ($grp=0;$grp < $numgrp; $grp++) {
		if (is_array($_GLOBALS['grp']) && is_array($_GLOBALS['grp'][$grp]['vals'])) {
		    $numc=sizeof($_GLOBALS['grp'][$grp]['c']);
		    $numw=sizeof($_GLOBALS['grp'][$grp]['w']);
		    $current=0;
		    $vgrp=$v;
		    $w=0;
		              
		    // if this particular group has a voltage sensor associate with it, use it
		    
		    if ($_GLOBALS['grp'][$grp]['v']>0) {
		        $vgrp=mb_get_val_by_role($_GLOBALS['grp'][$grp]['v']);
		    }
		    for ($i=0;$i<$numc;$i++) {
		        $current = $current + mb_get_val_by_role($_GLOBALS['grp'][$grp]['c'][$i]['role']);
		    }
		    for ($i=0;$i<$numw;$i++) {
		        $wval=mb_get_val_by_role($_GLOBALS['grp'][$grp]['w'][$i]['role'])*$_GLOBALS['grp'][$grp]['w'][$i]['scale'];
		        // if the current exceeds the reated current for the group, it must be an error
		        if ($_GLOBALS['grp'][$grp]['rated_watts'] && ($wval >= $_GLOBALS['grp'][$grp]['rated_watts'])) {
					log("Error in Watts for group ".$grp." val=".$wval);
		            $wval=0;

				}
		        $w = $w + $wval;
		    }
		    if ($numc) {
		        if ($current>0) {
		            $_GLOBALS['grp'][$grp]['vals'][8] += $current;  // am_in
		            if (!$numw) {
		                $_GLOBALS['grp'][$grp]['vals'][12]=$current*$vgrp;  // w_in
		                $_GLOBALS['grp'][$grp]['vals'][13]=0;  // w_out
		            }
		            $_GLOBALS['grp'][$grp]['vals'][11]=0;  // a_out
		            $_GLOBALS['grp'][$grp]['vals'][10]=$current; // a_in
		            $_GLOBALS['grp'][$grp]['vals'][14] += $current*$vgrp;  // wn_in
		        } else {
		            $_GLOBALS['grp'][$grp]['vals'][9] += -$current;  // am_out
		            if (!$numw) {
		                $_GLOBALS['grp'][$grp]['vals'][13]=-$current*$vgrp;  // w_out
		                $_GLOBALS['grp'][$grp]['vals'][12]=0;  // w_in
		                $_GLOBALS['grp'][$grp]['vals'][15] -= $current*$vgrp;  // wn_in
		            }
		            $_GLOBALS['grp'][$grp]['vals'][10]=0;       // a_in
		            $_GLOBALS['grp'][$grp]['vals'][11]=$current;  // a_out
		        }
		    } 
		    if ($numw) {
		        if ($w>0) {
		            $_GLOBALS['grp'][$grp]['vals'][12]=$w;      // w_in
		            $_GLOBALS['grp'][$grp]['vals'][14] += $w;  // wn_in
					$_GLOBALS['grp'][$grp]['vals'][13]=0;  // w_out
		        } else {
		            $_GLOBALS['grp'][$grp]['vals'][13]=$w;  // w_out
		            $_GLOBALS['grp'][$grp]['vals'][15] += $w;  // wm_out
					$_GLOBALS['grp'][$grp]['vals'][12]=0; // w_in
		        }
		    } 
		    // if we have a watt register connected, override the calculated values
		    if ($_GLOBALS['grp'][$grp]['wr']) {
		            $watts=mb_get_val_by_role($_GLOBALS['grp'][$grp]['wr']);
		            if ($watts<0) {
		                $_GLOBALS['grp'][$grp]['vals'][12]+=$watts;  // w_in
		                $_GLOBALS['grp'][$grp]['vals'][13]=0;  // w_out
		                $_GLOBALS['grp'][$grp]['vals'][14] += $watts; // wn_in
		            } else {
		                $_GLOBALS['grp'][$grp]['vals'][12]=0;   // w_in
		                $_GLOBALS['grp'][$grp]['vals'][13]+=$watts;        // w_out
		                $_GLOBALS['grp'][$grp]['vals'][15] += $watts; // wm_out
		            }
		        
		    }
		    
		    // update the wattage
		    
		    
		    
		    // if this group is set to consolidate to the battery
		    
		    if ($_GLOBALS['grp'][$grp]['type']==1) {
		        $total_current += $current;
		        $total_watts += $current * $vgrp;
		    }
		    
		}
	}
    

            
    $_GLOBALS['battery_voltage']=$v;
    $_GLOBALS['total_current']=$total_current;
    $_GLOBALS['total_watts']=$total_watts;

    // if an anemometer is connected, calculate the wind speed
    if ($_GLOBALS['wind_role']) {
        $_GLOBALS['wind_speed_min']+=(floatval(mb_get_val_by_role($_GLOBALS['wind_role'])/$_GLOBALS['wind_div']))*$_GLOBALS['wind_mul']+$_GLOBALS['wind_offset'];
        $_GLOBALS['wind_speed']=$_GLOBALS['wind_speed_min']/$cnt;
    }
    //$_GLOBALS['debug']='';
    if ($_GLOBALS['firmware_logging']==0) {    
    for ($g=0;$g<$_GLOBALS['num_logs'];$g++) {
        $c1=sizeof( $_GLOBALS['minrole'.$g]);
      //  $_GLOBALS['debug']='size='.$c1;
        for ($i=0;$i<$c1;$i++) {
            $v=mb_get_val_by_role($_GLOBALS['minrole'.$g][$i]);
        //    $_GLOBALS['debug'].="l".$g."_role".$i."=".$_GLOBALS['minrole'.$g][$i]." val=".$v."\r\n";
            if ($_GLOBALS['minrole'.$g][$i]) {
                $v=mb_get_val_by_role($_GLOBALS['minrole'.$g][$i]);
            } else {
                if ($_GLOBALS['minvt'.$g][$i]==1)  { // sysvar
                    $v=$_GLOBALS['grp_memarr'.$g][$i*2];
                }
            }
            {
                if ($_GLOBALS['minfn'.$g][$i]==0) {
                    //if (!$_GLOBALS['minval'][$i]) {
                        $_GLOBALS['minval'.$g][$i]=$_GLOBALS['minval'.$g][$i]+$v;
                    //} else 
                    //$_GLOBALS['minval'][$i]=($_GLOBALS['minval'][$i]+$v)/2;
                } else {
                    if ($_GLOBALS['minfn'.$g][$i]==2) { // MAX
                        if ($_GLOBALS['minval'.$g][$i]<$v) $_GLOBALS['minval'.$g][$i]=$v;
                    } else { // MIN
                        if ($_GLOBALS['minfn'.$g][$i]==1) { // MIN
                            if (!$_GLOBALS['minval'.$g][$i] || ($_GLOBALS['minval'.$g][$i]>$v)) $_GLOBALS['minval'.$g][$i]=$v;
                        } else {    // just take the average value
                            $_GLOBALS['minval'.$g][$i]=$v;
                        }
                    }
                }
            } 
        }
    }
    }
    for ($ii=0;$ii<sizeof($_GLOBALS['hooks']['sec']);$ii++) {
        print("sec: ".$_GLOBALS['hooks']['sec'][$ii]);
        include($_GLOBALS['hooks']['sec'][$ii]);
    }
} else {
    // in case the min script times out, decrement a counter and reset it
    if ($_GLOBALS['locked_min']) {
        
        $_GLOBALS['locked_s']=$_GLOBALS['locked_s']+1;
        if ($_GLOBALS['locked_s']>15) 
            log("[cronsec] clearing lock as cronmin is active too long");{
            $_GLOBALS['locked_min']=0;
            $_GLOBALS['locked_s']=0;
        }
    }
}

 if (file_exists('/scripts/diagnostic.cgi')) {
        include('/scripts/diagnostic.cgi');
    }
?>




