<pre><?
include("/lib/uphp/debug.inc");

debug_start();



max_execution_time(30);
define("CUSTOM_EXPORT_LINES", 5);
$prefix='';
if ($_SERVER['HW_PLATFORM']==11) {
    $prefix='0:';
}
if ($_SERVER['HW_PLATFORM']>=20) {  // ULTRA
        $prefix=intval($_GLOBALS['log_drive']).':';
}

mkdir($prefix."/ini");


$ini                 = ini_get_array("/config/dataexport.ini", "export");
$ini['mqtt_lines'] = intval($ini['mqtt_lines']);
$ini['intervalmqtt'] = intval($ini['intervalmqtt']);
//$_GLOBALS['exportmqtt'] = intval($ini['intervalmqtt']);
$debug_custom_export = intval($ini['debug_custom_export']);
debug_print("Checking... cnt=".$_GLOBALS['exportmqttint'],'ip export mqtt','blue');
$tz_offset=ini_get("/config/time.ini","time","utc_offset",0)*3600;

if (!$ini['mqtt_lines'])
    $ini['mqtt_lines'] = CUSTOM_EXPORT_LINES;
//print($_GLOBALS['exportmqttint']);
$_GLOBALS['exportmqttint']++;
if ($_GLOBALS['exportmqttint'] >= intval($ini['intervalmqtt'])) {
   // if (intval($ini['noheader']) != 1) 
    $headers=array();
    {
        if (file_exists("/config/csv_headers.txt")) {
            debug_print('Found static csv_headers','headers');
            $fh=fopen("/config/csv_headers.txt","r");
            $data='';
            while (!feof($fh)) {
                
                $data.=fread($fh,1024);
            }
            $headers=explode($data,",");
            $data.="\r\n";
            fclose($fh);
        } else {
            $num_groups = ini_get("/config/datalog.ini", "data", "num_groups", 0);
            $data       = '"ts",';
            for ($i = 0; $i < $num_groups; $i++) {
                $s = ini_get("/config/datalog.ini", "data", 'group' + $i + 'status', 0);
                
                if ($s == 1) {
                    
                    $logfile2 = "/logs/log_" + $i + ".ini";
                    $arr      = ini_get_array($logfile2);
                    
                    $grpnvar = ini_get("/config/datalog.ini", "data", 'group' + $i + "numvar", 0);
                    for ($j = 0; $j < $grpnvar; $j++) {
                        $vt   = ini_get("/config/datalog.ini", "data", 'group' + $i + 'var' + $j + 'vartype', 0);
                        $vfn  = ini_get("/config/datalog.ini", "data", 'group' + $i + 'var' + $j + 'varfn', 0);
                        $vval = ini_get("/config/datalog.ini", "data", 'group' + $i + 'var' + $j + 'varval', 0);
                        if ($vt == 1) { // system
                            $varst = ini_get("/config/sysvars.ini", "sysvars", "sysvar" . $vval . "name", "");
                            $varr  = explode($varst, ';');
                            if ($varr[0] == 'V') {
                                $varst = $varr[1];
                            } else {
                                if ($varr[0] == 'G') {
                                    $varst = $varr[2] . $varr[1];
                                }
                            }
                        } else {
                            if ($vt == 2) { // device
                                $varst = ini_get("/config/roles.ini", "roles", "role" . $vval, "");
                            }
                            if ($vt == 3) { // global
                                //$varst=$vval;
                                $varst = ini_get("/config/datalog.ini", "data", 'group' + $i + 'var' + $j + 'varval', '');
                            }
                        }
                        //$data.="\"".$varst."\":\"".$arr['data']['p'.$j]."\"";
                        $data .= '"' . $varst . '"';
                        if ($j < ($grpnvar - 1))
                            $data .= ",";
                    }
                    
                }
            }
            //$data = $data . '\r\n';
            $headers=explode($data,",");
        }
    } 
    $last_export_time    = ini_get($prefix."/ini/datalog_status.ini", "mqtt", "last_export", 0);
    $last_export_file    = ini_get($prefix."/ini/datalog_status.ini", "mqtt", "file", "");
    $last_export_filepos = ini_get($prefix."/ini/datalog_status.ini", "mqtt", "filepos", 0);
    
    $logdir = $prefix."/logs/" + strftime("%Y", time()) . "/" . strftime("%m", time()) . "/";
    debug_print("1. last_export_file=" . $last_export_file,'file','blue');
    // month change bug
    // if this is new, just start from now
    if (!$last_export_file) {
        $last_export_time    = time();
        $m                   = strftime("%M", time());
        $h                   = strftime("%H", time());
        $last_export_file    = strftime("%Y%m%d", time()) . "_0.csv";
        $last_export_filepos = filesize($logdir . $last_export_file);
        ini_set($prefix."/ini/datalog_status.ini", "mqtt", "filepos", $last_export_filepos);
        ini_set($prefix."/ini/datalog_status.ini", "mqtt", "last_export", time());
        ini_set($prefix."/ini/datalog_status.ini", "mqtt", "file", $last_export_file);
        log("last_export_file not set, updating file pointer.");
        
    } else {
        $y = substr($last_export_file, 0, 4);
        $m = substr($last_export_file, 4, 2);
        
        $logdir = $prefix."/logs/" + $y . "/" . $m . "/";
    }
    debug_print("2. last_export_file=" . $last_export_file,'file');
    $last_size = filesize($logdir . $last_export_file);
    debug_print($last_size . " " . $last_export_filepos);
    debug_print("Comparison : last_size <= last_export_filepos + 10 = ".($last_size <= $last_export_filepos + 10),'file','blue');
    if ($last_size <= $last_export_filepos + 10) {
        $y = substr($last_export_file, 0, 4);
        $m = substr($last_export_file, 4, 2);
        $d = substr($last_export_file, 6, 2);
        debug_print("fn=" . $y . " " . $m . " " . $d,'file','green');
        $t = mktime(0, 0, 0, intval($m) - 1, intval($d), intval($y)) + 86400;
        
        $m = strftime("%m", $t);
        $d = strftime("%d", $t);
        $y = strftime("%Y", $t);
        if ($export_only) {
            $logdir          = $prefix."/logs/";
            $new_export_file = "log_" . $group_number . ".csv";
        } else {
            $logdir          = $prefix."/logs/" + $y . "/" . $m . "/";
            $new_export_file = strftime("%Y%m%d", $t) . "_0.csv";
        }
        debug_print("ts=".$t . " " . $logdir,"file","green");
        
        debug_print("Check for new file " . $new_export_file);
        if (!file_exists($logdir . $new_export_file)) {
            if (!$export_only) {
                if (($t < (time() - 86400 * 30)) || ($t > time())) {
                    $logdir          = $prefix."/logs/" + strftime("%Y", time()) . "/" . strftime("%m", time()) . "/";
                    $new_export_file = strftime("%Y%m%d", time()) . "_0.csv";
                    // if we have switched days
                    if ($new_export_file != $last_export_file) {
                        if ((time() - $last_export_time) > (intval($ini['intervalmqtt']) * 6)) {
                            $last_export_file    = $new_export_file;
                            $last_export_filepos = 0;
                            
                        }
                    }
                } else {
                    ini_set($prefix."/ini/datalog_status.ini", "mqtt", "filepos", 0);
                    ini_set($prefix."/ini/datalog_status.ini", "mqtt", "last_export", time());
                    ini_set($prefix."/ini/datalog_status.ini", "mqtt", "file", $new_export_file);
                    debug_print("switching to file " . $new_export_file);
                    die();
                }
            }
        } else {
            if (!$export_only) {
                $last_export_file    = $new_export_file;
                $last_export_filepos = 0;
            }
        }
    } else {
        //ini_set("/config/datalog_status.ini", "mqtt", "filepos", $last_size);
    }
    debug_print("3. last_export_file=" . $last_export_file,"file","green");
    $f_log = fopen($logdir . $last_export_file, "r");
    
    
    
    if ($f_log) {
        // navigate to the last saved pos
        fseek($f_log, $last_export_filepos, 0);
        $lines       = array();
        $export_size = 0;
       
        $fpos=ftell($f_log);
        log("[export] exporting from ".$fpos." in ".$last_export_file);
        
        for ($l = 0; $l < $ini['mqtt_lines']; $l++) {
            $st = fgets($f_log);
            if (!strlen($st) && !feof($st)) {
                $st = fgets($f_log);
            }
            //print("Len: ".strlen($st)."\r\n");
            if (strlen($st) == 254) {
                $st2 = $st;
                while (strlen($st2) == 254) {
                    $st2 = fgets($f_log);
                    $st .= $st2; //$st2='';
                }
                //$st2=fgets($f_log);
                //$st.=$st2;$st2='';
            }
            if (!$st) {
                break;
            }
            //$a=explode($st,',');
            $dt = intval(substr($st, 0, strpos($st, ',')));
            $dt = intval(strftime("%Y", $dt));
            debug_print("Line: " . $st ,"csv","green" );
            //print($dt."\r\n");
            //print_r($a);
            if ($dt >= 2015) {
                debug_print($dt." OK","csv","green");
                //$st.="\r\n";
                $export_size+=strlen($st)+2;  // add cr+lf
                $csv_size+=strlen($st)+2;
                if (strlen($st)) {
                    $lines[$l]=$st;
                } else $l--;
                $st="";
            } else {
                $l--;
                $csv_size += strlen($st);
                $export_size+=strlen($st)+2;
                debug_print("Year=" . $a . " skipping CSV line " . $st . " filepos=" . ftell($f_log) . " filesize=" . filesize($f_log),'csv','green');
                log("[csv] Year=" . $a . " skipping CSV line " . $st . " filepos=" . ftell($f_log) . " filesize=" . filesize($f_log));
            }
        }
        debug_print("EXPORT_SIZE=".$export_size,'csv');
        $export_size=ftell($f_log)-$last_export_filepos;  
        debug_print("EXPORT_SIZE2=".$export_size,'csv');
        if (feof($f_log) && !$l) {
            debug_print("jumping to next day",'file','green');
            log("Jumping to next day as no data available");
            
            $y1 = substr($last_export_file, 0, 4);
            $m1 = substr($last_export_file, 4, 2);
            $d1 = substr($last_export_file, 6, 2);
            debug_print("fn=" . $y1 . " " . $m1 . " " . $d1,'csv');
            $t = mktime(0, 0, 0, intval($m1) - 1, intval($d1), intval($y1)) + 86400;
            $m2 = strftime("%m", time());
            $d2 = strftime("%d", time());
            $y2 = strftime("%Y", time());
            
            $m = strftime("%m", $t);
            $d = strftime("%d", $t);
            $y = strftime("%Y", $t);
            debug_print ($y1." ".$m1." ".$d1." -- ".$y2." ".$m2." ".$d2,'csv');
            if (($m2==$m1) && ($d2==$d1) && ($y2==$y1)) {
                debug_print("at end of file in current day, abort",'csv','red');
                die();
            }
            if ($export_only) {
                $logdir          = $prefix."/logs/";
                $new_export_file = "log_" . $group_number . ".csv";
            } else {
                $logdir          = $prefix."/logs/" + $y . "/" . $m . "/";
                $new_export_file = strftime("%Y%m%d", $t) . "_0.csv";
            }
            
            // if we have switched days
            if ($new_export_file != $last_export_file) {
                debug_print("New file=" . $new_export_file . " and old file=" . $last_export_file,'csv','green');
                if ((time() - $last_export_time) > (intval($ini['intervalmqtt']) * 60)) {
                    debug_print("Updating file to new one",'csv','green');
                    $last_export_file    = $new_export_file;
                    $last_export_filepos = 0;
                    ini_set($prefix."/ini/datalog_status.ini", "mqtt", "filepos", $last_export_filepos);
                    ini_set($prefix."/ini/datalog_status.ini", "mqtt", "last_export", time());
                    ini_set($prefix."/ini/datalog_status.ini", "mqtt", "file", $last_export_file);
                } else {
                    debug_print((time() - $last_export_time) . ">" . (intval($ini['intervalmqtt']) * 60),'export','green');
                }
            }
            die();
            
        }
        debug_print("<pre>Found " . $l . " lines",'csv');
        debug_print("Export_file =" . $last_export_file ,'csv');
        debug_print("File_size =" . filesize($logdir . $last_export_file) ,'csv');
        debug_print("Export_size =" . $export_size,'csv');
        //print_r($lines);
        fclose($f_log);
        //$last_export_filepos=ftell($f)
        // only export data if something has changed
        if (strlen($_GLOBALS['log0buf'])) {
            $r=explode($_GLOBALS['log0buf'],"\r\n");
            for ($row=0;$row<sizeof($r);$row++) {
                $lines[]=$r[$row];
            }
        }
        if (sizeof($lines)) {
            //$dns_ip=ini_get("/config/dns.ini","dns","my.wattmon.com","my.wattmon.com");
            
            $url = $ini['mqtt_topic'];
            $mac=ini_get("/config/uphp.ini","debug","mac_override",getmac());
            $payload="{\"mac\":\"".$mac."\",\"data\":[";
                
            for ($line=0;$line<sizeof($lines);$line++) {
                if ($line) $payload.=",";
                $rows=explode($lines[$line],',');
                $payload.="{";
                $rows[0]=$rows[0]-$tz_offset; // adjust timezone 
                for ($col=0;$col<sizeof($headers);$col++) {
                    if ($col) 
                        $payload .= ",";
                    $payload.="\"".$headers[$col]."\":\"".$rows[$col]."\"";
                    //if ($col<sizeof($headers)-1) $payload.=",";
                }
                $payload.="}";

            }    
            $payload.="]}";
                
            debug_print("Payload=".$payload,'mqtt','green');
            mqtt_publish($ini['mqtt_topic'],$payload,$ini['mqtt_server']);
            $last_export_filepos += $export_size;
            ini_set($prefix."/ini/datalog_status.ini", "mqtt", "filepos", $last_export_filepos);
            ini_set($prefix."/ini/datalog_status.ini", "mqtt", "last_export", time());
            ini_set($prefix."/ini/datalog_status.ini", "mqtt", "file", $last_export_file);
                    // only wait if there is nothing to buffer
            if ($last_export_filepos >= $last_size)
                    $_GLOBALS['exportmqttint'] = 0; // restore for the next time
            }
            fclose($f);
            debug_print("finished executing custom-export.cgi",'finish','gray');
                
            $_GLOBALS['error3g'] = 0;
            
        } else { // nothing to export
            $_GLOBALS['exportmqttint'] = 0; // restore for the next time
            $_GLOBALS['error3g']         = 0;
        }
     // fopen
    
}

?>


