<h3>Sync Directories</h3><?

include("/lib/uphp/debug.inc");
if (!$_SESSION['logged_in']) {
    debug_print("Please log in to do this","init","red");
    die();
    
}

if (!$_GET['src'] || !$_GET['dest']) {
    debug_print("Please include src= and dest= parameters - i.e src=0:/dev/&dest=1:/dev/ to sync SD card /dev/ folder to flash drive.  Ensure both folders exist","init","red");
    die();
}
if (function_exists('set_buffering')) {
    set_buffering(0); // disable buffering
}
debug_start();


max_execution_time(600);

 if ($_SERVER['HW_PLATFORM']==11  || $_SERVER['HW_PLATFORM']>=20) {
    $cur_drive=get_drive(); 
    if ((substr($_GET['dest'],0,2)=="0:")) $cur_drive=0;
    if ((substr($_GET['dest'],0,2)=="1:")) $cur_drive=1;
    if ((substr($_GET['dest'],0,2)=="2:")) $cur_drive=2;
    
    if (disk_status($cur_drive)==1 || disk_status($cur_drive)==2) {
        debug_print("Drive not mounted","init","red");
        die();
    } else if (disk_status($cur_drive)==4){
        debug_print("Drive is write protected","init","red");
        die();
    }
    
    
}
$start_time=time();

debug_print("Scanning ".$_GET['src']." - please wait as this can take some time","init","green");
chdir($_GET['src']);
$arr=findfirst("*.*",255-8);
mkdir($_GET['dest']);
$has_parent=0;
$cnt=0;
$pattern="^[\ ()a-zA-Z0-9_.-~\-]*$";
while ($arr) {
    if (($arr['attributes'] & 16)) {
    } else {
        $val=$arr["filename"];
        ereg($pattern,$arr["filename"]);
        if (!$val) {
        } else {
            $md5_src=md5_file($_GET['src'].$val);
            $copy=0;
            if (file_exists($_GET['dest'].$val)) {
                if (md5_file($_GET['dest'].$val)!=$md5_src) {
                    $copy=1;
                } else {
                    print("<span>");
                    debug_print("File ".$val." is identical","skip","grey");
                    print("</span>");
                }
            } else $copy=1;
            if ($copy) {
                $cnt++;
                print("<span>");
                debug_print("Copying ".$val." from  ".$_GET['src'],"sync","green");
                print("</span>");
                $f_dest=fopen($_GET['dest'].$val,"w");
                if ($f_dest) {
                    $f_src=fopen($_GET['src'].$val,"r");
                    if ($f_src) {
                        $f_pos=0;
                        while (!feof($f_src)) {
                            $block_size=filesize($f_src)-$f_pos;
                            if ($block_size > 512) 
                                $block_size=512;
                            $data=fread($f_src,$block_size);
                            $f_pos=ftell($f_src);
                            fwrite($f_dest,&$data,$block_size);
                        }
                        fclose($f_src);
                    }
                    fclose($f_dest);
                }
            }
        }
            
    }
    $arr=findnext();
}


debug_print("Completed - ".$cnt." files copied - runtime=".(time()-$start_time)." seconds.","terminate","green");
?></pre>





