<?
/**
 * @package FTP
 * @author Akash Heimlich
 * @description FTP Export of CSV files
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    function FTP_install($val) {
        FTP_enable();
        return 1;
    }
     
    function FTP_uninstall() {
        setPackageStatus("FTP",0);
        return 1;
    }
    
    function FTP_enable() {
        setPackageStatus("FTP",2);
        return 1;
    }
    
    function FTP_disable() {
        setPackageStatus("FTP",3);
        return 1;
    }
    
    /* this is called at system boot */
    function FTP_init() {
        
        // load the test Value into the globals
//        $_GLOBALS['ftp_path']=ini_get("/config/ftp.ini","config","ftp_path","");
//        $_GLOBALS['ftp_url']=ini_get("/config/ftp.ini","config","ftp_url","");
       
        
//        $_GLOBALS['ftp_username']=ini_get("/config/ftp.ini","config","ftp_username","");
//        $_GLOBALS['ftp_password']=ini_get("/config/ftp.ini","config","ftp_password","");
        $_GLOBALS['ftp_interval']=ini_get("/config/ftp.ini","config","ftp_interval",15);
        $_GLOBALS['ftp_secure']=ini_get("/config/ftp.ini","config","ftp_secure",0);
        $_GLOBALS['ftp_lines']=ini_get("/config/ftp.ini","config","ftp_lines",5);
        
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/FTP.cgi?action=configure';
        $arr['title']='FTP';
        $arr['icon']='icon-hdd';
        $arr['desc']='FTP  Settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/ftp/FTPAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/ftp/FTPAjax.inc';

        // runs this file once a second
        if (file_exists('/package/ftp/FTPSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/ftp/FTPSec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/ftp/FTPMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/ftp/FTPMin.inc';
            
        // runs this file once a day
        if (file_exists('/package/ftp/FTPDay.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/ftp/FTPDay.inc';            

        return 1;
    }
    
    function FTP_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="FTP"; 
        $title='Configure Package FTP';
        $config_file="ftp.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> 
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page">FTP Export</li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-group"></i> FTP Export</h2>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','user')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-warning" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

<div ng-init="ftp_path='<? print(ini_get("/config/".$config_file,$config_section,"ftp_path","")); ?>';">
<div ng-init="ftp_url='<? print(ini_get("/config/".$config_file,$config_section,"ftp_url","")); ?>';">
<div ng-init="ftp_username='<? print(ini_get("/config/".$config_file,$config_section,"ftp_username","")); ?>';">
<div ng-init="ftp_password='<? print(ini_get("/config/".$config_file,$config_section,"ftp_password","")); ?>';">
<div ng-init="ftp_interval=<? print(ini_get("/config/".$config_file,$config_section,"ftp_interval",15)); ?>;">
<div ng-init="ftp_enabled=<? print(ini_get("/config/".$config_file,$config_section,"ftp_enabled",1)); ?>;">
<div ng-init="ftp_port=<? print(ini_get("/config/".$config_file,$config_section,"ftp_port",21)); ?>;">
<div ng-init="ftp_secure=<? print(ini_get("/config/".$config_file,$config_section,"ftp_secure",0)); ?>;">
<div ng-init="ftp_ignore_response=<? print(ini_get("/config/".$config_file,$config_section,"ftp_ignore_response",0)); ?>;">
<div ng-init="ftp_lines=<? print(ini_get("/config/".$config_file,$config_section,"ftp_lines",5)); ?>;">
<div ng-init="ftp_partial_upload=<? print(ini_get("/config/".$config_file,$config_section,"ftp_partial_upload",0)); ?>;">
<div ng-init="multiple_files=<? print(ini_get("/config/".$config_file,$config_section,"multiple_files",0)); ?>;">
<div ng-init="ftp_prefix='<? print(ini_get("/config/".$config_file,$config_section,"ftp_prefix","")); ?>';">

<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('ADMIN_SETTINGS','user')) ?></h5>
        <p class="card-text">    
            <div class="form-group">
                <label for="ftp_enabled"><small class='text-muted'>Status</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ftp_enabled" id="exampleRadios5" value="0">
                  <label class="form-check-label" for="exampleRadios5">
                    &nbsp;Disabled
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ftp_enabled" id="exampleRadios6" value="1">
                  <label class="form-check-label" for="exampleRadios6">
                    &nbsp;Enabled
                  </label>
                </div>  
                <small id="dnHelp" class="form-text text-muted">Status of the FTP uploading package - Disable to stop updating</small>
            </div> 
          <div class="form-group">
            <label for="ftp_path">FTP Server Path</label>
            <input type="text" class="form-control" id="ftp_path" ng-model="ftp_path" aria-describedby="ftp_pathHelp" placeholder="Enter FTP Server Path">
            <small id="ftp_pathHelp" class="form-text text-muted">Enter path on FTP server with / at end</small>
          </div>
          <div class="form-group">
            <label for="ftp_url">FTP Server Hostname</label>
            <input type="text" class="form-control" id="ftp_url" ng-model="ftp_url" aria-describedby="ftp_urlHelp" placeholder="Enter FTP Server Host">
            <small id="ftp_urlHelp" class="form-text text-muted">FTP Server Hostname</small>
          </div>
          <div class="form-group">
            <label for="ftp_port">FTP Port</label>
            <input type="text" class="form-control" id="ftp_port" ng-model="ftp_port" aria-describedby="ftp_portHelp" placeholder="Port">
            <small id="ftp_portHelp" class="form-text text-muted">FTP Port Number</small>
          </div>
          
            <div class="form-group">
                <label for="ftp_secure"><small class='text-muted'>Protocol</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ftp_secure" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;FTP
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ftp_secure" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;SFTP
                  </label>
                </div>  
                <small id="dnHelp" class="form-text text-muted"><? print(lang('STATUS_HELP','deviceadd')) ?></small>
            </div>          
          <div class="form-group">
            <label for="ftp_username">FTP Username</label>
            <input type="text" class="form-control" id="ftp_username" ng-model="ftp_username" aria-describedby="ftp_usernameHelp" placeholder="Username">
            <small id="ftp_usernameHelp" class="form-text text-muted">FTP Username</small>
          </div>
           <div class="form-group">
            <label for="ftp_password">FTP Password</label>
            <input type="password" class="form-control" id="ftp_password" ng-model="ftp_password" aria-describedby="ftp_passwordHelp" placeholder="Password">
            <small id="ftp_passwordHelp" class="form-text text-muted">FTP Password</small>
          </div>
          <div class="form-group">
            <label for="ftp_interval">FTP Interval (between data writes)</label>
            <input type='number' min=1 max=30 ng-model="ftp_interval"  name='ftp_interval' t aria-describedby="ftp_intHelp" placeholder="Enter Interval">
            <small id="ftp_intHelp" class="form-text text-muted">FTP Interval in Minutes (between inverter data) * max=30</small>
          </div>
          <div class="form-group">
            <label for="ftp_port">Partial Upload Size</label>
            <input type="text" class="form-control" id="ftp_partial_upload" ng-model="ftp_partial_upload" aria-describedby="ftp_partialHelp" placeholder="Partial Uplaod">
            <small id="ftp_partialHelp" class="form-text text-muted">Number of bytes to upload per iteration, leave at 0 for entire file.</small>
          </div>
          
          <div class="form-group">
                <label for="multiple_files"><small class='text-muted'>Upload mode</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="multiple_files" id="multiple_filesxampleRadios1" value="0">
                  <label class="form-check-label" for="multiple_filesexampleRadios1">
                    &nbsp;Single file (using REST function)
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="multiple_files" id="multiple_filesexampleRadios2" value="1">
                  <label class="form-check-label" for="multiple_filesexampleRadios2">
                    &nbsp;Multiple files (new file on every upload)
                  </label>
                </div>  
                <small id="dnHelp" class="form-text text-muted">Select multiple files mode to have many smaller FTP files for sites that don't support REST </small>
            </div>   
            <div class="form-group">
                <label for="ftp_ignore_response"><small class='text-muted'>Ignore Response</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ftp_ignore_response" id="exampleRadios3" value="0">
                  <label class="form-check-label" for="exampleRadios3">
                    &nbsp;No (Default)
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ftp_ignore_response" id="exampleRadios4" value="1">
                  <label class="form-check-label" for="exampleRadios4">
                    &nbsp;Yes
                  </label>
                </div>  
                <small id="dnHelp" class="form-text text-muted">Same servers have issues with upload complete notifications.  Set this to Yes if you are experiencing issues</small>
            </div>                      
            <div class="form-group" ng-show="multiple_files==1">
            <label for="ftp_prefix">File prefix</label>
            <input type="text" class="form-control" id="ftp_prefix" ng-model="ftp_prefix" aria-describedby="ftp_prefixHelp" placeholder="Prefix">
            <small id="ftp_prefixHelp" class="form-text text-muted">FTP Prefix to add before each filename</small>
          </div>
        </p>
    </div>
</div>
	 

</form>
<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function FTP($scope, $timeout,$http) {
   var self = this;
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
      
       post_data="ftp_path="+$scope.ftp_path;
       post_data+="&ftp_username="+$scope.ftp_username;
       
       post_data+="&ftp_password="+btoa(encodeURIComponent($scope.ftp_password));
       post_data+="&ftp_interval="+$scope.ftp_interval;
       post_data+="&ftp_secure="+$scope.ftp_secure;
       post_data+="&ftp_port="+$scope.ftp_port;       
       post_data+="&ftp_enabled="+$scope.ftp_enabled;
       post_data+="&ftp_ignore_response="+$scope.ftp_ignore_response;
       post_data+="&ftp_lines="+$scope.ftp_lines;
       post_data+="&ftp_url="+$scope.ftp_url;
       post_data+="&ftp_prefix="+$scope.ftp_prefix;
       post_data+="&ftp_partial_upload="+$scope.ftp_partial_upload;
       post_data+="&multiple_files="+$scope.multiple_files;
       post_data+="&encoded_keys=ftp_password";
       
       post_config="ftp.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
      <?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>





